/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.inventory.screens;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.shim.celestialexploration.CelestialExploration;
import com.shim.celestialexploration.capabilities.TaxiCapability;
import com.shim.celestialexploration.inventory.menus.SpaceTaxiMenu;
import com.shim.celestialexploration.registry.CelestialDimensions;
import com.shim.celestialexploration.registry.CelestialTags;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;

public class SpaceTaxiScreen
extends AbstractContainerScreen<SpaceTaxiMenu> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("celestialexploration", "textures/gui/space_taxi.png");
    private List<Component> tooltip = Lists.newArrayList();
    private boolean isFirstEntitySelected = false;
    Vec2 firstEntityLoc;
    Entity firstEntity;
    private boolean isSecondEntitySelected = false;
    Vec2 secondEntityLoc;
    Entity secondEntity;
    private boolean isLocationSelected = false;
    Vec2 location;

    public SpaceTaxiScreen(SpaceTaxiMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.f_97726_ = 276;
        this.f_97730_ = 107;
    }

    protected void m_7286_(PoseStack poseStack, float partialTick, int mouseX, int mouseY) {
        int xPos;
        int yPos;
        int i;
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        SpaceTaxiScreen.m_93143_((PoseStack)poseStack, (int)x, (int)y, (int)this.m_93252_(), (float)0.0f, (float)0.0f, (int)this.f_97726_, (int)this.f_97727_, (int)512, (int)256);
        if (this.isFirstEntitySelected && this.firstEntityLoc != null) {
            SpaceTaxiScreen.m_93143_((PoseStack)poseStack, (int)(x + (int)this.firstEntityLoc.f_82470_ - 1), (int)(y + (int)this.firstEntityLoc.f_82471_ - 1), (int)this.m_93252_(), (float)(this.f_97726_ + 1), (float)64.0f, (int)18, (int)18, (int)512, (int)256);
        }
        if (this.isSecondEntitySelected && this.secondEntityLoc != null) {
            SpaceTaxiScreen.m_93143_((PoseStack)poseStack, (int)(x + (int)this.secondEntityLoc.f_82470_ - 1), (int)(y + (int)this.secondEntityLoc.f_82471_ - 1), (int)this.m_93252_(), (float)(this.f_97726_ + 1), (float)83.0f, (int)18, (int)18, (int)512, (int)256);
        }
        if (this.isLocationSelected && this.location != null) {
            SpaceTaxiScreen.m_93143_((PoseStack)poseStack, (int)(x + (int)this.location.f_82470_ - 1), (int)(y + (int)this.location.f_82471_ - 1), (int)this.m_93252_(), (float)(this.f_97726_ + 1), (float)64.0f, (int)18, (int)18, (int)512, (int)256);
        }
        if (this.isFirstEntitySelected && this.isLocationSelected && ((SpaceTaxiMenu)this.f_97732_).hasEmeralds()) {
            SpaceTaxiScreen.m_93143_((PoseStack)poseStack, (int)(x + 213), (int)(y + 64 - 19 - 4), (int)this.m_93252_(), (float)(this.f_97726_ + 1), (float)45.0f, (int)18, (int)18, (int)512, (int)256);
        }
        for (i = 0; i < Math.min(((SpaceTaxiMenu)this.f_97732_).getNearbyEntites().size(), 20); ++i) {
            Entity entity = ((SpaceTaxiMenu)this.f_97732_).getNearbyEntites().get(i);
            yPos = i < 5 ? 0 : (i < 10 ? 18 : (i < 15 ? 36 : 54));
            xPos = i % 5 == 0 ? 0 : (i % 5 == 1 ? 18 : (i % 5 == 2 ? 36 : (i % 5 == 3 ? 54 : 72)));
            if (entity instanceof Villager) {
                SpaceTaxiScreen.m_93143_((PoseStack)poseStack, (int)(x + 12 + xPos), (int)(y + 22 + yPos), (int)this.m_93252_(), (float)(this.f_97726_ + 1), (float)37.0f, (int)8, (int)8, (int)512, (int)256);
                continue;
            }
            if (entity.m_6095_().m_204039_(CelestialTags.Entities.FARM_ANIMALS)) {
                SpaceTaxiScreen.m_93143_((PoseStack)poseStack, (int)(x + 12 + xPos), (int)(y + 22 + yPos), (int)this.m_93252_(), (float)(this.f_97726_ + 10), (float)37.0f, (int)8, (int)8, (int)512, (int)256);
                continue;
            }
            if (entity instanceof Mob) {
                SpaceTaxiScreen.m_93143_((PoseStack)poseStack, (int)(x + 12 + xPos), (int)(y + 22 + yPos), (int)this.m_93252_(), (float)(this.f_97726_ + 10 + 18), (float)37.0f, (int)8, (int)8, (int)512, (int)256);
                continue;
            }
            SpaceTaxiScreen.m_93143_((PoseStack)poseStack, (int)(x + 12 + xPos), (int)(y + 22 + yPos), (int)this.m_93252_(), (float)(this.f_97726_ + 19), (float)37.0f, (int)8, (int)8, (int)512, (int)256);
        }
        for (i = 0; i < Math.min(((SpaceTaxiMenu)this.f_97732_).getTaxiStations().size(), 20); ++i) {
            ResourceKey<Level> dimension = ((SpaceTaxiMenu)this.f_97732_).getTaxiStations().get(i).dimension();
            yPos = i < 5 ? 0 : (i < 10 ? 18 : (i < 15 ? 36 : 54));
            xPos = i % 5 == 0 ? 0 : (i % 5 == 1 ? 18 : (i % 5 == 2 ? 36 : (i % 5 == 3 ? 54 : 72)));
            int dimOffset = dimension.equals(CelestialDimensions.MERCURY) ? 0 : (dimension.equals(CelestialDimensions.VENUS) ? 9 : (dimension.equals((Object)Level.f_46428_) ? 18 : (dimension.equals(CelestialDimensions.MOON) ? 27 : (dimension.equals(CelestialDimensions.MARS) ? 36 : (dimension.equals(CelestialDimensions.JUPITER) ? 45 : 81)))));
            SpaceTaxiScreen.m_93143_((PoseStack)poseStack, (int)(x + 12 + xPos), (int)(y + 110 + yPos), (int)this.m_93252_(), (float)(this.f_97726_ + 1 + dimOffset), (float)28.0f, (int)8, (int)8, (int)512, (int)256);
        }
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float delta) {
        int yPos;
        int xPos;
        int k;
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, mouseX, mouseY, delta);
        this.m_7025_(poseStack, mouseX, mouseY);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        int i = this.f_97735_;
        int j = this.f_97736_;
        for (k = 0; k < Math.min(((SpaceTaxiMenu)this.f_97732_).getNearbyEntites().size(), 20); ++k) {
            Entity entity = ((SpaceTaxiMenu)this.f_97732_).getNearbyEntites().get(k);
            xPos = k % 5 == 0 ? 0 : (k % 5 == 1 ? 18 : (k % 5 == 2 ? 36 : (k % 5 == 3 ? 54 : 72)));
            if (!this.m_6774_(x - i + 12 + xPos - 4, y - j + 22 + (yPos = k < 5 ? 0 : (k < 10 ? 18 : (k < 15 ? 36 : 54))) - 4, 16, 16, mouseX, mouseY)) continue;
            SpaceTaxiScreen.renderHighlight(poseStack, i + 12 + xPos - 4, j + 22 + yPos - 4, 16, 16, this.m_93252_(), this.slotColor, this.slotColor);
            this.tooltip = Lists.newArrayList();
            if (entity instanceof Villager) {
                Villager villager = (Villager)entity;
                if (villager.m_7755_().getString().equalsIgnoreCase(SpaceTaxiScreen.getTypeName(villager).getString())) {
                    this.tooltip.add((Component)new TextComponent(villager.m_7755_().getString()));
                } else {
                    this.tooltip.add((Component)new TextComponent(villager.m_7755_().getString() + " (" + SpaceTaxiScreen.getTypeName(villager).getString() + ")"));
                }
                this.tooltip.add((Component)new TextComponent("Lvl: " + villager.m_7141_().m_35576_()));
            } else {
                this.tooltip.add(entity.m_5446_());
            }
            this.tooltip.add((Component)new TextComponent("XYZ: " + entity.m_146903_() + " / " + entity.m_146904_() + " / " + entity.m_146907_()));
            this.m_96597_(poseStack, this.tooltip, mouseX, mouseY);
        }
        for (k = 0; k < Math.min(((SpaceTaxiMenu)this.f_97732_).getTaxiStations().size(), 15); ++k) {
            String dimension = ((SpaceTaxiMenu)this.f_97732_).getTaxiStations().get(k).dimension().m_135782_().m_135815_();
            xPos = k % 5 == 0 ? 0 : (k % 5 == 1 ? 18 : (k % 5 == 2 ? 36 : (k % 5 == 3 ? 54 : 72)));
            if (!this.m_6774_(x - i + 12 + xPos - 4, y - j + 110 + (yPos = k < 5 ? 0 : (k < 10 ? 18 : 36)) - 4, 16, 16, mouseX, mouseY)) continue;
            SpaceTaxiScreen.renderHighlight(poseStack, i + 12 + xPos - 4, j + 110 + yPos - 4, 16, 16, this.m_93252_(), this.slotColor, this.slotColor);
            this.tooltip = Lists.newArrayList();
            this.tooltip.add(((SpaceTaxiMenu)this.f_97732_).getTaxiStations().get(k).name());
            BlockPos pos = ((SpaceTaxiMenu)this.f_97732_).getTaxiStations().get(k).pos();
            this.tooltip.add((Component)new TextComponent("XYZ: " + pos.m_123341_() + " / " + pos.m_123342_() + " / " + pos.m_123343_()));
            this.tooltip.add((Component)new TranslatableComponent("dimension.celestialexploration." + dimension));
            this.m_96597_(poseStack, this.tooltip, mouseX, mouseY);
        }
        if (this.m_6774_(x - i + 213, y - j + 41, 16, 16, mouseX, mouseY)) {
            this.tooltip = Lists.newArrayList();
            this.tooltip.add((Component)new TranslatableComponent("entity.spacetaxi.sendoff"));
            this.m_96597_(poseStack, this.tooltip, mouseX, mouseY);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int p_97777_) {
        if (this.checkEntityClicked(mouseX, mouseY, false)) {
            return true;
        }
        if (this.checkLocationClicked(mouseX, mouseY, false)) {
            return true;
        }
        if (this.checkSendOffButton(mouseX, mouseY)) {
            return true;
        }
        return super.m_6375_(mouseX, mouseY, p_97777_);
    }

    public boolean m_6348_(double mouseX, double mouseY, int p_97814_) {
        if (this.checkEntityClicked(mouseX, mouseY, true)) {
            return true;
        }
        if (this.checkLocationClicked(mouseX, mouseY, true)) {
            return true;
        }
        if (this.checkSendOffButton(mouseX, mouseY)) {
            CelestialExploration.LOGGER.debug("clicked and released button");
            ((SpaceTaxiMenu)this.f_97732_).setButtonClicked();
            return true;
        }
        return super.m_6348_(mouseX, mouseY, p_97814_);
    }

    private boolean checkEntityClicked(double mouseX, double mouseY, boolean isClickReleased) {
        Slot slot = this.m_97744_(mouseX, mouseY);
        if (slot != null) {
            return false;
        }
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        int i = this.f_97735_;
        int j = this.f_97736_;
        for (int k = 0; k < Math.min(((SpaceTaxiMenu)this.f_97732_).getNearbyEntites().size(), 20); ++k) {
            int yPos;
            Entity entity = ((SpaceTaxiMenu)this.f_97732_).getNearbyEntites().get(k);
            int xPos = k % 5 == 0 ? 0 : (k % 5 == 1 ? 18 : (k % 5 == 2 ? 36 : (k % 5 == 3 ? 54 : 72)));
            if (!this.m_6774_(x - i + 12 + xPos - 4, y - j + 22 + (yPos = k < 5 ? 0 : (k < 10 ? 18 : (k < 15 ? 36 : 54))) - 4, 16, 16, mouseX, mouseY)) continue;
            if (isClickReleased) {
                this.toggleEntitySelection(x - i + 12 + xPos - 4, y - j + 22 + yPos - 4, entity);
            }
            return true;
        }
        return false;
    }

    private void toggleEntitySelection(double x, double y, Entity entity) {
        if (!this.isFirstEntitySelected) {
            this.isFirstEntitySelected = true;
            this.firstEntityLoc = new Vec2((float)x, (float)y);
            this.firstEntity = entity;
            ((SpaceTaxiMenu)this.f_97732_).setSelectedEntity(entity, 1);
        } else if (x == (double)this.firstEntityLoc.f_82470_ && y == (double)this.firstEntityLoc.f_82471_) {
            this.isFirstEntitySelected = false;
            this.firstEntityLoc = null;
            if (this.isSecondEntitySelected) {
                this.isFirstEntitySelected = true;
                this.isSecondEntitySelected = false;
                this.firstEntityLoc = this.secondEntityLoc;
                this.secondEntityLoc = null;
                this.firstEntity = this.secondEntity;
                this.secondEntity = null;
                ((SpaceTaxiMenu)this.f_97732_).setSelectedEntity(entity, 1);
            }
        } else if (!this.isSecondEntitySelected) {
            this.isSecondEntitySelected = true;
            this.secondEntityLoc = new Vec2((float)x, (float)y);
            this.secondEntity = entity;
            ((SpaceTaxiMenu)this.f_97732_).setSelectedEntity(entity, 2);
        } else if (x == (double)this.secondEntityLoc.f_82470_ && y == (double)this.secondEntityLoc.f_82471_) {
            this.isSecondEntitySelected = false;
            this.secondEntityLoc = null;
            this.secondEntity = null;
        }
    }

    private boolean checkLocationClicked(double mouseX, double mouseY, boolean isClickReleased) {
        Slot slot = this.m_97744_(mouseX, mouseY);
        if (slot != null) {
            return false;
        }
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        int i = this.f_97735_;
        int j = this.f_97736_;
        for (int k = 0; k < Math.min(((SpaceTaxiMenu)this.f_97732_).getTaxiStations().size(), 20); ++k) {
            int yPos;
            TaxiCapability.TaxiStationData station = ((SpaceTaxiMenu)this.f_97732_).getTaxiStations().get(k);
            int xPos = k % 5 == 0 ? 0 : (k % 5 == 1 ? 18 : (k % 5 == 2 ? 36 : (k % 5 == 3 ? 54 : 72)));
            if (!this.m_6774_(x - i + 12 + xPos - 4, y - j + 110 + (yPos = k < 5 ? 0 : (k < 10 ? 18 : (k < 15 ? 36 : 54))) - 4, 16, 16, mouseX, mouseY)) continue;
            if (isClickReleased) {
                this.toggleLocationSelection(x - i + 12 + xPos - 4, y - j + 110 + yPos - 4, station);
            }
            return true;
        }
        return false;
    }

    private void toggleLocationSelection(double x, double y, TaxiCapability.TaxiStationData station) {
        if (!this.isLocationSelected) {
            this.isLocationSelected = true;
            this.location = new Vec2((float)x, (float)y);
            ((SpaceTaxiMenu)this.f_97732_).setSelectedLocation(station);
        } else {
            this.isLocationSelected = false;
            this.location = null;
        }
    }

    private boolean checkSendOffButton(double mouseX, double mouseY) {
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        int i = this.f_97735_;
        int j = this.f_97736_;
        if (this.isFirstEntitySelected && this.isLocationSelected && ((SpaceTaxiMenu)this.f_97732_).hasEmeralds()) {
            return this.m_6774_(x - i + 213, y - j + 41, 16, 16, mouseX, mouseY);
        }
        return false;
    }

    @Nullable
    private Slot m_97744_(double x, double y) {
        for (int i = 0; i < ((SpaceTaxiMenu)this.f_97732_).f_38839_.size(); ++i) {
            Slot slot = (Slot)((SpaceTaxiMenu)this.f_97732_).f_38839_.get(i);
            if (!this.m_97774_(slot, x, y) || !slot.m_6659_()) continue;
            return slot;
        }
        return null;
    }

    private boolean m_97774_(Slot slot, double x, double y) {
        return this.m_6774_(slot.f_40220_, slot.f_40221_, 16, 16, x, y);
    }

    protected static Component getTypeName(Villager villager) {
        ResourceLocation profName = villager.m_7141_().m_35571_().getRegistryName();
        return new TranslatableComponent(villager.m_6095_().m_20675_() + "." + (String)(!"minecraft".equals(profName.m_135827_()) ? profName.m_135827_() + "." : "") + profName.m_135815_());
    }

    public static void renderHighlight(PoseStack poseStack, int pX, int pY, int width, int height, int pBlitOffset, int slotColor, int slotColor2) {
        RenderSystem.m_69465_();
        RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        SpaceTaxiScreen.m_168740_((PoseStack)poseStack, (int)pX, (int)pY, (int)(pX + width), (int)(pY + height), (int)slotColor, (int)slotColor2, (int)pBlitOffset);
        RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.m_69482_();
    }
}

