/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.inventory.screens;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.shim.celestialexploration.CelestialExploration;
import com.shim.celestialexploration.capabilities.LightTravelCapability;
import com.shim.celestialexploration.inventory.menus.SpaceshipMenu;
import com.shim.celestialexploration.registry.CelestialCapabilities;
import com.shim.celestialexploration.registry.CelestialDimensions;
import com.shim.celestialexploration.util.CelestialUtil;
import com.shim.celestialexploration.util.Keybinds;
import java.util.Collection;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class SpaceshipScreen
extends AbstractContainerScreen<SpaceshipMenu> {
    private static final ResourceLocation INVENTORY = new ResourceLocation("celestialexploration", "textures/gui/spaceship.png");
    private static final ResourceLocation LIGHT_TRAVEL = new ResourceLocation("celestialexploration", "textures/gui/light_travel.png");
    private static final ResourceLocation TABS = new ResourceLocation("textures/gui/advancements/tabs.png");
    private boolean isInventoryScreen = true;
    private List<Component> tooltip = Lists.newArrayList();
    public ImmutableList<Slot> originalSlots;
    public boolean lightTravelAllowed = false;
    public ResourceKey<Level> hoveredDimension = null;

    public SpaceshipScreen(SpaceshipMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.f_97726_ = 176;
        this.f_97727_ = 176;
    }

    protected void m_7286_(PoseStack poseStack, float partialTick, int mouseX, int mouseY) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.isInventoryScreen) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)INVENTORY);
            int x = (this.f_96543_ - this.f_97726_) / 2;
            int y = (this.f_96544_ - this.f_97727_) / 2;
            this.m_93228_(poseStack, x, y, 0, 0, this.f_97726_, this.f_97727_);
        } else {
            this.f_97731_ = 0;
            RenderSystem.m_157456_((int)0, (ResourceLocation)LIGHT_TRAVEL);
            int x = (this.f_96543_ - this.f_97726_) / 2;
            int y = (this.f_96544_ - this.f_97727_) / 2;
            this.m_93228_(poseStack, x, y, 0, 0, this.f_97726_, this.f_97727_);
            Player player = CelestialExploration.PROXY.getPlayer();
            LightTravelCapability.ILightTravel travelCap = CelestialExploration.getCapability((Entity)player, CelestialCapabilities.LIGHT_TRAVEL_CAPABILITY);
            if (travelCap != null) {
                if (travelCap.hasBeenToMercury()) {
                    this.m_93228_(poseStack, x + 75 + 26, y + 73 + 12, 177, 0, 3, 3);
                }
                if (travelCap.hasBeenToVenus()) {
                    this.m_93228_(poseStack, x + 75 + 12, y + 73 + 29, 177, 4, 4, 4);
                }
                if (travelCap.hasBeenToSpace()) {
                    this.m_93228_(poseStack, x + 75 - 10, y + 73 + 12, 177, 9, 4, 4);
                }
                if (travelCap.hasBeenToMars()) {
                    this.m_93228_(poseStack, x + 75 + 12, y + 73 - 19, 177, 14, 4, 4);
                }
                if (travelCap.hasBeenToJupiter()) {
                    this.m_93228_(poseStack, x + 75 + 56, y + 73 + 11, 177, 19, 9, 9);
                }
            }
        }
        this.renderTabs(poseStack, mouseX, mouseY);
    }

    private void renderTabs(PoseStack poseStack, int mouseX, int mouseY) {
        if (this.isInventoryScreen) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)TABS);
            int x = (this.f_96543_ - this.f_97726_) / 2;
            int y = (this.f_96544_ - this.f_97727_) / 2;
            RenderSystem.m_69478_();
            this.m_93228_(poseStack, x - 32 + 4, y, 0, 92, 32, 28);
            this.m_93228_(poseStack, x - 32 + 4, y + 29, 0, 64, 28, 28);
            this.f_96542_.m_115203_(new ItemStack((ItemLike)Items.f_42009_), x - 32 + 13, y + 6);
            this.f_96542_.m_115203_(new ItemStack((ItemLike)Items.f_42676_), x - 32 + 13, y + 29 + 6);
        } else {
            RenderSystem.m_157456_((int)0, (ResourceLocation)TABS);
            int x = (this.f_96543_ - this.f_97726_) / 2;
            int y = (this.f_96544_ - this.f_97727_) / 2;
            RenderSystem.m_69478_();
            this.m_93228_(poseStack, x - 32 + 4, y, 0, 64, 28, 29);
            this.m_93228_(poseStack, x - 32 + 4, y + 29, 64, 92, 31, 28);
            this.f_96542_.m_115203_(new ItemStack((ItemLike)Items.f_42009_), x - 32 + 13, y + 6);
            this.f_96542_.m_115203_(new ItemStack((ItemLike)Items.f_42676_), x - 32 + 13, y + 29 + 6);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int p_97750_) {
        if (this.lightTravelAllowed && this.checkTabClicked(mouseX, mouseY)) {
            return true;
        }
        return super.m_6375_(mouseX, mouseY, p_97750_);
    }

    public boolean m_6348_(double mouseX, double mouseY, int p_97814_) {
        if (this.lightTravelAllowed && this.checkTabClicked(mouseX, mouseY)) {
            this.changeTab();
            return true;
        }
        return super.m_6348_(mouseX, mouseY, p_97814_);
    }

    private boolean checkTabClicked(double mouseX, double mouseY) {
        int bottomTabWidth;
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        int i = this.f_97735_;
        int j = this.f_97736_;
        int topTabWidth = this.isInventoryScreen ? 32 : 28;
        int n = bottomTabWidth = this.isInventoryScreen ? 28 : 32;
        if (this.m_6774_(x - i - 32 + 4, y - j, topTabWidth, 28, mouseX, mouseY)) {
            return true;
        }
        return this.m_6774_(x - i - 32 + 4, y - j + 29, bottomTabWidth, 28, mouseX, mouseY);
    }

    private void changeTab() {
        if (this.isInventoryScreen) {
            this.isInventoryScreen = false;
            if (this.originalSlots == null) {
                this.originalSlots = ImmutableList.copyOf((Collection)((SpaceshipMenu)this.f_97732_).f_38839_);
            }
            ((SpaceshipMenu)this.f_97732_).f_38839_.clear();
        } else {
            this.isInventoryScreen = true;
            ((SpaceshipMenu)this.f_97732_).f_38839_.addAll(this.originalSlots);
            this.originalSlots = null;
        }
    }

    private void renderTabTooltips(PoseStack poseStack, int mouseX, int mouseY) {
        int bottomStart;
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        int i = this.f_97735_;
        int j = this.f_97736_;
        int topTabWidth = this.isInventoryScreen ? 32 : 28;
        int bottomTabWidth = this.isInventoryScreen ? 28 : 32;
        int topStart = this.isInventoryScreen ? 0 : 4;
        int n = bottomStart = this.isInventoryScreen ? 4 : 0;
        if (this.m_6774_(x - i - 32 + 4 + topStart, y - j, topTabWidth, 28, mouseX, mouseY)) {
            this.tooltip = Lists.newArrayList();
            this.tooltip.add((Component)new TranslatableComponent("celestialexploration.spaceship.tab.inventory"));
            this.m_96597_(poseStack, this.tooltip, mouseX, mouseY);
        } else if (this.m_6774_(x - i - 32 + 4 + bottomStart, y - j + 29, bottomTabWidth, 28, mouseX, mouseY)) {
            this.tooltip = Lists.newArrayList();
            if (!this.lightTravelAllowed) {
                this.tooltip.add((Component)new TranslatableComponent("celestialexploration.spaceship.tab.light_travel").m_130940_(ChatFormatting.GRAY));
                this.tooltip.add((Component)new TranslatableComponent("celestialexploration.spaceship.tab.light_travel_hint").m_130940_(ChatFormatting.GRAY));
            } else {
                this.tooltip.add((Component)new TranslatableComponent("celestialexploration.spaceship.tab.light_travel"));
            }
            this.m_96597_(poseStack, this.tooltip, mouseX, mouseY);
        }
    }

    protected void m_7027_(PoseStack p_97808_, int p_97809_, int p_97810_) {
        if (this.isInventoryScreen) {
            this.f_97731_ = this.f_97727_ - 94;
            this.f_96547_.m_92889_(p_97808_, this.f_96539_, (float)this.f_97728_, (float)this.f_97729_, 0x404040);
            this.f_96547_.m_92889_(p_97808_, this.f_169604_, (float)this.f_97730_, (float)this.f_97731_, 0x404040);
        }
    }

    public boolean m_7933_(int key, int p_97766_, int p_97767_) {
        return super.m_7933_(key, p_97766_, p_97767_);
    }

    public boolean m_7920_(int key, int p_94716_, int p_94717_) {
        if (Keybinds.SPACESHIP_LIGHT_TRAVEL.isActiveAndMatches(InputConstants.m_84827_((int)key, (int)p_94716_))) {
            CelestialExploration.LOGGER.debug("keyReleased, hoveredDimension: " + this.hoveredDimension);
            if (this.hoveredDimension != null && this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
                ((SpaceshipMenu)this.f_97732_).doLightTravel(this.hoveredDimension, (Player)this.f_96541_.f_91074_);
            }
        }
        return super.m_7920_(key, p_94716_, p_94717_);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float delta) {
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, mouseX, mouseY, delta);
        this.m_7025_(poseStack, mouseX, mouseY);
        this.renderTabTooltips(poseStack, mouseX, mouseY);
        if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
            this.lightTravelAllowed = this.f_96541_.f_91074_.f_19853_.m_46472_().equals(CelestialDimensions.SPACE);
        }
        this.renderLightTravelTooltips(poseStack, mouseX, mouseY);
    }

    private void renderLightTravelTooltips(PoseStack poseStack, int mouseX, int mouseY) {
        LocalPlayer player;
        LightTravelCapability.ILightTravel travelCap;
        if (this.isInventoryScreen) {
            return;
        }
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        int i = this.f_97735_;
        int j = this.f_97736_;
        if (this.f_96541_ != null && (travelCap = CelestialExploration.getCapability((Entity)(player = this.f_96541_.f_91074_), CelestialCapabilities.LIGHT_TRAVEL_CAPABILITY)) != null) {
            TextComponent travelTooltip = new TextComponent(new TranslatableComponent("celestialexploration.spaceship.travel.message_1").getString() + Keybinds.SPACESHIP_LIGHT_TRAVEL.m_90863_().getString() + new TranslatableComponent("celestialexploration.spaceship.travel.message_2").getString());
            TranslatableComponent travelUnavailable = new TranslatableComponent("celestialexploration.spaceship.travel_unavailable");
            if (!travelCap.hasBeenToMercury() && this.m_6774_(x - i + 75 + 26 - 1, y - j + 73 + 12 - 1, 5, 5, mouseX, mouseY)) {
                this.tooltip = Lists.newArrayList();
                this.tooltip.add(CelestialUtil.getPlanetDetail(1).name());
                this.tooltip.add((Component)travelUnavailable);
                this.tooltip.add(CelestialUtil.getPlanetDetail(1).location());
                this.m_96597_(poseStack, this.tooltip, mouseX, mouseY);
            } else if (!travelCap.hasBeenToVenus() && this.m_6774_(x - i + 75 + 12 - 1, y - j + 73 + 29 - 1, 6, 6, mouseX, mouseY)) {
                this.tooltip = Lists.newArrayList();
                this.tooltip.add(CelestialUtil.getPlanetDetail(2).name());
                this.tooltip.add((Component)travelUnavailable);
                this.tooltip.add(CelestialUtil.getPlanetDetail(2).location());
                this.m_96597_(poseStack, this.tooltip, mouseX, mouseY);
            } else if (!travelCap.hasBeenToSpace() && this.m_6774_(x - i + 75 - 10 - 1, y - j + 73 + 12 - 1, 6, 6, mouseX, mouseY)) {
                this.tooltip = Lists.newArrayList();
                this.tooltip.add(CelestialUtil.getPlanetDetail(3).name());
                this.tooltip.add((Component)travelUnavailable);
                this.tooltip.add(CelestialUtil.getPlanetDetail(3).location());
                this.m_96597_(poseStack, this.tooltip, mouseX, mouseY);
            } else if (!travelCap.hasBeenToMars() && this.m_6774_(x - i + 75 + 12 - 1, y - j + 73 - 19 - 1, 6, 6, mouseX, mouseY)) {
                this.tooltip = Lists.newArrayList();
                this.tooltip.add(CelestialUtil.getPlanetDetail(4).name());
                this.tooltip.add((Component)travelUnavailable);
                this.tooltip.add(CelestialUtil.getPlanetDetail(4).location());
                this.m_96597_(poseStack, this.tooltip, mouseX, mouseY);
            } else if (!travelCap.hasBeenToJupiter() && this.m_6774_(x - i + 75 + 56, y - j + 73 + 11, 9, 9, mouseX, mouseY)) {
                this.tooltip = Lists.newArrayList();
                this.tooltip.add(CelestialUtil.getPlanetDetail(5).name());
                this.tooltip.add((Component)travelUnavailable);
                this.tooltip.add(CelestialUtil.getPlanetDetail(5).location());
                this.m_96597_(poseStack, this.tooltip, mouseX, mouseY);
            }
            if (travelCap.hasBeenToMercury() && this.m_6774_(x - i + 75 + 26 - 1, y - j + 73 + 12 - 1, 5, 5, mouseX, mouseY)) {
                this.tooltip = Lists.newArrayList();
                this.tooltip.add((Component)new TranslatableComponent("celestialexploration.spaceship.travel.mercury"));
                if (travelCap.getMercuryCooldown().isCooldownEnded()) {
                    this.tooltip.add((Component)travelTooltip);
                } else {
                    this.tooltip.add((Component)new TextComponent(new TranslatableComponent("celestialexploration.spaceship.travel.cooldown").getString() + travelCap.getMercuryCooldown().getFormattedCooldown()));
                }
                this.m_96597_(poseStack, this.tooltip, mouseX, mouseY);
                this.hoveredDimension = CelestialDimensions.MERCURY;
            } else if (travelCap.hasBeenToVenus() && this.m_6774_(x - i + 75 + 12 - 1, y - j + 73 + 29 - 1, 6, 6, mouseX, mouseY)) {
                this.tooltip = Lists.newArrayList();
                this.tooltip.add((Component)new TranslatableComponent("celestialexploration.spaceship.travel.venus"));
                if (travelCap.getVenusCooldown().isCooldownEnded()) {
                    this.tooltip.add((Component)travelTooltip);
                } else {
                    this.tooltip.add((Component)new TextComponent(new TranslatableComponent("celestialexploration.spaceship.travel.cooldown").getString() + travelCap.getVenusCooldown().getFormattedCooldown()));
                }
                this.m_96597_(poseStack, this.tooltip, mouseX, mouseY);
                this.hoveredDimension = CelestialDimensions.VENUS;
            } else if (travelCap.hasBeenToSpace() && this.m_6774_(x - i + 75 - 10 - 1, y - j + 73 + 12 - 1, 6, 6, mouseX, mouseY)) {
                this.tooltip = Lists.newArrayList();
                this.tooltip.add((Component)new TranslatableComponent("celestialexploration.spaceship.travel.overworld"));
                if (travelCap.getOverworldCooldown().isCooldownEnded()) {
                    this.tooltip.add((Component)travelTooltip);
                } else {
                    this.tooltip.add((Component)new TextComponent(new TranslatableComponent("celestialexploration.spaceship.travel.cooldown").getString() + travelCap.getOverworldCooldown().getFormattedCooldown()));
                }
                this.m_96597_(poseStack, this.tooltip, mouseX, mouseY);
                this.hoveredDimension = Level.f_46428_;
            } else if (travelCap.hasBeenToMars() && this.m_6774_(x - i + 75 + 12 - 1, y - j + 73 - 19 - 1, 6, 6, mouseX, mouseY)) {
                this.tooltip = Lists.newArrayList();
                this.tooltip.add((Component)new TranslatableComponent("celestialexploration.spaceship.travel.mars"));
                if (travelCap.getMarsCooldown().isCooldownEnded()) {
                    this.tooltip.add((Component)travelTooltip);
                } else {
                    this.tooltip.add((Component)new TextComponent(new TranslatableComponent("celestialexploration.spaceship.travel.cooldown").getString() + travelCap.getMarsCooldown().getFormattedCooldown()));
                }
                this.m_96597_(poseStack, this.tooltip, mouseX, mouseY);
                this.hoveredDimension = CelestialDimensions.MARS;
            } else if (travelCap.hasBeenToJupiter() && this.m_6774_(x - i + 75 + 56, y - j + 73 + 11, 9, 9, mouseX, mouseY)) {
                this.tooltip = Lists.newArrayList();
                this.tooltip.add((Component)new TranslatableComponent("celestialexploration.spaceship.travel.jupiter"));
                if (travelCap.getJupiterCooldown().isCooldownEnded()) {
                    this.tooltip.add((Component)travelTooltip);
                } else {
                    this.tooltip.add((Component)new TextComponent(new TranslatableComponent("celestialexploration.spaceship.travel.cooldown").getString() + travelCap.getJupiterCooldown().getFormattedCooldown()));
                }
                this.m_96597_(poseStack, this.tooltip, mouseX, mouseY);
                this.hoveredDimension = CelestialDimensions.JUPITER;
            } else {
                this.hoveredDimension = null;
            }
        }
    }
}

