/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.item;

import com.shim.celestialexploration.CelestialExploration;
import com.shim.celestialexploration.capabilities.LoxTankCapability;
import com.shim.celestialexploration.registry.CelestialCapabilities;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;

public class LoxTankItem
extends BlockItem {
    public LoxTankItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public InteractionResult m_40576_(BlockPlaceContext blockPlaceContext) {
        super.m_40576_(blockPlaceContext);
        ItemStack item = blockPlaceContext.m_43722_();
        Level level = blockPlaceContext.m_43725_();
        LoxTankCapability.ILoxTank loxTank = CelestialExploration.getCapability(item, CelestialCapabilities.LOX_TANK_CAPABILITY);
        if (loxTank != null) {
            int amount = loxTank.getAmount();
            BlockPos blockPos = blockPlaceContext.m_8083_();
            BlockEntity entity = level.m_7702_(blockPos);
            LoxTankCapability.ILoxTank loxTankEntity = CelestialExploration.getCapability(entity, CelestialCapabilities.LOX_TANK_CAPABILITY);
            if (loxTankEntity != null) {
                loxTankEntity.setAmount(amount);
            }
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public CompoundTag getShareTag(ItemStack stackIn) {
        CompoundTag nbt = stackIn.m_41784_();
        LoxTankCapability.ILoxTank loxCap = CelestialExploration.getCapability(stackIn, CelestialCapabilities.LOX_TANK_CAPABILITY);
        if (loxCap != null) {
            nbt.m_128365_("LoxData", (Tag)loxCap.getLoxData());
        }
        return nbt;
    }

    public void readShareTag(ItemStack stackIn, @Nullable CompoundTag nbtIn) {
        LoxTankCapability.ILoxTank loxCap;
        super.readShareTag(stackIn, nbtIn);
        if (nbtIn != null && (loxCap = CelestialExploration.getCapability(stackIn, CelestialCapabilities.LOX_TANK_CAPABILITY)) != null && nbtIn.m_128425_("LoxData", 10)) {
            loxCap.setLoxData(nbtIn.m_128469_("LoxData"));
        }
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> components, TooltipFlag tooltipFlag) {
        LoxTankCapability.ILoxTank loxCap = CelestialExploration.getCapability(itemStack, CelestialCapabilities.LOX_TANK_CAPABILITY);
        if (loxCap != null) {
            components.add((Component)new TextComponent(loxCap.getAmount() + " / 8000 mb"));
        }
    }
}

