/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.item.armor;

import com.google.common.collect.ImmutableMap;
import com.shim.celestialexploration.item.ModArmorMaterials;
import com.shim.celestialexploration.registry.CelestialItems;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class HeavyDutySpacesuitArmorItem
extends ArmorItem {
    private static final Map<ArmorMaterial, MobEffectInstance> MATERIAL_TO_EFFECT_MAP = new ImmutableMap.Builder().put((Object)ModArmorMaterials.HEAVY_DUTY_SPACESUIT, (Object)new MobEffectInstance(MobEffects.f_19603_, 300, 1, false, false, false)).build();

    public HeavyDutySpacesuitArmorItem(EquipmentSlot slot, Item.Properties properties) {
        super((ArmorMaterial)ModArmorMaterials.HEAVY_DUTY_SPACESUIT, slot, properties);
    }

    public void onArmorTick(ItemStack stack, Level world, Player player) {
        if (!world.m_5776_() && this.hasFullSuitOfArmorOn(player)) {
            this.evaluateArmorEffects(player);
        }
    }

    public boolean makesPiglinsNeutral(ItemStack stack, LivingEntity wearer) {
        return stack.m_41720_() instanceof ArmorItem && ((ArmorItem)stack.m_41720_()).m_40402_() == EquipmentSlot.CHEST;
    }

    public boolean isDamaged(ItemStack stack) {
        return super.isDamaged(stack);
    }

    private void evaluateArmorEffects(Player player) {
        for (Map.Entry<ArmorMaterial, MobEffectInstance> entry : MATERIAL_TO_EFFECT_MAP.entrySet()) {
            ArmorMaterial mapArmorMaterial = entry.getKey();
            MobEffectInstance mapStatusEffect = entry.getValue();
            if (!this.hasCorrectArmorOn(mapArmorMaterial, player)) continue;
            this.addStatusEffectForMaterial(player, mapArmorMaterial, mapStatusEffect);
        }
    }

    private void addStatusEffectForMaterial(Player player, ArmorMaterial mapArmorMaterial, MobEffectInstance mapStatusEffect) {
        boolean hasPlayerEffect = player.m_21023_(mapStatusEffect.m_19544_());
        if (this.hasCorrectArmorOn(mapArmorMaterial, player) && !hasPlayerEffect) {
            player.m_7292_(new MobEffectInstance(mapStatusEffect.m_19544_(), mapStatusEffect.m_19557_(), mapStatusEffect.m_19564_(), mapStatusEffect.m_19571_(), mapStatusEffect.m_19572_()));
        }
    }

    private boolean hasFullSuitOfArmorOn(Player player) {
        ItemStack boots = player.m_150109_().m_36052_(0);
        ItemStack leggings = player.m_150109_().m_36052_(1);
        ItemStack breastplate = player.m_150109_().m_36052_(2);
        ItemStack helmet = player.m_150109_().m_36052_(3);
        return !helmet.m_41619_() && !breastplate.m_41619_() && !leggings.m_41619_() && !boots.m_41619_();
    }

    private boolean hasCorrectArmorOn(ArmorMaterial material, Player player) {
        for (ItemStack armorStack : player.m_150109_().f_35975_) {
            if (armorStack.m_41720_() instanceof ArmorItem) continue;
            return false;
        }
        ArmorItem boots = (ArmorItem)player.m_150109_().m_36052_(0).m_41720_();
        ArmorItem leggings = (ArmorItem)player.m_150109_().m_36052_(1).m_41720_();
        ArmorItem breastplate = (ArmorItem)player.m_150109_().m_36052_(2).m_41720_();
        ArmorItem helmet = (ArmorItem)player.m_150109_().m_36052_(3).m_41720_();
        return helmet.m_40401_() == material && breastplate.m_40401_() == material && leggings.m_40401_() == material && boots.m_40401_() == material;
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> components, TooltipFlag tooltipFlag) {
        components.add((Component)new TextComponent(""));
        components.add((Component)new TranslatableComponent("item.celestialexploration.armor_details.when_set_complete").m_130940_(ChatFormatting.GRAY));
        components.add((Component)new TranslatableComponent("item.celestialexploration.armor_details.heavy_duty_full_spacesuit").m_130940_(ChatFormatting.DARK_PURPLE));
        if (itemStack.m_150930_((Item)CelestialItems.HEAVY_DUTY_SPACESUIT_BOOTS.get())) {
            components.add((Component)new TranslatableComponent("item.celestialexploration.armor_details.when_worn").m_130940_(ChatFormatting.GRAY));
            components.add((Component)new TranslatableComponent("item.celestialexploration.armor_details.heavy_duty_spacesuit_boots").m_130940_(ChatFormatting.BLUE));
        }
        if (itemStack.m_150930_((Item)CelestialItems.HEAVY_DUTY_SPACESUIT_CHESTPLATE.get())) {
            components.add((Component)new TranslatableComponent("item.celestialexploration.armor_details.when_worn").m_130940_(ChatFormatting.GRAY));
            components.add((Component)new TranslatableComponent("item.celestialexploration.armor_details.heavy_duty_spacesuit_chestplate").m_130940_(ChatFormatting.BLUE));
        }
        if (itemStack.m_150930_((Item)CelestialItems.HEAVY_DUTY_SPACESUIT_HELMET.get())) {
            components.add((Component)new TranslatableComponent("item.celestialexploration.armor_details.when_worn").m_130940_(ChatFormatting.GRAY));
            components.add((Component)new TranslatableComponent("item.celestialexploration.armor_details.heavy_duty_spacesuit_helmet").m_130940_(ChatFormatting.BLUE));
        }
    }
}

