/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.packets;

import com.shim.celestialexploration.CelestialExploration;
import com.shim.celestialexploration.util.CelestialUtil;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;

public class CelestialPlanetPacket {
    final ResourceKey<Level> dimension;
    final Vec3 location;

    public CelestialPlanetPacket(ResourceLocation dimensionLoc, double x, double y, double z) {
        this((ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)dimensionLoc), new Vec3(x, y, z));
    }

    public CelestialPlanetPacket(ResourceKey<Level> dimension, Vec3 location) {
        this.dimension = dimension;
        this.location = location;
    }

    public static void encoder(CelestialPlanetPacket packet, FriendlyByteBuf buffer) {
        buffer.m_130085_(packet.dimension.m_135782_());
        buffer.writeDouble(packet.location.f_82479_);
        buffer.writeDouble(packet.location.f_82480_);
        buffer.writeDouble(packet.location.f_82481_);
    }

    public static CelestialPlanetPacket decoder(FriendlyByteBuf buffer) {
        return new CelestialPlanetPacket(buffer.m_130281_(), buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
    }

    public static void handle(CelestialPlanetPacket message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            Player player = CelestialExploration.PROXY.getPlayer();
            if (player != null) {
                CelestialUtil.setPlanetLocation(message.dimension, message.location);
            }
        });
        context.setPacketHandled(true);
    }
}

