/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.packets;

import com.shim.celestialexploration.entity.vehicle.Spaceship;
import com.shim.celestialexploration.util.CelestialUtil;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class DoLightTravelPacket {
    private final int spaceshipId;
    private final int passengerOneId;
    private final int passengerTwoId;
    private final ResourceKey<Level> dimension;

    public DoLightTravelPacket(int spaceshipId, int passengerOneId, int passengerTwoId, ResourceLocation dimensionLoc) {
        this(spaceshipId, passengerOneId, passengerTwoId, (ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)dimensionLoc));
    }

    public DoLightTravelPacket(int spaceshipId, int passengerOneId, int passengerTwoId, ResourceKey<Level> dimension) {
        this.spaceshipId = spaceshipId;
        this.passengerOneId = passengerOneId;
        this.passengerTwoId = passengerTwoId;
        this.dimension = dimension;
    }

    public static void encoder(DoLightTravelPacket packet, FriendlyByteBuf buffer) {
        buffer.writeInt(packet.spaceshipId);
        buffer.writeInt(packet.passengerOneId);
        buffer.writeInt(packet.passengerTwoId);
        buffer.m_130085_(packet.dimension.m_135782_());
    }

    public static DoLightTravelPacket decoder(FriendlyByteBuf buffer) {
        return new DoLightTravelPacket(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.m_130281_());
    }

    public static void handle(DoLightTravelPacket message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            Entity entity;
            ServerPlayer serverPlayer = context.getSender();
            if (serverPlayer != null && (entity = serverPlayer.f_19853_.m_6815_(message.spaceshipId)) instanceof Spaceship) {
                Spaceship spaceship = (Spaceship)entity;
                Entity passengerOne = serverPlayer.f_19853_.m_6815_(message.passengerOneId);
                Entity passengerTwo = message.passengerTwoId != -1 ? serverPlayer.f_19853_.m_6815_(message.passengerTwoId) : null;
                ChunkPos chunkPos = new ChunkPos((int)CelestialUtil.getPlanetaryChunkCoordinates(message.dimension).m_7096_(), (int)CelestialUtil.getPlanetaryChunkCoordinates(message.dimension).m_7094_());
                BlockPos pos = chunkPos.m_151394_(0);
                spaceship.doLightTravel(passengerOne, passengerTwo, pos, (Player)serverPlayer);
            }
        });
        context.setPacketHandled(true);
    }
}

