/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.packets;

import com.shim.celestialexploration.CelestialExploration;
import com.shim.celestialexploration.capabilities.LightTravelCapability;
import com.shim.celestialexploration.registry.CelestialCapabilities;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class LightTravelDataPacket {
    private final int playerId;
    private final CompoundTag travelData;

    public LightTravelDataPacket(int playerId, CompoundTag travelData) {
        this.playerId = playerId;
        this.travelData = travelData;
    }

    public static void encoder(LightTravelDataPacket packet, FriendlyByteBuf buffer) {
        buffer.writeInt(packet.playerId);
        buffer.m_130079_(packet.travelData);
    }

    public static LightTravelDataPacket decoder(FriendlyByteBuf buffer) {
        return new LightTravelDataPacket(buffer.readInt(), buffer.m_130260_());
    }

    public static void handle(LightTravelDataPacket message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            LightTravelCapability.ILightTravel travelCap;
            Player player = CelestialExploration.PROXY.getPlayer();
            if (player != null && (travelCap = CelestialExploration.getCapability((Entity)player, CelestialCapabilities.LIGHT_TRAVEL_CAPABILITY)) != null) {
                travelCap.setData(message.travelData);
            }
        });
        context.setPacketHandled(true);
    }
}

