/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.packets;

import com.shim.celestialexploration.entity.vehicle.Spaceship;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class ServerDidLightTravelPacket {
    private final int spaceshipId;
    private final int passengerOneId;
    private final int passengerTwoId;
    private final BlockPos destinationPos;

    public ServerDidLightTravelPacket(int spaceshipId, int passengerOneId, int passengerTwoId, BlockPos destinationPos) {
        this.spaceshipId = spaceshipId;
        this.passengerOneId = passengerOneId;
        this.passengerTwoId = passengerTwoId;
        this.destinationPos = destinationPos;
    }

    public static void encoder(ServerDidLightTravelPacket packet, FriendlyByteBuf buffer) {
        buffer.writeInt(packet.spaceshipId);
        buffer.writeInt(packet.passengerOneId);
        buffer.writeInt(packet.passengerTwoId);
        buffer.m_130064_(packet.destinationPos);
    }

    public static ServerDidLightTravelPacket decoder(FriendlyByteBuf buffer) {
        return new ServerDidLightTravelPacket(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.m_130135_());
    }

    public static void handle(ServerDidLightTravelPacket message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            Entity entity;
            ServerPlayer serverPlayer = context.getSender();
            if (serverPlayer != null && (entity = serverPlayer.f_19853_.m_6815_(message.spaceshipId)) instanceof Spaceship) {
                Spaceship spaceship = (Spaceship)entity;
                Entity passengerOne = serverPlayer.f_19853_.m_6815_(message.passengerOneId);
                Entity passengerTwo = message.passengerTwoId != -1 ? serverPlayer.f_19853_.m_6815_(message.passengerTwoId) : null;
                Spaceship.finishLightTravel(spaceship, passengerOne, passengerTwo, message.destinationPos);
            }
        });
        context.setPacketHandled(true);
    }
}

