/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.packets;

import com.shim.celestialexploration.CelestialExploration;
import com.shim.celestialexploration.capabilities.LightTravelCapability;
import com.shim.celestialexploration.registry.CelestialCapabilities;
import com.shim.celestialexploration.registry.CelestialDimensions;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class ServerResetLightTravelPacket {
    private final int playerId;
    private final ResourceKey<Level> dimension;

    public ServerResetLightTravelPacket(int playerId, ResourceLocation dimensionLoc) {
        this(playerId, (ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)dimensionLoc));
    }

    public ServerResetLightTravelPacket(int playerId, ResourceKey<Level> dimension) {
        this.playerId = playerId;
        this.dimension = dimension;
    }

    public static void encoder(ServerResetLightTravelPacket packet, FriendlyByteBuf buffer) {
        buffer.writeInt(packet.playerId);
        buffer.m_130085_(packet.dimension.m_135782_());
    }

    public static ServerResetLightTravelPacket decoder(FriendlyByteBuf buffer) {
        return new ServerResetLightTravelPacket(buffer.readInt(), buffer.m_130281_());
    }

    public static void handle(ServerResetLightTravelPacket message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            Entity player;
            LightTravelCapability.ILightTravel travelCap;
            ServerPlayer serverPlayer = context.getSender();
            if (serverPlayer != null && (travelCap = CelestialExploration.getCapability(player = serverPlayer.f_19853_.m_6815_(message.playerId), CelestialCapabilities.LIGHT_TRAVEL_CAPABILITY)) != null) {
                if (message.dimension.equals(CelestialDimensions.MERCURY)) {
                    travelCap.getMercuryCooldown().resetCooldown();
                }
                if (message.dimension.equals(CelestialDimensions.VENUS)) {
                    travelCap.getVenusCooldown().resetCooldown();
                }
                if (message.dimension.equals((Object)Level.f_46428_)) {
                    travelCap.getOverworldCooldown().resetCooldown();
                }
                if (message.dimension.equals(CelestialDimensions.MARS)) {
                    travelCap.getMarsCooldown().resetCooldown();
                }
                if (message.dimension.equals(CelestialDimensions.JUPITER)) {
                    travelCap.getJupiterCooldown().resetCooldown();
                }
                travelCap.sync((Player)player);
            }
        });
        context.setPacketHandled(true);
    }
}

