/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.packets;

import com.shim.celestialexploration.entity.vehicle.Spaceship;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class SpaceshipFuelCapPacket {
    int fuelTicks;
    int spaceshipId;

    public SpaceshipFuelCapPacket(int spaceshipId, int fuelTicks) {
        this.spaceshipId = spaceshipId;
        this.fuelTicks = fuelTicks;
    }

    public static void encoder(SpaceshipFuelCapPacket packet, FriendlyByteBuf buffer) {
        buffer.writeInt(packet.spaceshipId);
        buffer.writeInt(packet.fuelTicks);
    }

    public static SpaceshipFuelCapPacket decoder(FriendlyByteBuf buffer) {
        return new SpaceshipFuelCapPacket(buffer.readInt(), buffer.readInt());
    }

    public static void handle(SpaceshipFuelCapPacket message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            Entity entity;
            ServerPlayer player = context.getSender();
            if (player != null && (entity = player.f_19853_.m_6815_(message.spaceshipId)) instanceof Spaceship) {
                Spaceship spaceship = (Spaceship)entity;
                spaceship.decrementFuelTicks();
            }
        });
        context.setPacketHandled(true);
    }
}

