/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.packets;

import com.shim.celestialexploration.entity.vehicle.SpaceTaxi;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class TaxiReadyForTakeoffPacket {
    int taxiId;

    public TaxiReadyForTakeoffPacket(int taxiId) {
        this.taxiId = taxiId;
    }

    public static void encoder(TaxiReadyForTakeoffPacket packet, FriendlyByteBuf buffer) {
        buffer.writeInt(packet.taxiId);
    }

    public static TaxiReadyForTakeoffPacket decoder(FriendlyByteBuf buffer) {
        return new TaxiReadyForTakeoffPacket(buffer.readInt());
    }

    public static void handle(TaxiReadyForTakeoffPacket message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            Entity entity;
            ServerPlayer player = context.getSender();
            if (player != null && (entity = player.f_19853_.m_6815_(message.taxiId)) instanceof SpaceTaxi) {
                SpaceTaxi taxi = (SpaceTaxi)entity;
                taxi.setReadyForTakeoff();
            }
        });
        context.setPacketHandled(true);
    }
}

