/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.registry;

import com.shim.celestialexploration.capabilities.ISpaceFlight;
import com.shim.celestialexploration.capabilities.LightTravelCapability;
import com.shim.celestialexploration.capabilities.LoxTankCapability;
import com.shim.celestialexploration.capabilities.SpaceFlightCapabilityProvider;
import com.shim.celestialexploration.capabilities.TaxiCapability;
import com.shim.celestialexploration.capabilities.VillagerTravelCapability;
import com.shim.celestialexploration.entity.vehicle.Spaceship;
import com.shim.celestialexploration.registry.CelestialBlocks;
import com.shim.celestialexploration.registry.CelestialItems;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;

public class CelestialCapabilities {
    public static final Capability<LoxTankCapability.ILoxTank> LOX_TANK_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<LoxTankCapability.ILoxTank>(){});
    public static final Capability<ISpaceFlight> SPACE_FLIGHT_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<ISpaceFlight>(){});
    public static final Capability<TaxiCapability.ITaxi> TAXI_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<TaxiCapability.ITaxi>(){});
    public static final Capability<TaxiCapability.ITaxi> VILLAGER_TRAVEL_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<TaxiCapability.ITaxi>(){});
    public static final Capability<LightTravelCapability.ILightTravel> LIGHT_TRAVEL_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<LightTravelCapability.ILightTravel>(){});

    public static void registerCapabilities(RegisterCapabilitiesEvent eventIn) {
        eventIn.register(LoxTankCapability.ILoxTank.class);
        eventIn.register(ISpaceFlight.class);
        eventIn.register(TaxiCapability.ITaxi.class);
        eventIn.register(VillagerTravelCapability.ITravel.class);
    }

    public static void attachItemCapabilities(AttachCapabilitiesEvent<ItemStack> eventIn) {
        if (((ItemStack)eventIn.getObject()).m_41720_() == CelestialItems.LOX_TANK.get()) {
            eventIn.addCapability(new ResourceLocation("celestialexploration", "lox_tank_item"), (ICapabilityProvider)new LoxTankCapability.LoxTankCapabilityProvider());
        }
        if (((ItemStack)eventIn.getObject()).m_41720_() == CelestialItems.FLUID_BASIN.get()) {
            eventIn.addCapability(new ResourceLocation("celestialexploration", "basin"), (ICapabilityProvider)new FluidHandlerItemStack(((Item)CelestialItems.FLUID_BASIN.get()).m_7968_(), 4000));
        }
    }

    public static void attachBlockCapabilities(AttachCapabilitiesEvent<BlockEntity> eventIn) {
        if (((BlockEntity)eventIn.getObject()).m_58900_() == ((Block)CelestialBlocks.LOX_TANK.get()).m_49966_() && !((BlockEntity)eventIn.getObject()).getCapability(LoxTankCapability.LoxTankCapabilityProvider.LOX_TANK).isPresent()) {
            eventIn.addCapability(new ResourceLocation("celestialexploration", "lox_tank_block"), (ICapabilityProvider)new LoxTankCapability.LoxTankCapabilityProvider());
        }
    }

    public static void attachEntityCapabilities(AttachCapabilitiesEvent<Entity> eventIn) {
        if (eventIn.getObject() instanceof Spaceship && !((Entity)eventIn.getObject()).getCapability(SPACE_FLIGHT_CAPABILITY).isPresent()) {
            eventIn.addCapability(new ResourceLocation("celestialexploration", "spaceship_flight"), (ICapabilityProvider)new SpaceFlightCapabilityProvider());
        }
        if (eventIn.getObject() instanceof Player) {
            if (!((Entity)eventIn.getObject()).getCapability(TaxiCapability.TaxiProvider.TAXI).isPresent()) {
                eventIn.addCapability(new ResourceLocation("celestialexploration", "taxi"), (ICapabilityProvider)new TaxiCapability.TaxiProvider());
            }
            if (!((Entity)eventIn.getObject()).getCapability(LightTravelCapability.LightTravelProvider.LIGHT_TRAVEL).isPresent()) {
                eventIn.addCapability(new ResourceLocation("celestialexploration", "light_travel"), (ICapabilityProvider)new LightTravelCapability.LightTravelProvider());
            }
        }
        if (eventIn.getObject() instanceof Villager && !((Entity)eventIn.getObject()).getCapability(VILLAGER_TRAVEL_CAPABILITY).isPresent()) {
            eventIn.addCapability(new ResourceLocation("celestialexploration", "villager_travel"), (ICapabilityProvider)new VillagerTravelCapability.VillagerTravelCapabilityProvider());
        }
    }
}

