/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.util;

import com.shim.celestialexploration.registry.CelestialDimensions;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public class DimensionUtil {
    private static final Map<ResourceKey<Level>, gravityType> DIMENSION_GRAVITY = (Map)Util.m_137469_((Object)new Object2ObjectArrayMap(), dimension -> {
        dimension.defaultReturnValue((Object)gravityType.NORMAL);
        dimension.put(CelestialDimensions.SPACE, (Object)gravityType.LOW);
        dimension.put(CelestialDimensions.MOON, (Object)gravityType.LOW);
        dimension.put(CelestialDimensions.MARS, (Object)gravityType.LOW);
        dimension.put(CelestialDimensions.VENUS, (Object)gravityType.NORMAL);
        dimension.put(CelestialDimensions.MERCURY, (Object)gravityType.LOW);
    });

    public static void addDimensionGravity(ResourceKey<Level> dimension, gravityType gravityType2) {
        DIMENSION_GRAVITY.put(dimension, gravityType2);
    }

    public static boolean isLowGravityDimension(ResourceKey<Level> dimension) {
        return DIMENSION_GRAVITY.get(dimension).equals((Object)gravityType.LOW);
    }

    public static boolean isExtraLowGravityDimension(ResourceKey<Level> dimension) {
        return DIMENSION_GRAVITY.get(dimension).equals((Object)gravityType.EXTRA_LOW);
    }

    public static boolean isHighGravityDimension(ResourceKey<Level> dimension) {
        return DIMENSION_GRAVITY.get(dimension).equals((Object)gravityType.HIGH);
    }

    public static enum gravityType {
        EXTRA_LOW,
        LOW,
        NORMAL,
        HIGH;

    }
}

