/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.shim.celestialexploration.CelestialExploration;
import com.shim.celestialexploration.config.CelestialClientConfig;
import com.shim.celestialexploration.entity.vehicle.Spaceship;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.client.gui.IIngameOverlay;

@OnlyIn(value=Dist.CLIENT)
public class SpaceshipGui
extends ForgeIngameGui
implements IIngameOverlay {
    public static final Minecraft MINECRAFT = CelestialExploration.PROXY.getMinecraft();
    public static final ResourceLocation GUI_ICONS_LOCATION = new ResourceLocation("celestialexploration", "textures/gui/icons.png");

    public SpaceshipGui() {
        super(MINECRAFT);
    }

    public void render(ForgeIngameGui gui, PoseStack poseStack, float partialTick, int width, int height) {
        if (!SpaceshipGui.MINECRAFT.f_91066_.f_92062_ && (gui.shouldDrawSurvivalElements() || ((Boolean)CelestialClientConfig.HUD_IN_CREATIVE.get()).booleanValue())) {
            gui.setupOverlayRenderState(true, false);
            LocalPlayer player = SpaceshipGui.MINECRAFT.f_91074_;
            Entity mount = player.m_20202_();
            if (!(mount instanceof Spaceship)) {
                return;
            }
            RenderSystem.m_157456_((int)0, (ResourceLocation)GUI_ICONS_LOCATION);
            this.renderSpaceshipData((Spaceship)mount, poseStack, width, height);
        }
    }

    protected void renderSpaceshipData(Spaceship spaceship, PoseStack poseStack, int width, int height) {
        Player player;
        Entity entity;
        int xAdjustment;
        int fuel = spaceship.getFuelDataId();
        int maxFuel = 32000;
        double fuelPercent = (double)fuel / (double)maxFuel;
        int altitude = (int)spaceship.m_20182_().f_82480_;
        float maxSpeed = spaceship.getMaxSpeed();
        double speed = spaceship.getCurrentSpeed();
        Level level = spaceship.m_183503_();
        int yAdjustment = switch ((CelestialClientConfig.hudCorner)((Object)CelestialClientConfig.HUD_LOCATION.get())) {
            case CelestialClientConfig.hudCorner.TOP_RIGHT -> {
                xAdjustment = width - 12;
                yield 12;
            }
            case CelestialClientConfig.hudCorner.TOP_LEFT -> {
                xAdjustment = 57;
                yield 12;
            }
            case CelestialClientConfig.hudCorner.BOTTOM_RIGHT -> {
                xAdjustment = width - 12;
                yield height - 12 - 45 - 6;
            }
            case CelestialClientConfig.hudCorner.BOTTOM_LEFT -> {
                xAdjustment = 57;
                yield height - 12 - 45 - 6;
            }
            default -> {
                xAdjustment = width - 12;
                yield 12;
            }
        };
        this.m_93228_(poseStack, xAdjustment - 45, yAdjustment, 0, 19, 45, 45);
        if (speed == 0.0) {
            this.m_93228_(poseStack, xAdjustment - 45 + 11, yAdjustment + 21, 46, 22, 12, 4);
        } else {
            entity = spaceship.m_6688_();
            if (entity instanceof Player && (player = (Player)entity).m_7500_()) {
                this.m_93228_(poseStack, xAdjustment - 45 + 22, yAdjustment + 21, 46, 38, 12, 4);
            } else if (spaceship.getFuelDataId() <= 0) {
                this.m_93228_(poseStack, xAdjustment - 45 + 11, yAdjustment + 21 - 3, 46, 26, 12, 4);
            } else if (spaceship.isFuelDataIdLowFuel()) {
                this.m_93228_(poseStack, xAdjustment - 45 + 22, yAdjustment + 21 - 9, 48, 30, 10, 8);
            } else {
                this.m_93228_(poseStack, xAdjustment - 45 + 22, yAdjustment + 21, 46, 38, 12, 4);
            }
        }
        this.m_93228_(poseStack, xAdjustment - 45, yAdjustment + 45 + 1, 0, 64, 45, 7);
        entity = spaceship.m_6688_();
        if (entity instanceof Player && (player = (Player)entity).m_7500_()) {
            this.m_93228_(poseStack, xAdjustment - 45, yAdjustment + 45 + 1, 0, 72, 45, 7);
        } else {
            this.m_93228_(poseStack, xAdjustment - 45, yAdjustment + 45 + 1, 0, 72, (int)(45.0 * fuelPercent), 7);
        }
        int heightInThirds = (level.m_151558_() + Math.abs(level.m_141937_())) / 3;
        if (altitude > level.m_151558_()) {
            this.m_93228_(poseStack, xAdjustment - 45 + 22 + 10, yAdjustment + 21 + 1 + 9, 46, 50, 3, 7);
        } else if (altitude > heightInThirds * 2 + level.m_141937_()) {
            this.m_93228_(poseStack, xAdjustment - 45 + 22 + 10, yAdjustment + 21 + 1 + 9 + 2, 46, 52, 3, 5);
        } else if (altitude > heightInThirds + level.m_141937_()) {
            this.m_93228_(poseStack, xAdjustment - 45 + 22 + 10, yAdjustment + 21 + 1 + 9 + 4, 46, 54, 3, 3);
        } else if (altitude > level.m_141937_()) {
            this.m_93228_(poseStack, xAdjustment - 45 + 22 + 10, yAdjustment + 21 + 1 + 9 + 6, 46, 56, 3, 1);
        }
        SpaceshipGui.MINECRAFT.f_91062_.m_92883_(poseStack, String.valueOf(altitude), (float)(xAdjustment - 34), (float)(yAdjustment + 31), 0xFFFFFF);
    }
}

