/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.util.teleportation;

import com.google.common.collect.ImmutableList;
import com.shim.celestialexploration.registry.CelestialBlocks;
import com.shim.celestialexploration.registry.CelestialDimensions;
import com.shim.celestialexploration.util.CelestialUtil;
import com.shim.celestialexploration.world.portal.CelestialTeleporter;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;

public class TeleportUtil {
    @Deprecated
    private static final Map<ResourceKey<Level>, List<Block>> CE_DIMENSION_STRUCTURE_BLOCKS = (Map)Util.m_137469_((Object)new Object2ObjectArrayMap(), dimension -> {
        dimension.put(CelestialDimensions.MERCURY, (Object)ImmutableList.builder().add((Object[])new Block[]{(Block)CelestialBlocks.MERCURY_STONE.get(), (Block)CelestialBlocks.MERCURY_DEEPSLATE.get(), (Block)CelestialBlocks.MERCURY_CORE.get()}).build());
        dimension.put(CelestialDimensions.VENUS, (Object)ImmutableList.builder().add((Object[])new Block[]{(Block)CelestialBlocks.VENUS_STONE.get(), Blocks.f_50204_, (Block)CelestialBlocks.VENUS_DEEPSLATE.get(), (Block)CelestialBlocks.VENUS_CORE.get()}).build());
        dimension.put((Object)Level.f_46428_, (Object)ImmutableList.builder().add((Object[])new Block[]{Blocks.f_50069_, Blocks.f_50062_, Blocks.f_50147_, Blocks.f_50440_, Blocks.f_50472_, Blocks.f_50211_, Blocks.f_50126_, Blocks.f_50354_, Blocks.f_152550_, Blocks.f_50752_}).build());
        dimension.put(CelestialDimensions.MOON, (Object)ImmutableList.builder().add((Object[])new Block[]{(Block)CelestialBlocks.MOON_STONE.get(), (Block)CelestialBlocks.MOON_DEEPSLATE.get(), (Block)CelestialBlocks.MOON_CORE.get()}).build());
        dimension.put(CelestialDimensions.MARS, (Object)ImmutableList.builder().add((Object[])new Block[]{(Block)CelestialBlocks.MARS_STONE.get(), (Block)CelestialBlocks.MARS_DEEPSLATE.get(), (Block)CelestialBlocks.MARS_CORE.get(), (Block)CelestialBlocks.DRY_ICE.get()}).build());
        dimension.put(CelestialDimensions.JUPITER, (Object)ImmutableList.builder().add((Object[])new Block[]{(Block)CelestialBlocks.JUPITER_DEEPSLATE.get(), (Block)CelestialBlocks.JUPITER_ATMOSPHERE.get(), Blocks.f_50147_, Blocks.f_50207_, Blocks.f_50212_, Blocks.f_50214_, Blocks.f_50148_, (Block)CelestialBlocks.JUPITER_CORE.get()}).build());
        dimension.put(CelestialDimensions.EUROPA, (Object)ImmutableList.builder().add((Object[])new Block[]{(Block)CelestialBlocks.EUROPA_CORE.get(), (Block)CelestialBlocks.EUROPA_HYDRATE.get(), (Block)CelestialBlocks.MOON_STONE.get()}).build());
    });
    protected static final Map<ResourceKey<Level>, List<Block>> DIMENSION_STRUCTURE_BLOCKS = new HashMap<ResourceKey<Level>, List<Block>>();
    private static final Map<ResourceKey<Level>, List<ResourceKey<Level>>> PLANET_MOONS_WITH_PLANET = (Map)Util.m_137469_((Object)new Object2ObjectArrayMap(), dimension -> {
        dimension.put(CelestialDimensions.MERCURY, null);
        dimension.put(CelestialDimensions.VENUS, null);
        dimension.put((Object)Level.f_46428_, (Object)ImmutableList.builder().add(CelestialDimensions.MOON).build());
        dimension.put(CelestialDimensions.MARS, null);
        dimension.put(CelestialDimensions.JUPITER, (Object)ImmutableList.builder().add(CelestialDimensions.EUROPA).add(CelestialDimensions.CALLISTO).build());
    });
    private static final List<ResourceKey<Level>> PLANET_MOONS = (List)Util.m_137469_(new ArrayList(), dimension -> {
        dimension.add(CelestialDimensions.MOON);
        dimension.add(CelestialDimensions.EUROPA);
        dimension.add(CelestialDimensions.CALLISTO);
    });

    public static List<Block> getDimensionStructureBlocks(ResourceKey<Level> dimension) {
        return DIMENSION_STRUCTURE_BLOCKS.get(dimension);
    }

    public static void addDimensionStructureBlocks(ResourceKey<Level> dimension, List<Block> blocks) {
        DIMENSION_STRUCTURE_BLOCKS.put(dimension, blocks);
    }

    public static void clearDimensionStructureBlocks() {
        DIMENSION_STRUCTURE_BLOCKS.clear();
    }

    public static void addPlanetMoon(ResourceKey<Level> dimension, List<ResourceKey<Level>> moons) {
        PLANET_MOONS_WITH_PLANET.put(dimension, moons);
    }

    public static ResourceKey<Level> getTeleportLocation(Vec3 location, BlockState blockWeSee) {
        ResourceKey<Level> planet = null;
        for (ResourceKey<Level> loc : CelestialUtil.getPlanetLocations().keySet()) {
            if (PLANET_MOONS.contains(loc)) continue;
            ChunkPos planetChunkPos = new ChunkPos((int)CelestialUtil.getPlanetaryChunkCoordinates(loc).f_82479_, (int)CelestialUtil.getPlanetaryChunkCoordinates(loc).f_82481_);
            ChunkPos chunkPos = new ChunkPos(new BlockPos(location.f_82479_, location.f_82480_, location.f_82481_));
            if (!CelestialUtil.isInRectangle(planetChunkPos.f_45578_, planetChunkPos.f_45579_, 6, chunkPos.f_45578_, chunkPos.f_45579_)) continue;
            planet = loc;
            break;
        }
        if (planet == null) {
            return null;
        }
        List<Block> blocksToComp = TeleportUtil.getDimensionStructureBlocks(planet);
        if (blocksToComp == null) {
            return null;
        }
        for (Block block : blocksToComp) {
            if (!block.m_49966_().m_60713_(blockWeSee.m_60734_())) continue;
            return planet;
        }
        List<ResourceKey<Level>> moons = PLANET_MOONS_WITH_PLANET.get(planet);
        if (moons != null) {
            for (ResourceKey resourceKey : moons) {
                blocksToComp = TeleportUtil.getDimensionStructureBlocks((ResourceKey<Level>)resourceKey);
                for (Block block : blocksToComp) {
                    if (!block.m_49966_().m_60713_(blockWeSee.m_60734_())) continue;
                    return resourceKey;
                }
            }
        }
        return null;
    }

    public static void teleport(Entity spaceVehicle, @Nullable ArrayList<Entity> passengers, ResourceKey<Level> destinationDim, Vec3 locationInPlace) {
        ServerLevel destinationWorld;
        Level entityWorld;
        MinecraftServer minecraftserver;
        if (spaceVehicle.m_6072_() && (minecraftserver = (entityWorld = spaceVehicle.f_19853_).m_142572_()) != null && (destinationWorld = minecraftserver.m_129880_(destinationDim)) != null) {
            if (destinationDim != CelestialDimensions.SPACE) {
                locationInPlace = new Vec3(locationInPlace.f_82479_, (double)(destinationWorld.m_151558_() - 10), locationInPlace.f_82481_);
            }
            if (!entityWorld.f_46443_) {
                ServerLevel level = (ServerLevel)spaceVehicle.m_183503_();
                level.m_46473_().m_6180_("placing");
                spaceVehicle.m_20219_(locationInPlace);
                if (passengers != null) {
                    for (Entity passenger : passengers) {
                        passenger.m_20219_(locationInPlace);
                    }
                }
                level.m_46473_().m_7238_();
            }
            Entity newSpaceVehicle = null;
            if (!spaceVehicle.f_19853_.m_46472_().equals(destinationDim)) {
                if (spaceVehicle instanceof Player) {
                    spaceVehicle.changeDimension(destinationWorld, (ITeleporter)new CelestialTeleporter(destinationWorld));
                } else {
                    newSpaceVehicle = spaceVehicle.changeDimension(destinationWorld, (ITeleporter)new CelestialTeleporter(destinationWorld));
                }
            }
            if (newSpaceVehicle != null && passengers != null) {
                for (Entity passenger : passengers) {
                    Entity newPassenger = null;
                    if (!passenger.f_19853_.m_46472_().equals(destinationDim)) {
                        if (passenger instanceof Player) {
                            passenger.changeDimension(destinationWorld, (ITeleporter)new CelestialTeleporter(destinationWorld));
                        } else {
                            newPassenger = passenger.changeDimension(destinationWorld, (ITeleporter)new CelestialTeleporter(destinationWorld));
                        }
                    }
                    if (entityWorld.f_46443_) continue;
                    if (passenger instanceof ServerPlayer) {
                        passenger.m_20329_(newSpaceVehicle);
                        continue;
                    }
                    if (newPassenger == null) continue;
                    newPassenger.m_20329_(newSpaceVehicle);
                }
            }
        }
    }

    public static void displayTeleportMessage(Entity entity, int teleportCooldown, ResourceKey<Level> destination) {
        if (entity instanceof Player) {
            if (teleportCooldown % 20 == 0 && teleportCooldown != 0) {
                ((Player)entity).m_5661_(Component.m_130674_((String)("Teleporting to " + new TranslatableComponent("dimension.celestialexploration." + destination.m_135782_().m_135815_()).getString() + " in\u2026 " + teleportCooldown / 20)), true);
            } else if (teleportCooldown == 0) {
                ((Player)entity).m_5661_(Component.m_130674_((String)"Teleporting!"), true);
            }
        }
    }
}

