/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.world.biome;

import com.shim.celestialexploration.registry.CelestialEntities;
import com.shim.celestialexploration.world.biome.CelestialBiomes;
import com.shim.celestialexploration.world.features.placement.CelestialFeaturePlacements;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;

public class MoonBiomes
extends CelestialBiomes {
    public static Biome desert(boolean isGanymede) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        CelestialBiomes.addCarversAndLakes(biomeBuilder);
        biomeBuilder.m_204201_(GenerationStep.Decoration.LAKES, CelestialFeaturePlacements.MOON_LAVA_LAKE_UNDERGROUND);
        if (isGanymede) {
            biomeBuilder.m_204201_(GenerationStep.Decoration.LAKES, CelestialFeaturePlacements.GANYMEDE_WATER_LAKE_UNDERGROUND);
        }
        biomeBuilder.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, CelestialFeaturePlacements.DISK_MOON_SAND);
        MoonBiomes.addMoonOres(biomeBuilder);
        MoonBiomes.generalMonsters(spawnBuilder, 100, 100, 100);
        spawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)CelestialEntities.LUNAR_SLIME.get(), 100, 4, 4)).m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)CelestialEntities.ROVER.get(), 40, 1, 1)).m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)CelestialEntities.DRONE.get(), 30, 1, 2)).m_48381_();
        return CelestialBiomes.biome(Biome.Precipitation.NONE, Biome.BiomeCategory.NONE, prettyCold, 0.0f, CelestialBiomes.CelestialBody.MOON.skyColor, CelestialBiomes.CelestialBody.MOON.skyFogColor, CelestialBiomes.CelestialBody.MOON.waterColor, CelestialBiomes.CelestialBody.MOON.waterFogColor, spawnBuilder, biomeBuilder, NORMAL_MUSIC);
    }

    public static Biome craters(boolean isGanymede) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        CelestialBiomes.addCarversAndLakes(biomeBuilder);
        biomeBuilder.m_204201_(GenerationStep.Decoration.LAKES, CelestialFeaturePlacements.MOON_LAVA_LAKE_UNDERGROUND);
        if (isGanymede) {
            biomeBuilder.m_204201_(GenerationStep.Decoration.LAKES, CelestialFeaturePlacements.GANYMEDE_WATER_LAKE_UNDERGROUND);
        }
        MoonBiomes.addMoonOres(biomeBuilder);
        MoonBiomes.generalMonsters(spawnBuilder, 100, 100, 100);
        spawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)CelestialEntities.LUNAR_SLIME.get(), 100, 4, 4)).m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)CelestialEntities.METEOR_CRAWLER.get(), 100, 4, 4)).m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)CelestialEntities.ROVER.get(), 40, 1, 1)).m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)CelestialEntities.DRONE.get(), 30, 1, 2)).m_48381_();
        return CelestialBiomes.biome(Biome.Precipitation.NONE, Biome.BiomeCategory.NONE, prettyCold, 0.0f, CelestialBiomes.CelestialBody.MOON.skyColor, CelestialBiomes.CelestialBody.MOON.skyFogColor, CelestialBiomes.CelestialBody.MOON.waterColor, CelestialBiomes.CelestialBody.MOON.waterFogColor, spawnBuilder, biomeBuilder, NORMAL_MUSIC);
    }

    public static Biome lavaFlats(boolean isGanymede) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        CelestialBiomes.addCarversAndLakes(biomeBuilder);
        biomeBuilder.m_204201_(GenerationStep.Decoration.LAKES, CelestialFeaturePlacements.MOON_LAVA_LAKE_UNDERGROUND);
        if (isGanymede) {
            biomeBuilder.m_204201_(GenerationStep.Decoration.LAKES, CelestialFeaturePlacements.GANYMEDE_WATER_LAKE_UNDERGROUND);
        }
        biomeBuilder.m_204201_(GenerationStep.Decoration.LAKES, CelestialFeaturePlacements.OBSIDIAN_LAKE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, CelestialFeaturePlacements.DISK_MOON_SAND);
        MoonBiomes.addMoonOres(biomeBuilder);
        MoonBiomes.generalMonsters(spawnBuilder, 100, 80, 100);
        spawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)CelestialEntities.LUNAR_SLIME.get(), 120, 4, 4)).m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)CelestialEntities.ROVER.get(), 40, 1, 1)).m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)CelestialEntities.DRONE.get(), 30, 1, 2)).m_48381_();
        return CelestialBiomes.biome(Biome.Precipitation.NONE, Biome.BiomeCategory.NONE, prettyCold, 0.0f, CelestialBiomes.CelestialBody.MOON.skyColor, CelestialBiomes.CelestialBody.MOON.skyFogColor, CelestialBiomes.CelestialBody.MOON.waterColor, CelestialBiomes.CelestialBody.MOON.waterFogColor, spawnBuilder, biomeBuilder, NORMAL_MUSIC);
    }

    public static Biome plains() {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        biomeBuilder.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, CelestialFeaturePlacements.DISK_MOON_SAND);
        MoonBiomes.addMoonOres(biomeBuilder);
        MoonBiomes.generalMonsters(spawnBuilder, 80, 100, 100);
        spawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)CelestialEntities.LUNAR_SLIME.get(), 30, 4, 4)).m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)CelestialEntities.ROVER.get(), 40, 1, 1)).m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)CelestialEntities.DRONE.get(), 30, 1, 2)).m_48381_();
        return CelestialBiomes.biome(Biome.Precipitation.NONE, Biome.BiomeCategory.NONE, prettyCold, 0.0f, CelestialBiomes.CelestialBody.MOON.skyColor, CelestialBiomes.CelestialBody.MOON.skyFogColor, CelestialBiomes.CelestialBody.MOON.waterColor, CelestialBiomes.CelestialBody.MOON.waterFogColor, spawnBuilder, biomeBuilder, NORMAL_MUSIC);
    }

    public static Biome ocean() {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        MoonBiomes.addMoonOres(biomeBuilder);
        spawnBuilder.m_48376_(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData((EntityType)CelestialEntities.EUREKA.get(), 30, 4, 4)).m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)CelestialEntities.ROVER.get(), 40, 1, 1)).m_48381_();
        return CelestialBiomes.biome(Biome.Precipitation.NONE, Biome.BiomeCategory.NONE, -0.75f, 0.0f, CelestialBiomes.CelestialBody.MOON.skyColor, CelestialBiomes.CelestialBody.MOON.skyFogColor, CelestialBiomes.CelestialBody.MOON.waterColor, CelestialBiomes.CelestialBody.MOON.waterFogColor, spawnBuilder, biomeBuilder, NORMAL_MUSIC);
    }

    public static Biome river() {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        biomeBuilder.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, CelestialFeaturePlacements.DISK_MOON_SAND);
        MoonBiomes.addMoonOres(biomeBuilder);
        return CelestialBiomes.biome(Biome.Precipitation.NONE, Biome.BiomeCategory.NONE, -0.75f, 0.0f, CelestialBiomes.CelestialBody.MOON.skyColor, CelestialBiomes.CelestialBody.MOON.skyFogColor, CelestialBiomes.CelestialBody.MOON.waterColor, CelestialBiomes.CelestialBody.MOON.waterFogColor, spawnBuilder, biomeBuilder, NORMAL_MUSIC);
    }

    public static void addMoonOres(BiomeGenerationSettings.Builder biomeBuilder) {
        biomeBuilder.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, CelestialFeaturePlacements.MOON_IRON_ORE_UPPER);
        biomeBuilder.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, CelestialFeaturePlacements.MOON_IRON_ORE_MIDDLE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, CelestialFeaturePlacements.MOON_IRON_ORE_SMALL);
        biomeBuilder.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, CelestialFeaturePlacements.MOON_REDSTONE_ORE);
        biomeBuilder.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, CelestialFeaturePlacements.MOON_REDSTONE_ORE_LOWER);
        biomeBuilder.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, CelestialFeaturePlacements.MOON_BAUXITE_ORE);
    }
}

