/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.world.biome.builder;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.TerrainShaper;

public abstract class AbstractBiomeBuilder {
    protected final Climate.Parameter FULL_RANGE = Climate.Parameter.m_186822_((float)-1.0f, (float)1.0f);
    protected final Climate.Parameter[] temperatures = new Climate.Parameter[]{Climate.Parameter.m_186822_((float)-1.0f, (float)-0.45f), Climate.Parameter.m_186822_((float)-0.45f, (float)-0.15f), Climate.Parameter.m_186822_((float)-0.15f, (float)0.2f), Climate.Parameter.m_186822_((float)0.2f, (float)0.55f), Climate.Parameter.m_186822_((float)0.55f, (float)1.0f)};
    protected final Climate.Parameter[] humidities = new Climate.Parameter[]{Climate.Parameter.m_186822_((float)-1.0f, (float)-0.35f), Climate.Parameter.m_186822_((float)-0.35f, (float)-0.1f), Climate.Parameter.m_186822_((float)-0.1f, (float)0.1f), Climate.Parameter.m_186822_((float)0.1f, (float)0.3f), Climate.Parameter.m_186822_((float)0.3f, (float)1.0f)};
    protected final Climate.Parameter[] erosions = new Climate.Parameter[]{Climate.Parameter.m_186822_((float)-1.0f, (float)-0.78f), Climate.Parameter.m_186822_((float)-0.78f, (float)-0.375f), Climate.Parameter.m_186822_((float)-0.375f, (float)-0.2225f), Climate.Parameter.m_186822_((float)-0.2225f, (float)0.05f), Climate.Parameter.m_186822_((float)0.05f, (float)0.45f), Climate.Parameter.m_186822_((float)0.45f, (float)0.55f), Climate.Parameter.m_186822_((float)0.55f, (float)1.0f)};
    protected final Climate.Parameter FROZEN_RANGE = this.temperatures[0];
    protected final Climate.Parameter UNFROZEN_RANGE = Climate.Parameter.m_186829_((Climate.Parameter)this.temperatures[1], (Climate.Parameter)this.temperatures[4]);
    protected final Climate.Parameter mushroomFieldsContinentalness = Climate.Parameter.m_186822_((float)-1.2f, (float)-1.05f);
    protected final Climate.Parameter deepOceanContinentalness = Climate.Parameter.m_186822_((float)-1.05f, (float)-0.455f);
    protected final Climate.Parameter oceanContinentalness = Climate.Parameter.m_186822_((float)-0.455f, (float)-0.19f);
    protected final Climate.Parameter coastContinentalness = Climate.Parameter.m_186822_((float)-0.19f, (float)-0.11f);
    protected final Climate.Parameter inlandContinentalness = Climate.Parameter.m_186822_((float)-0.11f, (float)0.55f);
    protected final Climate.Parameter nearInlandContinentalness = Climate.Parameter.m_186822_((float)-0.11f, (float)0.03f);
    protected final Climate.Parameter midInlandContinentalness = Climate.Parameter.m_186822_((float)0.03f, (float)0.3f);
    protected final Climate.Parameter farInlandContinentalness = Climate.Parameter.m_186822_((float)0.3f, (float)1.0f);

    protected abstract ResourceKey<Biome>[][] getOceans();

    protected abstract ResourceKey<Biome>[][] getMiddleBiomes();

    protected abstract ResourceKey<Biome>[][] getMiddleBiomeVariants();

    protected abstract ResourceKey<Biome>[][] getPlateauBiomes();

    protected abstract ResourceKey<Biome>[][] getPlateauBiomeVariants();

    protected abstract ResourceKey<Biome>[][] getShatteredBiomes();

    protected abstract ResourceKey<Biome> getValleyBiome();

    public List<Climate.ParameterPoint> spawnTarget() {
        Climate.Parameter climate$parameter = Climate.Parameter.m_186820_((float)0.0f);
        float f = 0.16f;
        return List.of(new Climate.ParameterPoint(this.FULL_RANGE, this.FULL_RANGE, Climate.Parameter.m_186829_((Climate.Parameter)this.inlandContinentalness, (Climate.Parameter)this.FULL_RANGE), this.FULL_RANGE, climate$parameter, Climate.Parameter.m_186822_((float)-1.0f, (float)-0.16f), 0L), new Climate.ParameterPoint(this.FULL_RANGE, this.FULL_RANGE, Climate.Parameter.m_186829_((Climate.Parameter)this.inlandContinentalness, (Climate.Parameter)this.FULL_RANGE), this.FULL_RANGE, climate$parameter, Climate.Parameter.m_186822_((float)0.16f, (float)1.0f), 0L));
    }

    public void addBiomes(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> p_187176_) {
        this.addOffCoastBiomes(p_187176_);
        this.addInlandBiomes(p_187176_);
        this.addUndergroundBiomes(p_187176_);
    }

    protected void addOffCoastBiomes(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> p_187196_) {
        for (int i = 0; i < this.temperatures.length; ++i) {
            Climate.Parameter climate$parameter = this.temperatures[i];
            this.addSurfaceBiome(p_187196_, climate$parameter, this.FULL_RANGE, this.deepOceanContinentalness, this.FULL_RANGE, this.FULL_RANGE, 0.0f, this.getOceans()[0][i]);
            this.addSurfaceBiome(p_187196_, climate$parameter, this.FULL_RANGE, this.oceanContinentalness, this.FULL_RANGE, this.FULL_RANGE, 0.0f, this.getOceans()[1][i]);
        }
    }

    protected void addInlandBiomes(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> p_187216_) {
        this.addMidSlice(p_187216_, Climate.Parameter.m_186822_((float)-1.0f, (float)-0.93333334f));
        this.addHighSlice(p_187216_, Climate.Parameter.m_186822_((float)-0.93333334f, (float)-0.7666667f));
        this.addPeaks(p_187216_, Climate.Parameter.m_186822_((float)-0.7666667f, (float)-0.56666666f));
        this.addHighSlice(p_187216_, Climate.Parameter.m_186822_((float)-0.56666666f, (float)-0.4f));
        this.addMidSlice(p_187216_, Climate.Parameter.m_186822_((float)-0.4f, (float)-0.26666668f));
        this.addLowSlice(p_187216_, Climate.Parameter.m_186822_((float)-0.26666668f, (float)-0.05f));
        this.addValleys(p_187216_, Climate.Parameter.m_186822_((float)-0.05f, (float)0.05f));
        this.addLowSlice(p_187216_, Climate.Parameter.m_186822_((float)0.05f, (float)0.26666668f));
        this.addMidSlice(p_187216_, Climate.Parameter.m_186822_((float)0.26666668f, (float)0.4f));
        this.addHighSlice(p_187216_, Climate.Parameter.m_186822_((float)0.4f, (float)0.56666666f));
        this.addPeaks(p_187216_, Climate.Parameter.m_186822_((float)0.56666666f, (float)0.7666667f));
        this.addHighSlice(p_187216_, Climate.Parameter.m_186822_((float)0.7666667f, (float)0.93333334f));
        this.addMidSlice(p_187216_, Climate.Parameter.m_186822_((float)0.93333334f, (float)1.0f));
    }

    protected void addPeaks(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> p_187178_, Climate.Parameter p_187179_) {
        for (int i = 0; i < this.temperatures.length; ++i) {
            Climate.Parameter climate$parameter = this.temperatures[i];
            for (int j = 0; j < this.humidities.length; ++j) {
                Climate.Parameter climate$parameter1 = this.humidities[j];
                ResourceKey<Biome> resourcekey = this.pickMiddleBiome(i, j, p_187179_);
                ResourceKey<Biome> resourcekey1 = this.pickMiddleBiomeOrBadlandsIfHot(i, j, p_187179_);
                ResourceKey<Biome> resourcekey2 = this.pickMiddleBiomeOrBadlandsIfHotOrSlopeIfCold(i, j, p_187179_);
                ResourceKey<Biome> resourcekey3 = this.pickPlateauBiome(i, j, p_187179_);
                ResourceKey<Biome> resourcekey4 = this.pickShatteredBiome(i, j, p_187179_);
                ResourceKey<Biome> resourcekey6 = this.pickPeakBiome(i, j, p_187179_);
                this.addSurfaceBiome(p_187178_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[0], p_187179_, 0.0f, resourcekey6);
                this.addSurfaceBiome(p_187178_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), this.erosions[1], p_187179_, 0.0f, resourcekey2);
                this.addSurfaceBiome(p_187178_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[1], p_187179_, 0.0f, resourcekey6);
                this.addSurfaceBiome(p_187178_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[2], (Climate.Parameter)this.erosions[3]), p_187179_, 0.0f, resourcekey);
                this.addSurfaceBiome(p_187178_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[2], p_187179_, 0.0f, resourcekey3);
                this.addSurfaceBiome(p_187178_, climate$parameter, climate$parameter1, this.midInlandContinentalness, this.erosions[3], p_187179_, 0.0f, resourcekey1);
                this.addSurfaceBiome(p_187178_, climate$parameter, climate$parameter1, this.farInlandContinentalness, this.erosions[3], p_187179_, 0.0f, resourcekey3);
                this.addSurfaceBiome(p_187178_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[4], p_187179_, 0.0f, resourcekey);
                this.addSurfaceBiome(p_187178_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[5], p_187179_, 0.0f, resourcekey4);
                this.addSurfaceBiome(p_187178_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], p_187179_, 0.0f, resourcekey);
            }
        }
    }

    protected void addHighSlice(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> p_187198_, Climate.Parameter p_187199_) {
        for (int i = 0; i < this.temperatures.length; ++i) {
            Climate.Parameter climate$parameter = this.temperatures[i];
            for (int j = 0; j < this.humidities.length; ++j) {
                Climate.Parameter climate$parameter1 = this.humidities[j];
                ResourceKey<Biome> middleBiome = this.pickMiddleBiome(i, j, p_187199_);
                ResourceKey<Biome> resourcekey1 = this.pickMiddleBiomeOrBadlandsIfHot(i, j, p_187199_);
                ResourceKey<Biome> resourcekey2 = this.pickMiddleBiomeOrBadlandsIfHotOrSlopeIfCold(i, j, p_187199_);
                ResourceKey<Biome> plateauBiome = this.pickPlateauBiome(i, j, p_187199_);
                ResourceKey<Biome> resourcekey4 = this.pickShatteredBiome(i, j, p_187199_);
                ResourceKey<Biome> resourcekey7 = this.pickPeakBiome(i, j, p_187199_);
                this.addSurfaceBiome(p_187198_, climate$parameter, climate$parameter1, this.coastContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), p_187199_, 0.0f, middleBiome);
                this.addSurfaceBiome(p_187198_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[0], p_187199_, 0.0f, resourcekey7);
                this.addSurfaceBiome(p_187198_, climate$parameter, climate$parameter1, this.nearInlandContinentalness, this.erosions[1], p_187199_, 0.0f, resourcekey2);
                this.addSurfaceBiome(p_187198_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[2], (Climate.Parameter)this.erosions[3]), p_187199_, 0.0f, middleBiome);
                this.addSurfaceBiome(p_187198_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[2], p_187199_, 0.0f, plateauBiome);
                this.addSurfaceBiome(p_187198_, climate$parameter, climate$parameter1, this.midInlandContinentalness, this.erosions[3], p_187199_, 0.0f, resourcekey1);
                this.addSurfaceBiome(p_187198_, climate$parameter, climate$parameter1, this.farInlandContinentalness, this.erosions[3], p_187199_, 0.0f, plateauBiome);
                this.addSurfaceBiome(p_187198_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[4], p_187199_, 0.0f, middleBiome);
                this.addSurfaceBiome(p_187198_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[5], p_187199_, 0.0f, resourcekey4);
                this.addSurfaceBiome(p_187198_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], p_187199_, 0.0f, middleBiome);
            }
        }
    }

    protected void addMidSlice(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> p_187218_, Climate.Parameter p_187219_) {
        for (int i = 0; i < this.temperatures.length; ++i) {
            Climate.Parameter climate$parameter = this.temperatures[i];
            for (int j = 0; j < this.humidities.length; ++j) {
                Climate.Parameter climate$parameter1 = this.humidities[j];
                ResourceKey<Biome> resourcekey = this.pickMiddleBiome(i, j, p_187219_);
                ResourceKey<Biome> resourcekey1 = this.pickMiddleBiomeOrBadlandsIfHot(i, j, p_187219_);
                ResourceKey<Biome> resourcekey2 = this.pickMiddleBiomeOrBadlandsIfHotOrSlopeIfCold(i, j, p_187219_);
                ResourceKey<Biome> resourcekey3 = this.pickShatteredBiome(i, j, p_187219_);
                ResourceKey<Biome> resourcekey4 = this.pickPlateauBiome(i, j, p_187219_);
                ResourceKey<Biome> resourcekey5 = this.pickBeachBiome(i, j);
                ResourceKey<Biome> resourcekey7 = this.pickShatteredCoastBiome(i, j, p_187219_);
                this.addSurfaceBiome(p_187218_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.midInlandContinentalness), this.erosions[1], p_187219_, 0.0f, resourcekey2);
                this.addSurfaceBiome(p_187218_, climate$parameter, climate$parameter1, this.farInlandContinentalness, this.erosions[1], p_187219_, 0.0f, resourcekey4);
                this.addSurfaceBiome(p_187218_, climate$parameter, climate$parameter1, this.nearInlandContinentalness, this.erosions[2], p_187219_, 0.0f, resourcekey);
                this.addSurfaceBiome(p_187218_, climate$parameter, climate$parameter1, this.midInlandContinentalness, this.erosions[2], p_187219_, 0.0f, resourcekey1);
                this.addSurfaceBiome(p_187218_, climate$parameter, climate$parameter1, this.farInlandContinentalness, this.erosions[2], p_187219_, 0.0f, resourcekey4);
                this.addSurfaceBiome(p_187218_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), this.erosions[3], p_187219_, 0.0f, resourcekey);
                this.addSurfaceBiome(p_187218_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[3], p_187219_, 0.0f, resourcekey1);
                if (p_187219_.f_186814_() < 0L) {
                    this.addSurfaceBiome(p_187218_, climate$parameter, climate$parameter1, this.coastContinentalness, this.erosions[4], p_187219_, 0.0f, resourcekey5);
                    this.addSurfaceBiome(p_187218_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[4], p_187219_, 0.0f, resourcekey);
                } else {
                    this.addSurfaceBiome(p_187218_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[4], p_187219_, 0.0f, resourcekey);
                }
                this.addSurfaceBiome(p_187218_, climate$parameter, climate$parameter1, this.coastContinentalness, this.erosions[5], p_187219_, 0.0f, resourcekey7);
                this.addSurfaceBiome(p_187218_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[5], p_187219_, 0.0f, resourcekey3);
                if (p_187219_.f_186814_() < 0L) {
                    this.addSurfaceBiome(p_187218_, climate$parameter, climate$parameter1, this.coastContinentalness, this.erosions[6], p_187219_, 0.0f, resourcekey5);
                } else {
                    this.addSurfaceBiome(p_187218_, climate$parameter, climate$parameter1, this.coastContinentalness, this.erosions[6], p_187219_, 0.0f, resourcekey);
                }
                if (i != 0) continue;
                this.addSurfaceBiome(p_187218_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], p_187219_, 0.0f, resourcekey);
            }
        }
    }

    protected void addLowSlice(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> p_187229_, Climate.Parameter p_187230_) {
        for (int i = 0; i < this.temperatures.length; ++i) {
            Climate.Parameter climate$parameter = this.temperatures[i];
            for (int j = 0; j < this.humidities.length; ++j) {
                Climate.Parameter climate$parameter1 = this.humidities[j];
                ResourceKey<Biome> resourcekey = this.pickMiddleBiome(i, j, p_187230_);
                ResourceKey<Biome> resourcekey1 = this.pickMiddleBiomeOrBadlandsIfHot(i, j, p_187230_);
                ResourceKey<Biome> resourcekey2 = this.pickMiddleBiomeOrBadlandsIfHotOrSlopeIfCold(i, j, p_187230_);
                ResourceKey<Biome> resourcekey3 = this.pickBeachBiome(i, j);
                ResourceKey<Biome> resourcekey5 = this.pickShatteredCoastBiome(i, j, p_187230_);
                this.addSurfaceBiome(p_187229_, climate$parameter, climate$parameter1, this.nearInlandContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), p_187230_, 0.0f, resourcekey1);
                this.addSurfaceBiome(p_187229_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), p_187230_, 0.0f, resourcekey2);
                this.addSurfaceBiome(p_187229_, climate$parameter, climate$parameter1, this.nearInlandContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[2], (Climate.Parameter)this.erosions[3]), p_187230_, 0.0f, resourcekey);
                this.addSurfaceBiome(p_187229_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[2], (Climate.Parameter)this.erosions[3]), p_187230_, 0.0f, resourcekey1);
                this.addSurfaceBiome(p_187229_, climate$parameter, climate$parameter1, this.coastContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[3], (Climate.Parameter)this.erosions[4]), p_187230_, 0.0f, resourcekey3);
                this.addSurfaceBiome(p_187229_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[4], p_187230_, 0.0f, resourcekey);
                this.addSurfaceBiome(p_187229_, climate$parameter, climate$parameter1, this.coastContinentalness, this.erosions[5], p_187230_, 0.0f, resourcekey5);
                this.addSurfaceBiome(p_187229_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[5], p_187230_, 0.0f, resourcekey);
                this.addSurfaceBiome(p_187229_, climate$parameter, climate$parameter1, this.coastContinentalness, this.erosions[6], p_187230_, 0.0f, resourcekey3);
                if (i != 0) continue;
                this.addSurfaceBiome(p_187229_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], p_187230_, 0.0f, resourcekey);
            }
        }
    }

    protected void addValleys(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> p_187238_, Climate.Parameter weirdness) {
        this.addSurfaceBiome(p_187238_, this.FROZEN_RANGE, this.FULL_RANGE, this.coastContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), weirdness, 0.0f, this.getValleyBiome());
        this.addSurfaceBiome(p_187238_, this.UNFROZEN_RANGE, this.humidities[0], this.coastContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), weirdness, 0.0f, this.getValleyBiome());
        this.addSurfaceBiome(p_187238_, this.FROZEN_RANGE, this.humidities[0], this.nearInlandContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), weirdness, 0.0f, this.getValleyBiome());
        this.addSurfaceBiome(p_187238_, this.UNFROZEN_RANGE, this.humidities[0], this.nearInlandContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), weirdness, 0.0f, this.getValleyBiome());
        this.addSurfaceBiome(p_187238_, this.FROZEN_RANGE, this.humidities[0], Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[2], (Climate.Parameter)this.erosions[5]), weirdness, 0.0f, this.getValleyBiome());
        this.addSurfaceBiome(p_187238_, this.UNFROZEN_RANGE, this.humidities[0], Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[2], (Climate.Parameter)this.erosions[5]), weirdness, 0.0f, this.getValleyBiome());
        this.addSurfaceBiome(p_187238_, this.FROZEN_RANGE, this.humidities[0], this.coastContinentalness, this.erosions[6], weirdness, 0.0f, this.getValleyBiome());
        this.addSurfaceBiome(p_187238_, this.UNFROZEN_RANGE, this.humidities[0], this.coastContinentalness, this.erosions[6], weirdness, 0.0f, this.getValleyBiome());
        this.addSurfaceBiome(p_187238_, this.FROZEN_RANGE, this.humidities[0], Climate.Parameter.m_186829_((Climate.Parameter)this.inlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], weirdness, 0.0f, this.getValleyBiome());
        for (int i = 0; i < this.temperatures.length; ++i) {
            Climate.Parameter climate$parameter = this.temperatures[i];
            for (int j = 0; j < this.humidities.length; ++j) {
                Climate.Parameter climate$parameter1 = this.humidities[j];
                ResourceKey<Biome> resourcekey = this.pickMiddleBiomeOrBadlandsIfHot(i, j, weirdness);
                this.addSurfaceBiome(p_187238_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), weirdness, 0.0f, resourcekey);
            }
        }
    }

    protected void addUndergroundBiomes(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> p_187227_) {
        Random rand = new Random();
    }

    protected ResourceKey<Biome> pickMiddleBiome(int temp, int humidity, Climate.Parameter p_187166_) {
        if (p_187166_.f_186814_() < 0L) {
            return this.getMiddleBiomes()[temp][humidity];
        }
        ResourceKey<Biome> resourcekey = this.getMiddleBiomeVariants()[temp][humidity];
        return resourcekey == null ? this.getMiddleBiomes()[temp][humidity] : resourcekey;
    }

    protected ResourceKey<Biome> pickMiddleBiomeOrBadlandsIfHot(int temp, int humidity, Climate.Parameter p_187194_) {
        return this.pickMiddleBiome(temp, humidity, p_187194_);
    }

    protected ResourceKey<Biome> pickMiddleBiomeOrBadlandsIfHotOrSlopeIfCold(int temp, int humidity, Climate.Parameter p_187214_) {
        return this.pickMiddleBiomeOrBadlandsIfHot(temp, humidity, p_187214_);
    }

    protected ResourceKey<Biome> pickShatteredCoastBiome(int temp, int humidity, Climate.Parameter p_187225_) {
        return p_187225_.f_186814_() >= 0L ? this.pickMiddleBiome(temp, humidity, p_187225_) : this.pickBeachBiome(temp, humidity);
    }

    protected abstract ResourceKey<Biome> pickBeachBiome(int var1, int var2);

    protected ResourceKey<Biome> pickPlateauBiome(int temp, int humidity, Climate.Parameter p_187236_) {
        if (p_187236_.f_186814_() < 0L) {
            return this.getPlateauBiomes()[temp][humidity];
        }
        ResourceKey<Biome> resourcekey = this.getPlateauBiomeVariants()[temp][humidity];
        return resourcekey == null ? this.getPlateauBiomes()[temp][humidity] : resourcekey;
    }

    protected abstract ResourceKey<Biome> pickPeakBiome(int var1, int var2, Climate.Parameter var3);

    protected ResourceKey<Biome> pickShatteredBiome(int temp, int humidity, Climate.Parameter p_202004_) {
        ResourceKey<Biome> resourcekey = this.getShatteredBiomes()[temp][humidity];
        return resourcekey == null ? this.pickMiddleBiome(temp, humidity, p_202004_) : resourcekey;
    }

    protected void addSurfaceBiome(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> p_187181_, Climate.Parameter temp, Climate.Parameter humidity, Climate.Parameter continentalness, Climate.Parameter erosion, Climate.Parameter weirdness, float offset, ResourceKey<Biome> biome) {
        p_187181_.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)Climate.m_186798_((Climate.Parameter)temp, (Climate.Parameter)humidity, (Climate.Parameter)continentalness, (Climate.Parameter)erosion, (Climate.Parameter)Climate.Parameter.m_186820_((float)0.0f), (Climate.Parameter)weirdness, (float)offset), biome));
        p_187181_.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)Climate.m_186798_((Climate.Parameter)temp, (Climate.Parameter)humidity, (Climate.Parameter)continentalness, (Climate.Parameter)erosion, (Climate.Parameter)Climate.Parameter.m_186820_((float)1.0f), (Climate.Parameter)weirdness, (float)offset), biome));
    }

    protected void addUndergroundBiome(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> p_187201_, Climate.Parameter temp, Climate.Parameter humidity, Climate.Parameter continentalness, Climate.Parameter erosion, Climate.Parameter weirdness, float offset, ResourceKey<Biome> p_187208_) {
        p_187201_.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)Climate.m_186798_((Climate.Parameter)temp, (Climate.Parameter)humidity, (Climate.Parameter)continentalness, (Climate.Parameter)erosion, (Climate.Parameter)Climate.Parameter.m_186822_((float)0.2f, (float)0.9f), (Climate.Parameter)weirdness, (float)offset), p_187208_));
    }

    public static String getDebugStringForPeaksAndValleys(double p_187156_) {
        if (p_187156_ < (double)TerrainShaper.m_187265_((float)0.05f)) {
            return "Valley";
        }
        if (p_187156_ < (double)TerrainShaper.m_187265_((float)0.26666668f)) {
            return "Low";
        }
        if (p_187156_ < (double)TerrainShaper.m_187265_((float)0.4f)) {
            return "Mid";
        }
        return p_187156_ < (double)TerrainShaper.m_187265_((float)0.56666666f) ? "High" : "Peak";
    }

    public String getDebugStringForContinentalness(double p_187190_) {
        double d0 = Climate.m_186779_((float)((float)p_187190_));
        if (d0 < (double)this.mushroomFieldsContinentalness.f_186814_()) {
            return "Mushroom fields";
        }
        if (d0 < (double)this.deepOceanContinentalness.f_186814_()) {
            return "Deep ocean";
        }
        if (d0 < (double)this.oceanContinentalness.f_186814_()) {
            return "Ocean";
        }
        if (d0 < (double)this.coastContinentalness.f_186814_()) {
            return "Coast";
        }
        if (d0 < (double)this.nearInlandContinentalness.f_186814_()) {
            return "Near inland";
        }
        return d0 < (double)this.midInlandContinentalness.f_186814_() ? "Mid inland" : "Far inland";
    }
}

