/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.world.biome.builder.presets;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.SharedConstants;
import net.minecraft.data.worldgen.TerrainProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.TerrainShaper;

public class IcyPlanetBiomeBuilder {
    private static final float VALLEY_SIZE = 0.05f;
    private static final float LOW_START = 0.26666668f;
    public static final float HIGH_START = 0.4f;
    private static final float HIGH_END = 0.93333334f;
    private static final float PEAK_SIZE = 0.1f;
    public static final float PEAK_START = 0.56666666f;
    private static final float PEAK_END = 0.7666667f;
    public static final float NEAR_INLAND_START = 0.11f;
    public static final float MID_INLAND_START = 0.03f;
    public static final float FAR_INLAND_START = 0.3f;
    public static final float EROSION_INDEX_1_START = -0.78f;
    public static final float EROSION_INDEX_2_START = -0.375f;
    private final Climate.Parameter FULL_RANGE = Climate.Parameter.m_186822_((float)-1.0f, (float)1.0f);
    private final Climate.Parameter[] temperatures = new Climate.Parameter[]{Climate.Parameter.m_186822_((float)-1.0f, (float)-0.45f), Climate.Parameter.m_186822_((float)-0.45f, (float)-0.15f), Climate.Parameter.m_186822_((float)-0.15f, (float)0.2f), Climate.Parameter.m_186822_((float)0.2f, (float)0.55f), Climate.Parameter.m_186822_((float)0.55f, (float)1.0f)};
    private final Climate.Parameter[] humidities = new Climate.Parameter[]{Climate.Parameter.m_186822_((float)-1.0f, (float)-0.35f), Climate.Parameter.m_186822_((float)-0.35f, (float)-0.1f), Climate.Parameter.m_186822_((float)-0.1f, (float)0.1f), Climate.Parameter.m_186822_((float)0.1f, (float)0.3f), Climate.Parameter.m_186822_((float)0.3f, (float)1.0f)};
    private final Climate.Parameter[] erosions = new Climate.Parameter[]{Climate.Parameter.m_186822_((float)-1.0f, (float)-0.78f), Climate.Parameter.m_186822_((float)-0.78f, (float)-0.375f), Climate.Parameter.m_186822_((float)-0.375f, (float)-0.2225f), Climate.Parameter.m_186822_((float)-0.2225f, (float)0.05f), Climate.Parameter.m_186822_((float)0.05f, (float)0.45f), Climate.Parameter.m_186822_((float)0.45f, (float)0.55f), Climate.Parameter.m_186822_((float)0.55f, (float)1.0f)};
    private final Climate.Parameter FROZEN_RANGE = this.temperatures[0];
    private final Climate.Parameter UNFROZEN_RANGE = Climate.Parameter.m_186829_((Climate.Parameter)this.temperatures[1], (Climate.Parameter)this.temperatures[4]);
    private final Climate.Parameter mushroomFieldsContinentalness = Climate.Parameter.m_186822_((float)-1.2f, (float)-1.05f);
    private final Climate.Parameter deepOceanContinentalness = Climate.Parameter.m_186822_((float)-1.05f, (float)-0.455f);
    private final Climate.Parameter oceanContinentalness = Climate.Parameter.m_186822_((float)-0.455f, (float)-0.19f);
    private final Climate.Parameter coastContinentalness = Climate.Parameter.m_186822_((float)-0.19f, (float)-0.11f);
    private final Climate.Parameter inlandContinentalness = Climate.Parameter.m_186822_((float)-0.11f, (float)0.55f);
    private final Climate.Parameter nearInlandContinentalness = Climate.Parameter.m_186822_((float)-0.11f, (float)0.03f);
    private final Climate.Parameter midInlandContinentalness = Climate.Parameter.m_186822_((float)0.03f, (float)0.3f);
    private final Climate.Parameter farInlandContinentalness = Climate.Parameter.m_186822_((float)0.3f, (float)1.0f);
    private final ResourceKey<Biome>[][] OCEANS = new ResourceKey[][]{{Biomes.f_48172_, Biomes.f_48172_, Biomes.f_48171_, Biomes.f_48171_, Biomes.f_48225_}, {Biomes.f_48211_, Biomes.f_48211_, Biomes.f_48168_, Biomes.f_48168_, Biomes.f_48174_}};
    private final ResourceKey<Biome>[][] MIDDLE_BIOMES = new ResourceKey[][]{{Biomes.f_186761_, Biomes.f_186761_, Biomes.f_186761_, Biomes.f_48152_, Biomes.f_48206_}, {Biomes.f_186761_, Biomes.f_186761_, Biomes.f_48152_, Biomes.f_48152_, Biomes.f_48152_}, {Biomes.f_48179_, Biomes.f_186761_, Biomes.f_48152_, Biomes.f_48152_, Biomes.f_48152_}, {Biomes.f_48152_, Biomes.f_48152_, Biomes.f_48152_, Biomes.f_186761_, Biomes.f_186761_}, {Biomes.f_186761_, Biomes.f_186761_, Biomes.f_186761_, Biomes.f_186761_, Biomes.f_186761_}};
    private final ResourceKey<Biome>[][] MIDDLE_BIOMES_VARIANT = new ResourceKey[][]{{Biomes.f_48182_, null, Biomes.f_48152_, null, null}, {null, null, null, null, Biomes.f_48152_}, {Biomes.f_48176_, null, null, Biomes.f_48152_, null}, {null, null, Biomes.f_186761_, Biomes.f_48152_, Biomes.f_48152_}, {null, null, null, null, null}};
    private final ResourceKey<Biome>[][] PLATEAU_BIOMES = new ResourceKey[][]{{Biomes.f_186761_, Biomes.f_186761_, Biomes.f_186761_, Biomes.f_48152_, Biomes.f_48152_}, {Biomes.f_186761_, Biomes.f_186761_, Biomes.f_48152_, Biomes.f_48152_, Biomes.f_48152_}, {Biomes.f_186761_, Biomes.f_186761_, Biomes.f_186761_, Biomes.f_48152_, Biomes.f_48152_}, {Biomes.f_186761_, Biomes.f_186761_, Biomes.f_48152_, Biomes.f_48152_, Biomes.f_48152_}, {Biomes.f_186761_, Biomes.f_186761_, Biomes.f_186761_, Biomes.f_48152_, Biomes.f_48152_}};
    private final ResourceKey<Biome>[][] PLATEAU_BIOMES_VARIANT = new ResourceKey[][]{{Biomes.f_48182_, null, null, null, null}, {null, null, Biomes.f_186761_, Biomes.f_186761_, Biomes.f_48152_}, {null, null, Biomes.f_48152_, Biomes.f_48152_, null}, {null, null, null, null, null}, {Biomes.f_48182_, Biomes.f_48182_, null, null, null}};
    private final ResourceKey<Biome>[][] SHATTERED_BIOMES = new ResourceKey[][]{{Biomes.f_186756_, Biomes.f_186756_, Biomes.f_186756_, Biomes.f_186756_, Biomes.f_186756_}, {Biomes.f_186756_, Biomes.f_186756_, Biomes.f_186756_, Biomes.f_186756_, Biomes.f_186756_}, {Biomes.f_186756_, Biomes.f_186756_, Biomes.f_186756_, Biomes.f_186756_, Biomes.f_186756_}, {null, null, null, null, null}, {null, null, null, null, null}};

    public List<Climate.ParameterPoint> spawnTarget() {
        Climate.Parameter climate$parameter = Climate.Parameter.m_186820_((float)0.0f);
        float f = 0.16f;
        return List.of(new Climate.ParameterPoint(this.FULL_RANGE, this.FULL_RANGE, Climate.Parameter.m_186829_((Climate.Parameter)this.inlandContinentalness, (Climate.Parameter)this.FULL_RANGE), this.FULL_RANGE, climate$parameter, Climate.Parameter.m_186822_((float)-1.0f, (float)-0.16f), 0L), new Climate.ParameterPoint(this.FULL_RANGE, this.FULL_RANGE, Climate.Parameter.m_186829_((Climate.Parameter)this.inlandContinentalness, (Climate.Parameter)this.FULL_RANGE), this.FULL_RANGE, climate$parameter, Climate.Parameter.m_186822_((float)0.16f, (float)1.0f), 0L));
    }

    public void addBiomes(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> p_187176_) {
        if (SharedConstants.f_183698_) {
            TerrainProvider.m_194816_((boolean)false).m_187319_(p_187176_);
        } else {
            this.addOffCoastBiomes(p_187176_);
            this.addInlandBiomes(p_187176_);
            this.addUndergroundBiomes(p_187176_);
        }
    }

    private void addOffCoastBiomes(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> p_187196_) {
        for (int i = 0; i < this.temperatures.length; ++i) {
            Climate.Parameter climate$parameter = this.temperatures[i];
            this.addSurfaceBiome(p_187196_, climate$parameter, this.FULL_RANGE, this.deepOceanContinentalness, this.FULL_RANGE, this.FULL_RANGE, 0.0f, this.OCEANS[0][i]);
            this.addSurfaceBiome(p_187196_, climate$parameter, this.FULL_RANGE, this.oceanContinentalness, this.FULL_RANGE, this.FULL_RANGE, 0.0f, this.OCEANS[1][i]);
        }
    }

    private void addInlandBiomes(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> p_187216_) {
        this.addMidSlice(p_187216_, Climate.Parameter.m_186822_((float)-1.0f, (float)-0.93333334f));
        this.addHighSlice(p_187216_, Climate.Parameter.m_186822_((float)-0.93333334f, (float)-0.7666667f));
        this.addPeaks(p_187216_, Climate.Parameter.m_186822_((float)-0.7666667f, (float)-0.56666666f));
        this.addHighSlice(p_187216_, Climate.Parameter.m_186822_((float)-0.56666666f, (float)-0.4f));
        this.addMidSlice(p_187216_, Climate.Parameter.m_186822_((float)-0.4f, (float)-0.26666668f));
        this.addLowSlice(p_187216_, Climate.Parameter.m_186822_((float)-0.26666668f, (float)-0.05f));
        this.addValleys(p_187216_, Climate.Parameter.m_186822_((float)-0.05f, (float)0.05f));
        this.addLowSlice(p_187216_, Climate.Parameter.m_186822_((float)0.05f, (float)0.26666668f));
        this.addMidSlice(p_187216_, Climate.Parameter.m_186822_((float)0.26666668f, (float)0.4f));
        this.addHighSlice(p_187216_, Climate.Parameter.m_186822_((float)0.4f, (float)0.56666666f));
        this.addPeaks(p_187216_, Climate.Parameter.m_186822_((float)0.56666666f, (float)0.7666667f));
        this.addHighSlice(p_187216_, Climate.Parameter.m_186822_((float)0.7666667f, (float)0.93333334f));
        this.addMidSlice(p_187216_, Climate.Parameter.m_186822_((float)0.93333334f, (float)1.0f));
    }

    private void addPeaks(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> p_187178_, Climate.Parameter p_187179_) {
        for (int i = 0; i < this.temperatures.length; ++i) {
            Climate.Parameter climate$parameter = this.temperatures[i];
            for (int j = 0; j < this.humidities.length; ++j) {
                Climate.Parameter climate$parameter1 = this.humidities[j];
                ResourceKey<Biome> resourcekey = this.pickMiddleBiome(i, j, p_187179_);
                ResourceKey<Biome> resourcekey1 = this.pickMiddleBiomeOrBadlandsIfHot(i, j, p_187179_);
                ResourceKey<Biome> resourcekey2 = this.pickMiddleBiomeOrBadlandsIfHotOrSlopeIfCold(i, j, p_187179_);
                ResourceKey<Biome> resourcekey3 = this.pickPlateauBiome(i, j, p_187179_);
                ResourceKey<Biome> resourcekey4 = this.pickShatteredBiome(i, j, p_187179_);
                ResourceKey<Biome> resourcekey5 = this.maybePickWindsweptSavannaBiome(i, j, p_187179_, resourcekey4);
                ResourceKey<Biome> resourcekey6 = this.pickPeakBiome(i, j, p_187179_);
                this.addSurfaceBiome(p_187178_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[0], p_187179_, 0.0f, resourcekey6);
                this.addSurfaceBiome(p_187178_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), this.erosions[1], p_187179_, 0.0f, resourcekey2);
                this.addSurfaceBiome(p_187178_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[1], p_187179_, 0.0f, resourcekey6);
                this.addSurfaceBiome(p_187178_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[2], (Climate.Parameter)this.erosions[3]), p_187179_, 0.0f, resourcekey);
                this.addSurfaceBiome(p_187178_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[2], p_187179_, 0.0f, resourcekey3);
                this.addSurfaceBiome(p_187178_, climate$parameter, climate$parameter1, this.midInlandContinentalness, this.erosions[3], p_187179_, 0.0f, resourcekey1);
                this.addSurfaceBiome(p_187178_, climate$parameter, climate$parameter1, this.farInlandContinentalness, this.erosions[3], p_187179_, 0.0f, resourcekey3);
                this.addSurfaceBiome(p_187178_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[4], p_187179_, 0.0f, resourcekey);
                this.addSurfaceBiome(p_187178_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), this.erosions[5], p_187179_, 0.0f, resourcekey5);
                this.addSurfaceBiome(p_187178_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[5], p_187179_, 0.0f, resourcekey4);
                this.addSurfaceBiome(p_187178_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], p_187179_, 0.0f, resourcekey);
            }
        }
    }

    private void addHighSlice(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> p_187198_, Climate.Parameter p_187199_) {
        for (int i = 0; i < this.temperatures.length; ++i) {
            Climate.Parameter climate$parameter = this.temperatures[i];
            for (int j = 0; j < this.humidities.length; ++j) {
                Climate.Parameter climate$parameter1 = this.humidities[j];
                ResourceKey<Biome> resourcekey = this.pickMiddleBiome(i, j, p_187199_);
                ResourceKey<Biome> resourcekey1 = this.pickMiddleBiomeOrBadlandsIfHot(i, j, p_187199_);
                ResourceKey<Biome> resourcekey2 = this.pickMiddleBiomeOrBadlandsIfHotOrSlopeIfCold(i, j, p_187199_);
                ResourceKey<Biome> resourcekey3 = this.pickPlateauBiome(i, j, p_187199_);
                ResourceKey<Biome> resourcekey4 = this.pickShatteredBiome(i, j, p_187199_);
                ResourceKey<Biome> resourcekey5 = this.maybePickWindsweptSavannaBiome(i, j, p_187199_, resourcekey);
                ResourceKey<Biome> resourcekey6 = this.pickSlopeBiome(i, j, p_187199_);
                ResourceKey<Biome> resourcekey7 = this.pickPeakBiome(i, j, p_187199_);
                this.addSurfaceBiome(p_187198_, climate$parameter, climate$parameter1, this.coastContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), p_187199_, 0.0f, resourcekey);
                this.addSurfaceBiome(p_187198_, climate$parameter, climate$parameter1, this.nearInlandContinentalness, this.erosions[0], p_187199_, 0.0f, resourcekey6);
                this.addSurfaceBiome(p_187198_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[0], p_187199_, 0.0f, resourcekey7);
                this.addSurfaceBiome(p_187198_, climate$parameter, climate$parameter1, this.nearInlandContinentalness, this.erosions[1], p_187199_, 0.0f, resourcekey2);
                this.addSurfaceBiome(p_187198_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[1], p_187199_, 0.0f, resourcekey6);
                this.addSurfaceBiome(p_187198_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[2], (Climate.Parameter)this.erosions[3]), p_187199_, 0.0f, resourcekey);
                this.addSurfaceBiome(p_187198_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[2], p_187199_, 0.0f, resourcekey3);
                this.addSurfaceBiome(p_187198_, climate$parameter, climate$parameter1, this.midInlandContinentalness, this.erosions[3], p_187199_, 0.0f, resourcekey1);
                this.addSurfaceBiome(p_187198_, climate$parameter, climate$parameter1, this.farInlandContinentalness, this.erosions[3], p_187199_, 0.0f, resourcekey3);
                this.addSurfaceBiome(p_187198_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[4], p_187199_, 0.0f, resourcekey);
                this.addSurfaceBiome(p_187198_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), this.erosions[5], p_187199_, 0.0f, resourcekey5);
                this.addSurfaceBiome(p_187198_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[5], p_187199_, 0.0f, resourcekey4);
                this.addSurfaceBiome(p_187198_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], p_187199_, 0.0f, resourcekey);
            }
        }
    }

    private void addMidSlice(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> p_187218_, Climate.Parameter p_187219_) {
        this.addSurfaceBiome(p_187218_, this.FULL_RANGE, this.FULL_RANGE, this.coastContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[2]), p_187219_, 0.0f, (ResourceKey<Biome>)Biomes.f_48148_);
        for (int i = 0; i < this.temperatures.length; ++i) {
            Climate.Parameter climate$parameter = this.temperatures[i];
            for (int j = 0; j < this.humidities.length; ++j) {
                Climate.Parameter climate$parameter1 = this.humidities[j];
                ResourceKey<Biome> resourcekey = this.pickMiddleBiome(i, j, p_187219_);
                ResourceKey<Biome> resourcekey1 = this.pickMiddleBiomeOrBadlandsIfHot(i, j, p_187219_);
                ResourceKey<Biome> resourcekey2 = this.pickMiddleBiomeOrBadlandsIfHotOrSlopeIfCold(i, j, p_187219_);
                ResourceKey<Biome> resourcekey3 = this.pickShatteredBiome(i, j, p_187219_);
                ResourceKey<Biome> resourcekey4 = this.pickPlateauBiome(i, j, p_187219_);
                ResourceKey<Biome> resourcekey5 = this.pickBeachBiome(i, j);
                ResourceKey<Biome> resourcekey6 = this.maybePickWindsweptSavannaBiome(i, j, p_187219_, resourcekey);
                ResourceKey<Biome> resourcekey7 = this.pickShatteredCoastBiome(i, j, p_187219_);
                ResourceKey<Biome> resourcekey8 = this.pickSlopeBiome(i, j, p_187219_);
                this.addSurfaceBiome(p_187218_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[0], p_187219_, 0.0f, resourcekey8);
                this.addSurfaceBiome(p_187218_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.midInlandContinentalness), this.erosions[1], p_187219_, 0.0f, resourcekey2);
                this.addSurfaceBiome(p_187218_, climate$parameter, climate$parameter1, this.farInlandContinentalness, this.erosions[1], p_187219_, 0.0f, i == 0 ? resourcekey8 : resourcekey4);
                this.addSurfaceBiome(p_187218_, climate$parameter, climate$parameter1, this.nearInlandContinentalness, this.erosions[2], p_187219_, 0.0f, resourcekey);
                this.addSurfaceBiome(p_187218_, climate$parameter, climate$parameter1, this.midInlandContinentalness, this.erosions[2], p_187219_, 0.0f, resourcekey1);
                this.addSurfaceBiome(p_187218_, climate$parameter, climate$parameter1, this.farInlandContinentalness, this.erosions[2], p_187219_, 0.0f, resourcekey4);
                this.addSurfaceBiome(p_187218_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), this.erosions[3], p_187219_, 0.0f, resourcekey);
                this.addSurfaceBiome(p_187218_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[3], p_187219_, 0.0f, resourcekey1);
                if (p_187219_.f_186814_() < 0L) {
                    this.addSurfaceBiome(p_187218_, climate$parameter, climate$parameter1, this.coastContinentalness, this.erosions[4], p_187219_, 0.0f, resourcekey5);
                    this.addSurfaceBiome(p_187218_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[4], p_187219_, 0.0f, resourcekey);
                } else {
                    this.addSurfaceBiome(p_187218_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[4], p_187219_, 0.0f, resourcekey);
                }
                this.addSurfaceBiome(p_187218_, climate$parameter, climate$parameter1, this.coastContinentalness, this.erosions[5], p_187219_, 0.0f, resourcekey7);
                this.addSurfaceBiome(p_187218_, climate$parameter, climate$parameter1, this.nearInlandContinentalness, this.erosions[5], p_187219_, 0.0f, resourcekey6);
                this.addSurfaceBiome(p_187218_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[5], p_187219_, 0.0f, resourcekey3);
                if (p_187219_.f_186814_() < 0L) {
                    this.addSurfaceBiome(p_187218_, climate$parameter, climate$parameter1, this.coastContinentalness, this.erosions[6], p_187219_, 0.0f, resourcekey5);
                } else {
                    this.addSurfaceBiome(p_187218_, climate$parameter, climate$parameter1, this.coastContinentalness, this.erosions[6], p_187219_, 0.0f, resourcekey);
                }
                if (i != 0) continue;
                this.addSurfaceBiome(p_187218_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], p_187219_, 0.0f, resourcekey);
            }
        }
    }

    private void addLowSlice(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> p_187229_, Climate.Parameter p_187230_) {
        this.addSurfaceBiome(p_187229_, this.FULL_RANGE, this.FULL_RANGE, this.coastContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[2]), p_187230_, 0.0f, (ResourceKey<Biome>)Biomes.f_48148_);
        for (int i = 0; i < this.temperatures.length; ++i) {
            Climate.Parameter climate$parameter = this.temperatures[i];
            for (int j = 0; j < this.humidities.length; ++j) {
                Climate.Parameter climate$parameter1 = this.humidities[j];
                ResourceKey<Biome> resourcekey = this.pickMiddleBiome(i, j, p_187230_);
                ResourceKey<Biome> resourcekey1 = this.pickMiddleBiomeOrBadlandsIfHot(i, j, p_187230_);
                ResourceKey<Biome> resourcekey2 = this.pickMiddleBiomeOrBadlandsIfHotOrSlopeIfCold(i, j, p_187230_);
                ResourceKey<Biome> resourcekey3 = this.pickBeachBiome(i, j);
                ResourceKey<Biome> resourcekey4 = this.maybePickWindsweptSavannaBiome(i, j, p_187230_, resourcekey);
                ResourceKey<Biome> resourcekey5 = this.pickShatteredCoastBiome(i, j, p_187230_);
                this.addSurfaceBiome(p_187229_, climate$parameter, climate$parameter1, this.nearInlandContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), p_187230_, 0.0f, resourcekey1);
                this.addSurfaceBiome(p_187229_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), p_187230_, 0.0f, resourcekey2);
                this.addSurfaceBiome(p_187229_, climate$parameter, climate$parameter1, this.nearInlandContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[2], (Climate.Parameter)this.erosions[3]), p_187230_, 0.0f, resourcekey);
                this.addSurfaceBiome(p_187229_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[2], (Climate.Parameter)this.erosions[3]), p_187230_, 0.0f, resourcekey1);
                this.addSurfaceBiome(p_187229_, climate$parameter, climate$parameter1, this.coastContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[3], (Climate.Parameter)this.erosions[4]), p_187230_, 0.0f, resourcekey3);
                this.addSurfaceBiome(p_187229_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[4], p_187230_, 0.0f, resourcekey);
                this.addSurfaceBiome(p_187229_, climate$parameter, climate$parameter1, this.coastContinentalness, this.erosions[5], p_187230_, 0.0f, resourcekey5);
                this.addSurfaceBiome(p_187229_, climate$parameter, climate$parameter1, this.nearInlandContinentalness, this.erosions[5], p_187230_, 0.0f, resourcekey4);
                this.addSurfaceBiome(p_187229_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[5], p_187230_, 0.0f, resourcekey);
                this.addSurfaceBiome(p_187229_, climate$parameter, climate$parameter1, this.coastContinentalness, this.erosions[6], p_187230_, 0.0f, resourcekey3);
                if (i != 0) continue;
                this.addSurfaceBiome(p_187229_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], p_187230_, 0.0f, resourcekey);
            }
        }
    }

    private void addValleys(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> p_187238_, Climate.Parameter p_187239_) {
        this.addSurfaceBiome(p_187238_, this.FROZEN_RANGE, this.FULL_RANGE, this.coastContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), p_187239_, 0.0f, (ResourceKey<Biome>)Biomes.f_48212_);
        this.addSurfaceBiome(p_187238_, this.UNFROZEN_RANGE, this.FULL_RANGE, this.coastContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), p_187239_, 0.0f, (ResourceKey<Biome>)Biomes.f_48212_);
        this.addSurfaceBiome(p_187238_, this.FROZEN_RANGE, this.FULL_RANGE, this.nearInlandContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), p_187239_, 0.0f, (ResourceKey<Biome>)Biomes.f_48212_);
        this.addSurfaceBiome(p_187238_, this.UNFROZEN_RANGE, this.FULL_RANGE, this.nearInlandContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), p_187239_, 0.0f, (ResourceKey<Biome>)Biomes.f_48212_);
        this.addSurfaceBiome(p_187238_, this.FROZEN_RANGE, this.FULL_RANGE, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[2], (Climate.Parameter)this.erosions[5]), p_187239_, 0.0f, (ResourceKey<Biome>)Biomes.f_48212_);
        this.addSurfaceBiome(p_187238_, this.UNFROZEN_RANGE, this.FULL_RANGE, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[2], (Climate.Parameter)this.erosions[5]), p_187239_, 0.0f, (ResourceKey<Biome>)Biomes.f_48212_);
        this.addSurfaceBiome(p_187238_, this.FROZEN_RANGE, this.FULL_RANGE, this.coastContinentalness, this.erosions[6], p_187239_, 0.0f, (ResourceKey<Biome>)Biomes.f_48212_);
        this.addSurfaceBiome(p_187238_, this.UNFROZEN_RANGE, this.FULL_RANGE, this.coastContinentalness, this.erosions[6], p_187239_, 0.0f, (ResourceKey<Biome>)Biomes.f_48212_);
        this.addSurfaceBiome(p_187238_, this.UNFROZEN_RANGE, this.FULL_RANGE, Climate.Parameter.m_186829_((Climate.Parameter)this.inlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], p_187239_, 0.0f, (ResourceKey<Biome>)Biomes.f_48148_);
        this.addSurfaceBiome(p_187238_, this.FROZEN_RANGE, this.FULL_RANGE, Climate.Parameter.m_186829_((Climate.Parameter)this.inlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], p_187239_, 0.0f, (ResourceKey<Biome>)Biomes.f_48212_);
        for (int i = 0; i < this.temperatures.length; ++i) {
            Climate.Parameter climate$parameter = this.temperatures[i];
            for (int j = 0; j < this.humidities.length; ++j) {
                Climate.Parameter climate$parameter1 = this.humidities[j];
                ResourceKey<Biome> resourcekey = this.pickMiddleBiomeOrBadlandsIfHot(i, j, p_187239_);
                this.addSurfaceBiome(p_187238_, climate$parameter, climate$parameter1, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), p_187239_, 0.0f, resourcekey);
            }
        }
    }

    private void addUndergroundBiomes(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> p_187227_) {
    }

    private ResourceKey<Biome> pickMiddleBiome(int p_187164_, int p_187165_, Climate.Parameter p_187166_) {
        if (p_187166_.f_186814_() < 0L) {
            return this.MIDDLE_BIOMES[p_187164_][p_187165_];
        }
        ResourceKey<Biome> resourcekey = this.MIDDLE_BIOMES_VARIANT[p_187164_][p_187165_];
        return resourcekey == null ? this.MIDDLE_BIOMES[p_187164_][p_187165_] : resourcekey;
    }

    private ResourceKey<Biome> pickMiddleBiomeOrBadlandsIfHot(int p_187192_, int p_187193_, Climate.Parameter p_187194_) {
        return p_187192_ == 4 ? this.pickBadlandsBiome(p_187193_, p_187194_) : this.pickMiddleBiome(p_187192_, p_187193_, p_187194_);
    }

    private ResourceKey<Biome> pickMiddleBiomeOrBadlandsIfHotOrSlopeIfCold(int p_187212_, int p_187213_, Climate.Parameter p_187214_) {
        return p_187212_ == 0 ? this.pickSlopeBiome(p_187212_, p_187213_, p_187214_) : this.pickMiddleBiomeOrBadlandsIfHot(p_187212_, p_187213_, p_187214_);
    }

    private ResourceKey<Biome> maybePickWindsweptSavannaBiome(int p_201991_, int p_201992_, Climate.Parameter p_201993_, ResourceKey<Biome> p_201994_) {
        return p_201991_ > 1 && p_201992_ < 4 && p_201993_.f_186814_() >= 0L ? Biomes.f_186761_ : p_201994_;
    }

    private ResourceKey<Biome> pickShatteredCoastBiome(int p_187223_, int p_187224_, Climate.Parameter p_187225_) {
        ResourceKey<Biome> resourcekey = p_187225_.f_186814_() >= 0L ? this.pickMiddleBiome(p_187223_, p_187224_, p_187225_) : this.pickBeachBiome(p_187223_, p_187224_);
        return this.maybePickWindsweptSavannaBiome(p_187223_, p_187224_, p_187225_, resourcekey);
    }

    private ResourceKey<Biome> pickBeachBiome(int p_187161_, int p_187162_) {
        if (p_187161_ == 0) {
            return Biomes.f_48148_;
        }
        return p_187161_ == 4 ? Biomes.f_186761_ : Biomes.f_48148_;
    }

    private ResourceKey<Biome> pickBadlandsBiome(int p_187173_, Climate.Parameter p_187174_) {
        if (p_187173_ < 2) {
            return p_187174_.f_186814_() < 0L ? Biomes.f_48182_ : Biomes.f_186761_;
        }
        return p_187173_ < 3 ? Biomes.f_186761_ : Biomes.f_48152_;
    }

    private ResourceKey<Biome> pickPlateauBiome(int p_187234_, int p_187235_, Climate.Parameter p_187236_) {
        if (p_187236_.f_186814_() < 0L) {
            return this.PLATEAU_BIOMES[p_187234_][p_187235_];
        }
        ResourceKey<Biome> resourcekey = this.PLATEAU_BIOMES_VARIANT[p_187234_][p_187235_];
        return resourcekey == null ? this.PLATEAU_BIOMES[p_187234_][p_187235_] : resourcekey;
    }

    private ResourceKey<Biome> pickPeakBiome(int p_187241_, int p_187242_, Climate.Parameter p_187243_) {
        if (p_187241_ <= 2) {
            return Biomes.f_186757_;
        }
        return p_187241_ == 3 ? Biomes.f_186757_ : this.pickBadlandsBiome(p_187242_, p_187243_);
    }

    private ResourceKey<Biome> pickSlopeBiome(int p_187245_, int p_187246_, Climate.Parameter p_187247_) {
        if (p_187245_ >= 3) {
            return this.pickPlateauBiome(p_187245_, p_187246_, p_187247_);
        }
        return p_187246_ <= 1 ? Biomes.f_186756_ : Biomes.f_186761_;
    }

    private ResourceKey<Biome> pickShatteredBiome(int p_202002_, int p_202003_, Climate.Parameter p_202004_) {
        ResourceKey<Biome> resourcekey = this.SHATTERED_BIOMES[p_202002_][p_202003_];
        return resourcekey == null ? this.pickMiddleBiome(p_202002_, p_202003_, p_202004_) : resourcekey;
    }

    private void addSurfaceBiome(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> p_187181_, Climate.Parameter p_187182_, Climate.Parameter p_187183_, Climate.Parameter p_187184_, Climate.Parameter p_187185_, Climate.Parameter p_187186_, float p_187187_, ResourceKey<Biome> p_187188_) {
        p_187181_.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)Climate.m_186798_((Climate.Parameter)p_187182_, (Climate.Parameter)p_187183_, (Climate.Parameter)p_187184_, (Climate.Parameter)p_187185_, (Climate.Parameter)Climate.Parameter.m_186820_((float)0.0f), (Climate.Parameter)p_187186_, (float)p_187187_), p_187188_));
        p_187181_.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)Climate.m_186798_((Climate.Parameter)p_187182_, (Climate.Parameter)p_187183_, (Climate.Parameter)p_187184_, (Climate.Parameter)p_187185_, (Climate.Parameter)Climate.Parameter.m_186820_((float)1.0f), (Climate.Parameter)p_187186_, (float)p_187187_), p_187188_));
    }

    private void addUndergroundBiome(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> p_187201_, Climate.Parameter p_187202_, Climate.Parameter p_187203_, Climate.Parameter p_187204_, Climate.Parameter p_187205_, Climate.Parameter p_187206_, float p_187207_, ResourceKey<Biome> p_187208_) {
        p_187201_.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)Climate.m_186798_((Climate.Parameter)p_187202_, (Climate.Parameter)p_187203_, (Climate.Parameter)p_187204_, (Climate.Parameter)p_187205_, (Climate.Parameter)Climate.Parameter.m_186822_((float)0.2f, (float)0.9f), (Climate.Parameter)p_187206_, (float)p_187207_), p_187208_));
    }

    public static String getDebugStringForPeaksAndValleys(double p_187156_) {
        if (p_187156_ < (double)TerrainShaper.m_187265_((float)0.05f)) {
            return "Valley";
        }
        if (p_187156_ < (double)TerrainShaper.m_187265_((float)0.26666668f)) {
            return "Low";
        }
        if (p_187156_ < (double)TerrainShaper.m_187265_((float)0.4f)) {
            return "Mid";
        }
        return p_187156_ < (double)TerrainShaper.m_187265_((float)0.56666666f) ? "High" : "Peak";
    }

    public String getDebugStringForContinentalness(double p_187190_) {
        double d0 = Climate.m_186779_((float)((float)p_187190_));
        if (d0 < (double)this.mushroomFieldsContinentalness.f_186814_()) {
            return "Mushroom fields";
        }
        if (d0 < (double)this.deepOceanContinentalness.f_186814_()) {
            return "Deep ocean";
        }
        if (d0 < (double)this.oceanContinentalness.f_186814_()) {
            return "Ocean";
        }
        if (d0 < (double)this.coastContinentalness.f_186814_()) {
            return "Coast";
        }
        if (d0 < (double)this.nearInlandContinentalness.f_186814_()) {
            return "Near inland";
        }
        return d0 < (double)this.midInlandContinentalness.f_186814_() ? "Mid inland" : "Far inland";
    }

    public String getDebugStringForErosion(double p_187210_) {
        return IcyPlanetBiomeBuilder.getDebugStringForNoiseValue(p_187210_, this.erosions);
    }

    public String getDebugStringForTemperature(double p_187221_) {
        return IcyPlanetBiomeBuilder.getDebugStringForNoiseValue(p_187221_, this.temperatures);
    }

    public String getDebugStringForHumidity(double p_187232_) {
        return IcyPlanetBiomeBuilder.getDebugStringForNoiseValue(p_187232_, this.humidities);
    }

    private static String getDebugStringForNoiseValue(double p_187158_, Climate.Parameter[] p_187159_) {
        double d0 = Climate.m_186779_((float)((float)p_187158_));
        for (int i = 0; i < p_187159_.length; ++i) {
            if (!(d0 < (double)p_187159_[i].f_186814_())) continue;
            return "" + i;
        }
        return "?";
    }

    @VisibleForDebug
    public Climate.Parameter[] getTemperatureThresholds() {
        return this.temperatures;
    }

    @VisibleForDebug
    public Climate.Parameter[] getHumidityThresholds() {
        return this.humidities;
    }

    @VisibleForDebug
    public Climate.Parameter[] getErosionThresholds() {
        return this.erosions;
    }

    @VisibleForDebug
    public Climate.Parameter[] getContinentalnessThresholds() {
        return new Climate.Parameter[]{this.mushroomFieldsContinentalness, this.deepOceanContinentalness, this.oceanContinentalness, this.coastContinentalness, this.nearInlandContinentalness, this.midInlandContinentalness, this.farInlandContinentalness};
    }

    @VisibleForDebug
    public Climate.Parameter[] getPeaksAndValleysThresholds() {
        return new Climate.Parameter[]{Climate.Parameter.m_186822_((float)-2.0f, (float)TerrainShaper.m_187265_((float)0.05f)), Climate.Parameter.m_186822_((float)TerrainShaper.m_187265_((float)0.05f), (float)TerrainShaper.m_187265_((float)0.26666668f)), Climate.Parameter.m_186822_((float)TerrainShaper.m_187265_((float)0.26666668f), (float)TerrainShaper.m_187265_((float)0.4f)), Climate.Parameter.m_186822_((float)TerrainShaper.m_187265_((float)0.4f), (float)TerrainShaper.m_187265_((float)0.56666666f)), Climate.Parameter.m_186822_((float)TerrainShaper.m_187265_((float)0.56666666f), (float)2.0f)};
    }

    @VisibleForDebug
    public Climate.Parameter[] getWeirdnessThresholds() {
        return new Climate.Parameter[]{Climate.Parameter.m_186822_((float)-2.0f, (float)0.0f), Climate.Parameter.m_186822_((float)0.0f, (float)2.0f)};
    }
}

