/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.world.renderer;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import com.shim.celestialexploration.world.renderer.AbstractSkyHandler;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class DatapackSkyHandler
extends AbstractSkyHandler {
    final String stars;
    final String milkyway;
    @Nullable
    final CelestialObject sun1;
    @Nullable
    final CelestialObject sun2;
    final String ringColor;
    @Nullable
    final CelestialObject moon1;
    @Nullable
    final CelestialObject moon2;
    @Nullable
    final CelestialObject moon3;
    @Nullable
    final CelestialObject moon4;

    public DatapackSkyHandler(String stars, String milkyway, @Nullable CelestialObject sun1, @Nullable CelestialObject sun2, String ringColor, @Nullable CelestialObject moon1, @Nullable CelestialObject moon2, @Nullable CelestialObject moon3, @Nullable CelestialObject moon4) {
        this.stars = stars;
        this.milkyway = milkyway;
        this.sun1 = sun1;
        this.sun2 = sun2;
        this.ringColor = ringColor;
        this.moon1 = moon1;
        this.moon2 = moon2;
        this.moon3 = moon3;
        this.moon4 = moon4;
    }

    public void render(int ticks, float partialTick, PoseStack poseStack, ClientLevel level, Minecraft minecraft) {
        RenderSystem.m_69472_();
        Vec3 vec3 = level.m_171660_(minecraft.f_91063_.m_109153_().m_90583_(), partialTick);
        float x = (float)vec3.f_82479_;
        float y = (float)vec3.f_82480_;
        float z = (float)vec3.f_82481_;
        FogRenderer.m_109036_();
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        RenderSystem.m_69458_((boolean)false);
        RenderSystem.m_157429_((float)x, (float)y, (float)z, (float)1.0f);
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        float[] sunriseColor = level.m_104583_().m_7518_(level.m_46942_(partialTick), partialTick);
        if (sunriseColor != null) {
            RenderSystem.m_157427_(GameRenderer::m_172811_);
            RenderSystem.m_69472_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            poseStack.m_85836_();
            poseStack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
            float f2 = Mth.m_14031_((float)level.m_46490_(partialTick)) < 0.0f ? 180.0f : 0.0f;
            poseStack.m_85845_(Vector3f.f_122227_.m_122240_(f2));
            poseStack.m_85845_(Vector3f.f_122227_.m_122240_(90.0f));
            float f3 = sunriseColor[0];
            float f4 = sunriseColor[1];
            float f5 = sunriseColor[2];
            Matrix4f matrix4f = poseStack.m_85850_().m_85861_();
            bufferbuilder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
            bufferbuilder.m_85982_(matrix4f, 0.0f, 100.0f, 0.0f).m_85950_(f3, f4, f5, sunriseColor[3]).m_5752_();
            for (int j = 0; j <= 16; ++j) {
                float f6 = (float)j * ((float)Math.PI * 2) / 16.0f;
                float f7 = Mth.m_14031_((float)f6);
                float f8 = Mth.m_14089_((float)f6);
                bufferbuilder.m_85982_(matrix4f, f7 * 120.0f, f8 * 120.0f, -f8 * 40.0f * sunriseColor[3]).m_85950_(sunriseColor[0], sunriseColor[1], sunriseColor[2], 0.0f).m_5752_();
            }
            bufferbuilder.m_85721_();
            BufferUploader.m_85761_((BufferBuilder)bufferbuilder);
            poseStack.m_85849_();
        }
        RenderSystem.m_69493_();
        RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        if (!this.stars.equalsIgnoreCase("none")) {
            if (this.stars.equalsIgnoreCase("always")) {
                this.renderStars(poseStack, level, partialTick, true);
            } else if (this.stars.equalsIgnoreCase("night")) {
                this.renderStars(poseStack, level, partialTick, false);
            }
        }
        if (!this.milkyway.equalsIgnoreCase("none")) {
            RenderSystem.m_69458_((boolean)false);
            RenderSystem.m_157429_((float)x, (float)y, (float)z, (float)1.0f);
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            RenderSystem.m_69493_();
            RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            if (this.milkyway.equalsIgnoreCase("always")) {
                this.renderMilkyWay(poseStack, level, partialTick, true);
            } else if (this.milkyway.equalsIgnoreCase("night")) {
                this.renderMilkyWay(poseStack, level, partialTick, false);
            }
        }
        if (this.sun2 != null) {
            RenderSystem.m_69458_((boolean)false);
            RenderSystem.m_157429_((float)x, (float)y, (float)z, (float)1.0f);
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            RenderSystem.m_69493_();
            RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            this.renderSun(poseStack, level, partialTick, 20.0f, 20.0f, this.sun2.texture(), this.sun2.size());
        }
        if (this.sun1 != null) {
            RenderSystem.m_69458_((boolean)false);
            RenderSystem.m_157429_((float)x, (float)y, (float)z, (float)1.0f);
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            RenderSystem.m_69493_();
            RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            this.renderSun(poseStack, level, partialTick, 0.0f, 0.0f, this.sun1.texture(), this.sun1.size());
        }
        if (this.moon1 != null) {
            RenderSystem.m_69458_((boolean)false);
            RenderSystem.m_157429_((float)x, (float)y, (float)z, (float)1.0f);
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            RenderSystem.m_69493_();
            RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            this.renderMoon(poseStack, level, partialTick, 0.0f, 0.0f, this.moon1.texture(), this.moon1.size());
        }
        if (this.moon2 != null) {
            RenderSystem.m_69458_((boolean)false);
            RenderSystem.m_157429_((float)x, (float)y, (float)z, (float)1.0f);
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            RenderSystem.m_69493_();
            RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            this.renderMoon(poseStack, level, partialTick, 10.0f, 10.0f, this.moon2.texture(), this.moon2.size());
        }
        if (this.moon3 != null) {
            RenderSystem.m_69458_((boolean)false);
            RenderSystem.m_157429_((float)x, (float)y, (float)z, (float)1.0f);
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            RenderSystem.m_69493_();
            RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            this.renderMoon(poseStack, level, partialTick, -20.0f, -20.0f, this.moon3.texture(), this.moon3.size());
        }
        if (this.moon4 != null) {
            RenderSystem.m_69458_((boolean)false);
            RenderSystem.m_157429_((float)x, (float)y, (float)z, (float)1.0f);
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            RenderSystem.m_69493_();
            RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            this.renderMoon(poseStack, level, partialTick, 30.0f, -30.0f, this.moon4.texture(), this.moon4.size());
        }
        if (this.ringColor != null) {
            RenderSystem.m_69461_();
            this.renderRings(poseStack, level, partialTick, this.ringColor);
        }
    }

    public record CelestialObject(ResourceLocation texture, float size) {
    }
}

