/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.world.structures.space;

import com.shim.celestialexploration.util.CelestialUtil;
import com.shim.celestialexploration.world.structures.CelestialConfiguration;
import com.shim.celestialexploration.world.structures.CelestialPlacement;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.PostPlacementProcessor;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import org.jetbrains.annotations.NotNull;

public class PlanetStructure
extends StructureFeature<CelestialConfiguration> {
    public PlanetStructure() {
        super(CelestialConfiguration.CODEC, PlanetStructure::createPiecesGenerator, PostPlacementProcessor.f_192427_);
    }

    public GenerationStep.Decoration m_67095_() {
        return GenerationStep.Decoration.SURFACE_STRUCTURES;
    }

    private static boolean isFeatureChunk(PieceGeneratorSupplier.Context<CelestialConfiguration> context) {
        ChunkPos chunkpos = context.f_197355_();
        return chunkpos.f_45578_ == ((CelestialConfiguration)context.f_197356_()).x() * CelestialUtil.getSpaceRatio() && chunkpos.f_45579_ == ((CelestialConfiguration)context.f_197356_()).z() * CelestialUtil.getSpaceRatio();
    }

    @NotNull
    public static Optional<PieceGenerator<CelestialConfiguration>> createPiecesGenerator(PieceGeneratorSupplier.Context<CelestialConfiguration> context) {
        if (!PlanetStructure.isFeatureChunk(context)) {
            return Optional.empty();
        }
        BlockPos blockpos = context.f_197355_().m_151394_(0);
        Optional<PieceGenerator<CelestialConfiguration>> structurePiecesGenerator = CelestialPlacement.addPieces(context, PoolElementStructurePiece::new, blockpos = new BlockPos(blockpos.m_123341_(), 64, blockpos.m_123343_()), false, false);
        if (structurePiecesGenerator.isPresent()) {
            // empty if block
        }
        return structurePiecesGenerator;
    }
}

