/*
 * Decompiled with CFR 0.152.
 */
package ru.imaginaerum.wd.common.blocks.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.PlantType;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;
import ru.imaginaerum.wd.WD;
import ru.imaginaerum.wd.common.blocks.entity.RoseMurdererBlockEntity;
import ru.imaginaerum.wd.common.particles.ModParticles;

public class RoseMurderer
extends BaseEntityBlock
implements IPlantable {
    public static final BooleanProperty IS_SOUL = BooleanProperty.m_61465_((String)"is_soul");

    public RoseMurderer(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)IS_SOUL, (Comparable)Boolean.valueOf(false)));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public RenderShape m_7514_(BlockState p_49232_) {
        return RenderShape.MODEL;
    }

    @SubscribeEvent
    public void onEntityDrops(LivingDropsEvent event) {
        LivingEntity entity = event.getEntity();
        Level level = entity.m_9236_();
        BlockPos pos = entity.m_20183_();
        BlockState blockState = level.m_8055_(pos);
        if (!(entity instanceof Player) && blockState.m_60734_() instanceof RoseMurderer) {
            event.getDrops().clear();
            event.setCanceled(true);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{IS_SOUL});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)IS_SOUL, (Comparable)Boolean.valueOf(false));
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_()) && !world.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50136_)) {
            world.m_46961_(pos, true);
        }
        super.m_6810_(state, world, pos, newState, isMoving);
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!state.m_60710_((LevelReader)level, pos)) {
            level.m_46961_(pos, true);
            return;
        }
        BlockState currentBlockState = level.m_8055_(pos);
        if (currentBlockState.m_60734_() != this) {
            return;
        }
        WD.queueServerWork(140, () -> {
            if (level.m_8055_(pos).m_60734_() == this) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)IS_SOUL, (Comparable)Boolean.valueOf(false)), 3);
                BlockEntity blockEntity = level.m_7702_(pos);
                if (blockEntity != null) {
                    blockEntity.getPersistentData().m_128473_("entity_type");
                    blockEntity.getPersistentData().m_128473_("entity_name");
                    level.m_7260_(pos, blockEntity.m_58900_(), blockEntity.m_58900_(), 3);
                }
            }
        });
    }

    public BlockState m_7417_(BlockState currentBlockState, Direction direction, BlockState neighborBlockState, LevelAccessor world, BlockPos currentPos, BlockPos neighborPos) {
        if (!currentBlockState.m_60710_((LevelReader)world, currentPos)) {
            world.m_186460_(currentPos, (Block)this, 1);
        }
        return super.m_7417_(currentBlockState, direction, neighborBlockState, world, currentPos, neighborPos);
    }

    public boolean m_7898_(BlockState blockState, LevelReader levelReader, BlockPos blockPos) {
        return levelReader.m_8055_(blockPos.m_7495_()).m_60713_(Blocks.f_50136_);
    }

    public PlantType getPlantType(BlockGetter world, BlockPos pos) {
        return PlantType.NETHER;
    }

    public void m_214162_(BlockState blockState, Level level, BlockPos pos, RandomSource random) {
        VoxelShape voxelShape = this.m_5940_(blockState, (BlockGetter)level, pos, CollisionContext.m_82749_());
        Vec3 center = voxelShape.m_83215_().m_82399_();
        double x = (double)pos.m_123341_() + center.f_82479_;
        double z = (double)pos.m_123343_() + center.f_82481_;
        for (int i = 0; i < 3; ++i) {
            if (random.m_188499_() && !((Boolean)blockState.m_61143_((Property)IS_SOUL)).booleanValue()) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123745_, x + random.m_188500_() / 5.0, (double)pos.m_123342_() + (0.5 - random.m_188500_()), z + random.m_188500_() / 5.0, 0.0, 0.0, 0.0);
                continue;
            }
            if (!random.m_188499_() || !((Boolean)blockState.m_61143_((Property)IS_SOUL)).booleanValue()) continue;
            level.m_7106_((ParticleOptions)ModParticles.STOMBLE_ROSE.get(), x + random.m_188500_() / 5.0, (double)pos.m_123342_() + (0.5 - random.m_188500_()), z + random.m_188500_() / 5.0, 0.0, 0.0, 0.0);
        }
    }

    private void saveEntityInfoToBlockEntity(LevelAccessor world, BlockPos pos, Entity entity) {
        BlockEntity blockEntity;
        if (!world.m_5776_() && (blockEntity = world.m_7702_(pos)) != null) {
            blockEntity.getPersistentData().m_128359_("entity_type", ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_()).toString());
            blockEntity.getPersistentData().m_128359_("entity_name", entity.m_5446_().getString());
            if (world instanceof Level) {
                Level level = (Level)world;
                level.m_7260_(pos, blockEntity.m_58900_(), blockEntity.m_58900_(), 3);
            }
        }
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (!level.f_46443_ && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (!((Boolean)state.m_61143_((Property)IS_SOUL)).booleanValue()) {
                this.handleEntityDeath(level, pos, state, livingEntity);
            }
        }
    }

    private void handleEntityDeath(Level level, BlockPos pos, BlockState state, LivingEntity entity) {
        entity.m_6469_(entity.m_269291_().m_269425_(), 2.0f);
        if (entity.m_21224_() && entity.m_6336_() != MobType.f_21641_ && !(entity instanceof IronGolem)) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)IS_SOUL, (Comparable)Boolean.valueOf(true)), 3);
            this.saveEntityInfoToBlockEntity((LevelAccessor)level, pos, (Entity)entity);
        }
    }

    public BlockState getPlant(BlockGetter world, BlockPos pos) {
        return this.m_49966_();
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new RoseMurdererBlockEntity(pPos, pState);
    }
}

