/*
 * Decompiled with CFR 0.152.
 */
package ru.imaginaerum.wd.common.mixin;

import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import ru.imaginaerum.wd.common.items.ItemsWD;

@Mixin(value={AbstractPiglin.class})
public class AbstractPiglinMixin
extends Monster {
    @Unique
    private static final EntityDataAccessor<Boolean> PREVENT_ZOMBIFICATION = SynchedEntityData.m_135353_(AbstractPiglin.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    protected AbstractPiglinMixin(EntityType<? extends Monster> p_33002_, Level p_33003_) {
        super(p_33002_, p_33003_);
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    private void onDefineSynchedData(CallbackInfo info) {
        ((AbstractPiglin)this).m_20088_().m_135372_(PREVENT_ZOMBIFICATION, (Object)false);
    }

    public boolean isPreventZombification() {
        return (Boolean)((AbstractPiglin)this).m_20088_().m_135370_(PREVENT_ZOMBIFICATION);
    }

    public void setPreventZombification(boolean preventZombification) {
        ((AbstractPiglin)this).m_20088_().m_135381_(PREVENT_ZOMBIFICATION, (Object)preventZombification);
    }

    @Inject(method={"isImmuneToZombification()Z"}, at={@At(value="RETURN")}, cancellable=true)
    protected void isImmuneToZombification(CallbackInfoReturnable<Boolean> cir) {
        if (this.isPreventZombification()) {
            cir.setReturnValue((Object)true);
        } else {
            cir.setReturnValue((Object)false);
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (player.m_21205_().m_41720_() == ItemsWD.HEALING_DEW_NETHER.get() && !this.isPreventZombification()) {
            Random random = new Random();
            if ((double)random.nextFloat() < 0.7) {
                this.setPreventZombification(true);
                Level level = this.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123748_, this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), 10, 0.5, 0.5, 0.5, 0.1);
                }
                this.m_5496_(SoundEvents.f_12238_, 1.0f, 1.0f);
                if (!player.m_7500_()) {
                    player.m_21205_().m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
            this.m_5496_(SoundEvents.f_12611_, 1.0f, 1.0f);
            if (!this.m_9236_().f_46443_) {
                ZombifiedPiglin zombifiedPiglin = (ZombifiedPiglin)EntityType.f_20531_.m_20615_(this.m_9236_());
                zombifiedPiglin.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), this.m_146909_());
                if (this.m_6162_()) {
                    zombifiedPiglin.m_6863_(true);
                }
                zombifiedPiglin.m_20331_(this.m_20147_());
                zombifiedPiglin.m_8061_(EquipmentSlot.HEAD, this.m_6844_(EquipmentSlot.HEAD));
                zombifiedPiglin.m_8061_(EquipmentSlot.CHEST, this.m_6844_(EquipmentSlot.CHEST));
                zombifiedPiglin.m_8061_(EquipmentSlot.LEGS, this.m_6844_(EquipmentSlot.LEGS));
                zombifiedPiglin.m_8061_(EquipmentSlot.FEET, this.m_6844_(EquipmentSlot.FEET));
                zombifiedPiglin.m_21008_(InteractionHand.MAIN_HAND, this.m_21120_(InteractionHand.MAIN_HAND));
                zombifiedPiglin.m_21008_(InteractionHand.OFF_HAND, this.m_21120_(InteractionHand.OFF_HAND));
                this.m_146870_();
                this.m_9236_().m_7967_((Entity)zombifiedPiglin);
                Level level = this.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123755_, zombifiedPiglin.m_20185_(), zombifiedPiglin.m_20186_() + 1.0, zombifiedPiglin.m_20189_(), 10, 0.5, 0.5, 0.5, 0.1);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean m_20223_(CompoundTag tag) {
        tag.m_128379_("PreventZombification", this.isPreventZombification());
        return super.m_20223_(tag);
    }

    public void m_20258_(CompoundTag tag) {
        super.m_20258_(tag);
        if (tag.m_128441_("PreventZombification")) {
            this.setPreventZombification(tag.m_128471_("PreventZombification"));
        }
    }
}

