/*
 * Decompiled with CFR 0.152.
 */
package ru.imaginaerum.wd.server.events;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.ServerLifecycleHooks;
import ru.imaginaerum.wd.common.blocks.BlocksWD;
import ru.imaginaerum.wd.common.blocks.custom.GoldenRose;
import ru.imaginaerum.wd.common.blocks.custom.RottenPie;
import ru.imaginaerum.wd.common.items.ItemsWD;
import ru.imaginaerum.wd.common.particles.ModParticles;
import ru.imaginaerum.wd.common.sounds.CustomSoundEvents;

public class HitBlockStarBall {
    public static void hitBlock(ServerLevel level, BlockPos pos, double x, double y, double z) {
        JsonObject config;
        if (level == null || pos == null) {
            return;
        }
        BlockState state = level.m_8055_(pos);
        ResourceLocation blockId = ForgeRegistries.BLOCKS.getKey((Object)state.m_60734_());
        if (blockId == null) {
            return;
        }
        if (state.m_60734_() == BlocksWD.A_BLOCK_OF_SPARKING_POLLEN.get()) {
            level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
            level.m_254849_(null, x, y, z, 10.0f, Level.ExplosionInteraction.TNT);
            Random random = new Random();
            for (int i = 0; i < 10; ++i) {
                double offsetX = random.nextDouble() - 0.5;
                double offsetY = random.nextDouble() * 0.5;
                double offsetZ = random.nextDouble() - 0.5;
                level.m_8767_((ParticleOptions)((SimpleParticleType)ModParticles.ROBIN_STAR_PARTICLES_PROJECTILE.get()), (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 350, 5.0, 5.0, 5.0, (double)0.7f);
            }
            return;
        }
        if (state.m_60734_() == BlocksWD.WIZARD_PIE.get()) {
            level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
            level.m_254849_(null, x, y, z, 4.0f, Level.ExplosionInteraction.TNT);
            Random random = new Random();
            for (int i = 0; i < 10; ++i) {
                double offsetX = random.nextDouble() - 0.5;
                double offsetY = random.nextDouble() * 0.5;
                double offsetZ = random.nextDouble() - 0.5;
                level.m_8767_((ParticleOptions)((SimpleParticleType)ModParticles.ROBIN_STAR_PARTICLES_PROJECTILE.get()), (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 100, 2.0, 2.0, 2.0, (double)0.3f);
            }
            return;
        }
        if (state.m_60734_() == BlocksWD.MEADOW_GOLDEN_FLOWER.get() && ((Boolean)state.m_61143_((Property)GoldenRose.ACTIVE)).booleanValue()) {
            double radius = 5.0;
            List nearbyEntities = level.m_45933_(null, new AABB(x - radius, y - radius, z - radius, x + radius, y + radius, z + radius));
            for (Entity entity : nearbyEntities) {
                if (!(entity instanceof ZombieVillager)) continue;
                ZombieVillager zombieVillager = (ZombieVillager)entity;
                Villager villager = (Villager)EntityType.f_20492_.m_20615_((Level)level);
                if (villager == null) continue;
                villager.m_20359_((Entity)zombieVillager);
                level.m_7967_((Entity)villager);
                zombieVillager.m_146870_();
            }
            level.m_8767_((ParticleOptions)((SimpleParticleType)ModParticles.GOLDEN_FLOWER_PARTICLES.get()), (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 1, 0.0, 0.0, 0.0, (double)0.3f);
            level.m_5594_(null, pos, (SoundEvent)CustomSoundEvents.GOLDEN_FLOWER.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            BlockState newState = (BlockState)state.m_61124_((Property)GoldenRose.ACTIVE, (Comparable)Boolean.valueOf(false));
            level.m_7731_(pos, newState, 3);
            return;
        }
        if (state.m_60734_() == Blocks.f_50191_) {
            level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
            Creeper creeper = (Creeper)EntityType.f_20558_.m_20615_((Level)level);
            creeper.m_7678_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, 0.0f, 0.0f);
            level.m_7967_((Entity)creeper);
            level.m_5594_(null, creeper.m_20183_(), SoundEvents.f_11836_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return;
        }
        if (state.m_60734_() == BlocksWD.ROTTEN_PIE.get()) {
            int stage = (Integer)state.m_61143_((Property)RottenPie.STAGE);
            level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
            int zombieCount = 0;
            switch (stage) {
                case 0: {
                    zombieCount = 8;
                    break;
                }
                case 1: {
                    zombieCount = 6;
                    break;
                }
                case 2: {
                    zombieCount = 4;
                    break;
                }
                case 3: {
                    zombieCount = 2;
                }
            }
            for (int i = 0; i < zombieCount; ++i) {
                double offsetZ;
                double offsetX;
                if (level.f_46441_.m_188500_() < 0.1) {
                    ZombieVillager zombieVillager = (ZombieVillager)EntityType.f_20530_.m_20615_((Level)level);
                    if (zombieVillager == null) continue;
                    offsetX = (level.f_46441_.m_188500_() - 0.5) * 1.5;
                    offsetZ = (level.f_46441_.m_188500_() - 0.5) * 1.5;
                    zombieVillager.m_7678_((double)pos.m_123341_() + 0.5 + offsetX, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5 + offsetZ, level.f_46441_.m_188501_() * 360.0f, 0.0f);
                    level.m_7967_((Entity)zombieVillager);
                    continue;
                }
                Zombie zombie = (Zombie)EntityType.f_20501_.m_20615_((Level)level);
                if (zombie == null) continue;
                offsetX = (level.f_46441_.m_188500_() - 0.5) * 1.5;
                offsetZ = (level.f_46441_.m_188500_() - 0.5) * 1.5;
                zombie.m_7678_((double)pos.m_123341_() + 0.5 + offsetX, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5 + offsetZ, level.f_46441_.m_188501_() * 360.0f, 0.0f);
                level.m_7967_((Entity)zombie);
            }
            level.m_5594_(null, pos, SoundEvents.f_12603_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        if ((config = HitBlockStarBall.loadConfig()) == null || !config.has(blockId.toString())) {
            return;
        }
        JsonObject blockConfig = config.getAsJsonObject(blockId.toString());
        HitBlockStarBall.playBlockBreakAnimation(level, pos, state);
        HitBlockStarBall.spawnParticles(level, pos);
        HitBlockStarBall.dropItems(level, pos, blockConfig);
        level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
    }

    private static void playBlockBreakAnimation(ServerLevel level, BlockPos pos, BlockState state) {
        VoxelShape shape = state.m_60808_((BlockGetter)level, pos);
        Vec3 center = shape.m_83215_().m_82399_();
        level.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
    }

    private static void spawnParticles(ServerLevel level, BlockPos pos) {
        Random random = new Random();
        for (int i = 0; i < 10; ++i) {
            double offsetX = random.nextDouble() - 0.5;
            double offsetY = random.nextDouble() * 0.5;
            double offsetZ = random.nextDouble() - 0.5;
            level.m_8767_((ParticleOptions)((SimpleParticleType)ModParticles.ROBIN_STAR_PARTICLES_PROJECTILE.get()), (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 36, 0.5, 0.5, 0.5, (double)0.05f);
        }
    }

    private static void dropItems(ServerLevel level, BlockPos pos, JsonObject blockConfig) {
        if (!blockConfig.has("drops")) {
            return;
        }
        Random random = new Random();
        if (random.nextFloat() <= 0.3f) {
            ItemStack sparklingPollenStack = new ItemStack((ItemLike)ItemsWD.SPARKLING_POLLEN.get(), 1);
            Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)sparklingPollenStack);
        }
        if (blockConfig.has("experience")) {
            int experienceAmount = blockConfig.get("experience").getAsInt();
            level.m_7967_((Entity)new ExperienceOrb((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), experienceAmount));
        }
        for (JsonElement drop : blockConfig.getAsJsonArray("drops")) {
            float chance;
            JsonObject itemConfig = drop.getAsJsonObject();
            String itemId = itemConfig.get("item").getAsString();
            int minCount = itemConfig.has("min_count") ? itemConfig.get("min_count").getAsInt() : 1;
            int maxCount = itemConfig.has("max_count") ? itemConfig.get("max_count").getAsInt() : minCount;
            Random random2 = new Random();
            int count = random2.nextInt(maxCount - minCount + 1) + minCount;
            float f = chance = itemConfig.has("chance") ? itemConfig.get("chance").getAsFloat() : 1.0f;
            if (!(random2.nextFloat() <= chance)) continue;
            ItemStack itemStack = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemId)), count);
            Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)itemStack);
        }
    }

    private static JsonObject loadConfig() {
        JsonObject mergedConfig = new JsonObject();
        try {
            ResourceLocation folderPath = new ResourceLocation("wd", "hit_block");
            ResourceManager resourceManager = ServerLifecycleHooks.getCurrentServer().m_177941_();
            Map resources = resourceManager.m_214159_(folderPath.m_135815_(), path -> path.m_135815_().endsWith(".json"));
            for (Map.Entry entry : resources.entrySet()) {
                InputStream inputStream = ((Resource)entry.getValue()).m_215507_();
                try {
                    InputStreamReader reader = new InputStreamReader(inputStream);
                    JsonObject fileConfig = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                    fileConfig.entrySet().forEach(entryFile -> mergedConfig.add((String)entryFile.getKey(), (JsonElement)entryFile.getValue()));
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mergedConfig;
    }
}

