/*
 * Decompiled with CFR 0.152.
 */
package ru.imaginaerum.wd.server.events;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.ServerLifecycleHooks;
import ru.imaginaerum.wd.common.items.ItemsWD;
import ru.imaginaerum.wd.common.particles.ModParticles;

public class HitEntityHandler {
    private static final Map<String, JsonObject> MOB_DROPS = new HashMap<String, JsonObject>();

    public static void handleHitEntity(EntityHitResult hitResult, ServerLevel level) {
        Entity entity = hitResult.m_82443_();
        ResourceLocation entityId = EntityType.m_20613_((EntityType)entity.m_6095_());
        if (MOB_DROPS.isEmpty()) {
            HitEntityHandler.loadMobDropsConfig();
        }
        JsonObject mobConfig = MOB_DROPS.get(entityId.toString());
        if (entity instanceof Player) {
            Player player = (Player)entity;
            FoodData foodData = player.m_36324_();
            if (foodData.m_38702_() >= 20) {
                player.m_6469_(player.m_269291_().m_269425_(), 4.0f);
                level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12323_, SoundSource.PLAYERS, 1.0f, 1.0f);
            } else {
                foodData.m_38705_(Math.min(foodData.m_38702_() + 5, 20));
            }
            HitEntityHandler.spawnEffects(level, entity);
            return;
        }
        if (mobConfig != null) {
            Item sparklingPollen;
            HitEntityHandler.spawnEffects(level, entity);
            RandomSource random = level.f_46441_;
            double x = entity.m_20185_();
            double y = entity.m_20186_();
            double z = entity.m_20189_();
            if (random.m_188501_() <= 0.3f && (sparklingPollen = (Item)ItemsWD.SPARKLING_POLLEN.get()) != null) {
                int count = 1 + random.m_188503_(2);
                ItemStack stack = new ItemStack((ItemLike)sparklingPollen, count);
                ItemEntity itemEntity = new ItemEntity((Level)level, x, y, z, stack);
                level.m_7967_((Entity)itemEntity);
            }
            if (mobConfig.has("drops")) {
                HitEntityHandler.processItemDrops(level, entity, mobConfig.getAsJsonObject("drops"));
            }
            if (mobConfig.has("experience")) {
                HitEntityHandler.processExperienceDrops(level, entity, mobConfig.getAsJsonObject("experience"));
            }
            entity.m_146870_();
        } else {
            HitEntityHandler.transformMob(level, entity);
        }
    }

    private static void transformMob(ServerLevel level, Entity entity) {
        Chicken chicken;
        if (entity.m_6095_() == EntityType.f_20492_ || entity.m_6095_() == EntityType.f_20513_ || entity.m_6095_() == EntityType.f_20493_ || entity.m_6095_() == EntityType.f_20568_ || entity.m_6095_() == EntityType.f_20459_ || entity.m_6095_() == EntityType.f_20494_) {
            Frog frog = (Frog)EntityType.f_217012_.m_20615_((Level)level);
            if (frog != null) {
                frog.m_20359_(entity);
                level.m_7967_((Entity)frog);
                entity.m_146870_();
            }
        } else if (!(entity instanceof Player) && (chicken = (Chicken)EntityType.f_20555_.m_20615_((Level)level)) != null) {
            chicken.m_20359_(entity);
            level.m_7967_((Entity)chicken);
            entity.m_146870_();
        }
        HitEntityHandler.spawnEffects(level, entity);
    }

    private static void spawnEffects(ServerLevel level, Entity entity) {
        double x = entity.m_20185_();
        double y = entity.m_20186_();
        double z = entity.m_20189_();
        level.m_8767_((ParticleOptions)((SimpleParticleType)ModParticles.ROBIN_STAR_PARTICLES_PROJECTILE.get()), x, y, z, 36, 0.5, 0.5, 0.5, (double)0.05f);
        if (entity instanceof Bee) {
            level.m_6263_(null, x, y, z, SoundEvents.f_12098_, SoundSource.NEUTRAL, 1.0f, 1.0f);
        } else {
            level.m_6263_(null, x, y, z, SoundEvents.f_12019_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    private static void processItemDrops(ServerLevel level, Entity entity, JsonObject dropsConfig) {
        RandomSource random = level.f_46441_;
        double x = entity.m_20185_();
        double y = entity.m_20186_();
        double z = entity.m_20189_();
        for (Map.Entry entry : dropsConfig.entrySet()) {
            float chance;
            JsonObject itemConfig = ((JsonElement)entry.getValue()).getAsJsonObject();
            String itemId = itemConfig.get("item").getAsString();
            int minCount = itemConfig.has("min_count") ? itemConfig.get("min_count").getAsInt() : 1;
            int maxCount = itemConfig.has("max_count") ? itemConfig.get("max_count").getAsInt() : minCount;
            float f = chance = itemConfig.has("chance") ? itemConfig.get("chance").getAsFloat() : 1.0f;
            if (!(random.m_188501_() <= chance)) continue;
            int count = minCount + random.m_188503_(maxCount - minCount + 1);
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemId));
            if (item == null) continue;
            ItemStack stack = new ItemStack((ItemLike)item, count);
            ItemEntity itemEntity = new ItemEntity((Level)level, x, y, z, stack);
            level.m_7967_((Entity)itemEntity);
        }
    }

    private static void processExperienceDrops(ServerLevel level, Entity entity, JsonObject xpConfig) {
        float chance;
        RandomSource random = level.f_46441_;
        double x = entity.m_20185_();
        double y = entity.m_20186_();
        double z = entity.m_20189_();
        int minXp = xpConfig.has("min") ? xpConfig.get("min").getAsInt() : 0;
        int maxXp = xpConfig.has("max") ? xpConfig.get("max").getAsInt() : minXp;
        float f = chance = xpConfig.has("chance") ? xpConfig.get("chance").getAsFloat() : 1.0f;
        if (random.m_188501_() <= chance && maxXp > 0) {
            int xpAmount = minXp + random.m_188503_(maxXp - minXp + 1);
            level.m_7967_((Entity)new ExperienceOrb((Level)level, x, y, z, xpAmount));
        }
    }

    private static void loadMobDropsConfig() {
        try {
            ResourceLocation folderPath = new ResourceLocation("wd", "hit_mob");
            ResourceManager resourceManager = ServerLifecycleHooks.getCurrentServer().m_177941_();
            Map resources = resourceManager.m_214159_(folderPath.m_135815_(), path -> path.m_135815_().endsWith(".json"));
            for (Map.Entry entry : resources.entrySet()) {
                InputStream inputStream = ((Resource)entry.getValue()).m_215507_();
                try {
                    JsonObject config = JsonParser.parseReader((Reader)new InputStreamReader(inputStream)).getAsJsonObject();
                    for (Map.Entry mobEntry : config.entrySet()) {
                        MOB_DROPS.put((String)mobEntry.getKey(), (JsonObject)mobEntry.getValue());
                    }
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

