/*
 * Decompiled with CFR 0.152.
 */
package ru.imaginaerum.wd.server.events;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.ServerLifecycleHooks;
import ru.imaginaerum.wd.common.blocks.BlocksWD;
import ru.imaginaerum.wd.common.items.ItemsWD;

@Mod.EventBusSubscriber
public class OpenPillagersChest {
    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        BlockPos pos;
        ServerPlayer player;
        Level level;
        BlockState state;
        Block clickedBlock;
        Player player2 = event.getEntity();
        if (player2 instanceof ServerPlayer && (clickedBlock = (state = (level = (player = (ServerPlayer)player2).m_9236_()).m_8055_(pos = event.getPos())).m_60734_()) == BlocksWD.THE_PILLAGERS_CHEST.get()) {
            boolean hasKeyInOff;
            ItemStack mainHand = player.m_21205_();
            ItemStack offHand = player.m_21206_();
            boolean hasKeyInMain = mainHand.m_41720_() == ItemsWD.THE_PILLAGERS_KEY.get();
            boolean bl = hasKeyInOff = offHand.m_41720_() == ItemsWD.THE_PILLAGERS_KEY.get();
            if (hasKeyInMain || hasKeyInOff) {
                if (hasKeyInMain) {
                    mainHand.m_41774_(1);
                } else {
                    offHand.m_41774_(1);
                }
                level.m_46961_(pos, false);
                event.setCanceled(true);
                JsonObject config = OpenPillagersChest.loadConfig();
                JsonElement itemsConfig = config.get("items");
                Random rand = new Random();
                if (itemsConfig != null && itemsConfig.isJsonArray()) {
                    for (JsonElement itemElement : itemsConfig.getAsJsonArray()) {
                        JsonObject itemData = itemElement.getAsJsonObject();
                        if (itemData.has("min") && itemData.has("max") && itemData.has("chance")) {
                            int minAmount = itemData.get("min").getAsInt();
                            int maxAmount = itemData.get("max").getAsInt();
                            int chance = itemData.get("chance").getAsInt();
                            if (rand.nextInt(100) >= chance) continue;
                            int amount = rand.nextInt(maxAmount - minAmount + 1) + minAmount;
                            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemData.get("item").getAsString()));
                            if (item == null) continue;
                            ItemStack itemStack = new ItemStack((ItemLike)item, amount);
                            OpenPillagersChest.dropItem(level, pos.m_7494_(), itemStack);
                            continue;
                        }
                        System.err.println("\u041e\u0448\u0438\u0431\u043a\u0430 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438: " + itemData);
                    }
                }
            }
        }
    }

    private static void dropItem(Level level, BlockPos position, ItemStack itemStack) {
        if (!level.f_46443_ && level != null && position != null) {
            ItemEntity itemEntity = new ItemEntity(level, (double)position.m_123341_(), (double)position.m_123342_(), (double)position.m_123343_(), itemStack);
            level.m_7967_((Entity)itemEntity);
        }
    }

    private static JsonObject loadConfig() {
        JsonObject mergedConfig = new JsonObject();
        try {
            ResourceLocation folderPath = new ResourceLocation("wd", "loot_tables/pillager_chest");
            ResourceManager resourceManager = ServerLifecycleHooks.getCurrentServer().m_177941_();
            Map resources = resourceManager.m_214159_(folderPath.m_135815_(), path -> path.m_135815_().endsWith(".json"));
            for (Map.Entry entry : resources.entrySet()) {
                InputStream inputStream = ((Resource)entry.getValue()).m_215507_();
                try {
                    InputStreamReader reader = new InputStreamReader(inputStream);
                    JsonObject fileConfig = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                    fileConfig.entrySet().forEach(entryFile -> mergedConfig.add((String)entryFile.getKey(), (JsonElement)entryFile.getValue()));
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mergedConfig;
    }
}

