/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.thermal_shock.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.thermal_shock.ThermalShockMod;
import net.mcreator.thermal_shock.procedures.CorDivHelmetOpenProcedure;
import net.mcreator.thermal_shock.procedures.DevScarfOpenProcedure;
import net.mcreator.thermal_shock.procedures.Fabguide1to2Procedure;
import net.mcreator.thermal_shock.procedures.Fabguide2to1Procedure;
import net.mcreator.thermal_shock.procedures.GlastrekkerArmorOpenProcedure;
import net.mcreator.thermal_shock.procedures.PropulsionBootsOpenProcedure;
import net.mcreator.thermal_shock.procedures.SentryChestOpenProcedure;
import net.mcreator.thermal_shock.procedures.SentryHoodOpenProcedure;
import net.mcreator.thermal_shock.world.inventory.FabricGuidePageThreeMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class FabricGuidePageThreeButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public FabricGuidePageThreeButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public FabricGuidePageThreeButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(FabricGuidePageThreeButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(FabricGuidePageThreeButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            FabricGuidePageThreeButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = FabricGuidePageThreeMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            Fabguide1to2Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 1) {
            Fabguide2to1Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 2) {
            SentryHoodOpenProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 3) {
            SentryChestOpenProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 4) {
            DevScarfOpenProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 5) {
            CorDivHelmetOpenProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 6) {
            PropulsionBootsOpenProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 7) {
            GlastrekkerArmorOpenProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        ThermalShockMod.addNetworkMessage(FabricGuidePageThreeButtonMessage.class, FabricGuidePageThreeButtonMessage::buffer, FabricGuidePageThreeButtonMessage::new, FabricGuidePageThreeButtonMessage::handler);
    }
}

