/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.block;

import com.lothrazar.storagenetwork.api.EnumConnectType;
import com.lothrazar.storagenetwork.block.cable.BlockCable;
import com.lothrazar.storagenetwork.block.cable.TileCable;
import com.lothrazar.storagenetwork.block.main.TileMain;
import com.lothrazar.storagenetwork.util.UtilConnections;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class TileCableWithFacing
extends TileCable {
    private Direction direction = null;

    public TileCableWithFacing(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public BlockPos getFacingPosition() {
        return this.m_58899_().m_121945_(this.direction);
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    public void findNewDirection() {
        for (Direction facing : Direction.values()) {
            BlockPos relative = this.f_58858_.m_121945_(facing);
            if (!UtilConnections.isInventory(facing, (LevelAccessor)this.f_58857_, relative)) continue;
            this.setDirection(facing);
            return;
        }
        this.setDirection(null);
    }

    public void refreshInventoryDirection() {
        if (this.direction == null) {
            this.findNewDirection();
            if (this.direction != null) {
                BlockState newState = BlockCable.cleanBlockState(this.m_58900_());
                newState = (BlockState)newState.m_61124_((Property)BlockCable.FACING_TO_PROPERTY_MAP.get(this.direction), (Comparable)((Object)EnumConnectType.INVENTORY));
                this.f_58857_.m_46597_(this.f_58858_, newState);
            }
        }
    }

    public TileMain getTileMain() {
        if (this.getMain() == null) {
            return null;
        }
        return this.getMain().getTileEntity(TileMain.class);
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.direction = compound.m_128441_("direction") ? Direction.values()[compound.m_128451_("direction")] : null;
    }

    @Override
    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        if (this.direction != null) {
            compound.m_128405_("direction", this.direction.ordinal());
        }
    }
}

