/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.emi;

import com.lothrazar.storagenetwork.api.IGuiNetwork;
import com.lothrazar.storagenetwork.gui.ContainerNetwork;
import com.lothrazar.storagenetwork.gui.NetworkWidget;
import com.lothrazar.storagenetwork.network.RecipeMessage;
import com.lothrazar.storagenetwork.registry.ConfigRegistry;
import com.lothrazar.storagenetwork.registry.PacketRegistry;
import dev.emi.emi.api.recipe.EmiPlayerInventory;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.recipe.handler.EmiCraftContext;
import dev.emi.emi.api.recipe.handler.StandardRecipeHandler;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class EmiTransferHandler<T extends ContainerNetwork>
implements StandardRecipeHandler<T> {
    public List<Slot> getInputSources(T handler) {
        return null;
    }

    public List<Slot> getCraftingSlots(T handler) {
        return null;
    }

    @Nullable
    public Slot getOutputSlot(T handler) {
        return ((ContainerNetwork)((Object)handler)).getResultSlot();
    }

    public EmiPlayerInventory getInventory(AbstractContainerScreen<T> screen) {
        NetworkWidget main;
        ArrayList<EmiStack> stacks = new ArrayList<EmiStack>();
        if (screen instanceof IGuiNetwork && (main = ((IGuiNetwork)screen).getNetworkWidget()) != null) {
            List<ItemStack> networkStacks = main.getStacks();
            networkStacks.stream().map(EmiStack::of).forEach(stacks::add);
        }
        for (Slot each : ((ContainerNetwork)screen.m_6262_()).getPlayerSlots()) {
            EmiStack emiStack = EmiStack.of((ItemStack)each.m_7993_());
            stacks.add(emiStack);
        }
        return new EmiPlayerInventory(stacks);
    }

    public boolean supportsRecipe(EmiRecipe recipe) {
        return recipe.getCategory() == VanillaEmiRecipeCategories.CRAFTING && recipe.supportsRecipeTree();
    }

    public boolean craft(EmiRecipe recipe, EmiCraftContext<T> context) {
        AbstractContainerScreen screen = context.getScreen();
        CompoundTag nbt = this.buildRecipe(recipe, screen);
        PacketRegistry.INSTANCE.sendToServer((Object)new RecipeMessage(nbt));
        Minecraft.m_91087_().m_91152_((Screen)screen);
        return true;
    }

    private CompoundTag buildRecipe(EmiRecipe recipe, AbstractContainerScreen<T> screen) {
        CompoundTag nbt = new CompoundTag();
        List ingredients = recipe.getInputs();
        for (Slot slot : ((ContainerNetwork)screen.m_6262_()).f_38839_) {
            EmiIngredient slotIngredient;
            if (!(slot.f_40218_ instanceof CraftingContainer) || slot.getSlotIndex() > ingredients.size() - 1 || (slotIngredient = (EmiIngredient)ingredients.get(slot.getSlotIndex())) == null) continue;
            ArrayList<ItemStack> possibleItems = new ArrayList<ItemStack>();
            for (EmiStack each : slotIngredient.getEmiStacks()) {
                ItemStack stack = each.getItemStack();
                possibleItems.add(stack);
            }
            if (possibleItems.isEmpty()) continue;
            ListTag invList = new ListTag();
            for (int i = 0; i < possibleItems.size() && i < (Integer)ConfigRegistry.RECIPEMAXTAGS.get(); ++i) {
                ItemStack itemStack = (ItemStack)possibleItems.get(i);
                if (itemStack.m_41619_()) continue;
                CompoundTag stackTag = new CompoundTag();
                itemStack.m_41739_(stackTag);
                invList.add((Object)stackTag);
            }
            nbt.m_128365_("s" + slot.getSlotIndex(), (Tag)invList);
        }
        return nbt;
    }
}

