/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.registry;

import com.lothrazar.storagenetwork.StorageNetworkMod;
import com.lothrazar.storagenetwork.block.cable.TileCable;
import com.lothrazar.storagenetwork.item.ItemBuilder;
import com.lothrazar.storagenetwork.item.ItemCollector;
import com.lothrazar.storagenetwork.network.CableFacadeMessage;
import com.lothrazar.storagenetwork.network.KeybindCurioMessage;
import com.lothrazar.storagenetwork.registry.ClientEventRegistry;
import com.lothrazar.storagenetwork.registry.ConfigRegistry;
import com.lothrazar.storagenetwork.registry.PacketRegistry;
import com.lothrazar.storagenetwork.registry.SsnRegistry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class SsnEvents {
    @SubscribeEvent
    public void onEntityItemPickupEvent(EntityItemPickupEvent event) {
        ((ItemCollector)((Object)SsnRegistry.Items.COLLECTOR_REMOTE.get())).onEntityItemPickupEvent(event);
    }

    @SubscribeEvent
    public void onHit(PlayerInteractEvent.LeftClickBlock event) {
        ItemBuilder.onLeftClickBlock(event);
        if (((Boolean)ConfigRegistry.enableFacades.get()).booleanValue()) {
            this.onHitFacadeHandler(event);
        }
    }

    private void onHitFacadeHandler(PlayerInteractEvent.LeftClickBlock event) {
        Level level = event.getLevel();
        if (!level.f_46443_) {
            return;
        }
        Player player = event.getEntity();
        ItemStack held = player.m_21120_(event.getHand());
        TileCable cable = TileCable.getTileCable((BlockGetter)level, event.getPos());
        if (cable != null) {
            if (held.m_41619_()) {
                PacketRegistry.INSTANCE.sendToServer((Object)new CableFacadeMessage(event.getPos(), true));
            } else {
                Block block = Block.m_49814_((Item)held.m_41720_());
                if (block == null || block == Blocks.f_50016_) {
                    return;
                }
                if (!ConfigRegistry.isFacadeAllowed(held)) {
                    StorageNetworkMod.log("not allowed as a facade from config file: " + held.m_41720_());
                    return;
                }
                boolean pickFluids = false;
                BlockHitResult bhr = (BlockHitResult)player.m_19907_(player.getBlockReach(), 1.0f, pickFluids);
                BlockPlaceContext context = new BlockPlaceContext(player, event.getHand(), held, bhr);
                BlockState facadeState = block.m_5573_(context);
                CompoundTag tags = facadeState == null ? null : NbtUtils.m_129202_((BlockState)facadeState);
                PacketRegistry.INSTANCE.sendToServer((Object)new CableFacadeMessage(event.getPos(), tags));
            }
        }
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.Key event) {
        if (ClientEventRegistry.INVENTORY_KEY.m_90859_()) {
            PacketRegistry.INSTANCE.sendToServer((Object)new KeybindCurioMessage());
        }
    }
}

