/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.storagenetwork.block.cable;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import mrriegel.storagenetwork.block.cable.ContainerCable;
import mrriegel.storagenetwork.block.cable.GuiCableButton;
import mrriegel.storagenetwork.gui.ItemSlotNetwork;
import mrriegel.storagenetwork.jei.JeiHooks;
import mrriegel.storagenetwork.network.CableDataMessage;
import mrriegel.storagenetwork.network.CableFilterMessage;
import mrriegel.storagenetwork.registry.PacketRegistry;
import mrriegel.storagenetwork.util.inventory.FilterItemStackHandler;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.config.GuiCheckBox;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.ItemHandlerHelper;
import org.lwjgl.input.Mouse;

public abstract class GuiCableBase
extends GuiContainer {
    public static final int SLOT_SIZE = 18;
    public static final int TEXTBOX_WIDTH = 36;
    protected List<ItemSlotNetwork> itemSlotsGhost;
    protected ItemStack stackUnderMouse = ItemStack.field_190927_a;
    protected ResourceLocation texture = new ResourceLocation("storagenetwork", "textures/gui/cable.png");
    protected GuiCableButton btnImport;
    public GuiCheckBox checkNbtBtn;
    public GuiCheckBox checkOreBtn;
    public GuiCheckBox checkMetaBtn;
    protected ContainerCable containerCable;

    public GuiCableBase(ContainerCable containerCable) {
        super((Container)containerCable);
        this.field_146999_f = 176;
        this.field_147000_g = 171;
        this.itemSlotsGhost = Lists.newArrayList();
        this.containerCable = containerCable;
    }

    public void importSlotsButtonPressed() {
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        FilterItemStackHandler stackHandler = this.getFilterHandler();
        if (stackHandler == null) {
            return;
        }
        if (this.btnImport != null && button.field_146127_k == this.btnImport.field_146127_k) {
            this.importSlotsButtonPressed();
            PacketRegistry.INSTANCE.sendToServer((IMessage)new CableDataMessage(button.field_146127_k));
        }
        if (button.field_146127_k == this.checkMetaBtn.field_146127_k || button.field_146127_k == this.checkOreBtn.field_146127_k || button.field_146127_k == this.checkNbtBtn.field_146127_k) {
            stackHandler.nbt = this.checkNbtBtn.isChecked();
            stackHandler.ores = this.checkOreBtn.isChecked();
            stackHandler.meta = this.checkMetaBtn.isChecked();
            PacketRegistry.INSTANCE.sendToServer((IMessage)new CableFilterMessage(-1, null, this.checkOreBtn.isChecked(), this.checkMetaBtn.isChecked(), this.checkNbtBtn.isChecked()));
        }
    }

    public void func_146278_c(int tint) {
        super.func_146278_c(tint);
    }

    public FontRenderer getFont() {
        return this.field_146289_q;
    }

    public FilterItemStackHandler getFilterHandler() {
        return null;
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        ItemStack stackCarriedByMouse = this.field_146297_k.field_71439_g.field_71071_by.func_70445_o().func_77946_l();
        FilterItemStackHandler stackHandler = this.getFilterHandler();
        if (stackHandler == null) {
            return;
        }
        boolean isRightClick = mouseButton == 1;
        boolean isLeftClick = mouseButton == 0;
        for (int slot = 0; slot < this.itemSlotsGhost.size(); ++slot) {
            ItemSlotNetwork itemSlot = this.itemSlotsGhost.get(slot);
            if (!itemSlot.isMouseOverSlot(mouseX, mouseY)) continue;
            boolean doesExistAlready = stackHandler.exactStackAlreadyInList(stackCarriedByMouse);
            if (!stackCarriedByMouse.func_190926_b() && !doesExistAlready) {
                int quantity = isRightClick ? 1 : stackCarriedByMouse.func_190916_E();
                stackHandler.setStackInSlot(slot, ItemHandlerHelper.copyStackWithSize((ItemStack)stackCarriedByMouse, (int)quantity));
            } else {
                ItemStack filterStack = stackHandler.getStackInSlot(slot);
                if (filterStack == null || filterStack.func_190926_b()) break;
                if (isLeftClick) {
                    stackHandler.setStackInSlot(slot, ItemStack.field_190927_a);
                }
            }
            PacketRegistry.INSTANCE.sendToServer((IMessage)new CableFilterMessage(slot, stackHandler.getStackInSlot(slot), stackHandler.ores, stackHandler.meta, stackHandler.nbt));
            break;
        }
    }

    public void func_146274_d() throws IOException {
        int change;
        super.func_146274_d();
        int wheel = Mouse.getDWheel();
        if (wheel == 0) {
            return;
        }
        int n = change = GuiScreen.func_146272_n() ? 8 : 1;
        if (GuiScreen.func_175283_s()) {
            change *= 2;
        }
        boolean wheelUp = wheel > 0;
        int mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        for (int i = 0; i < this.itemSlotsGhost.size(); ++i) {
            ItemSlotNetwork itemSlot = this.itemSlotsGhost.get(i);
            if (!itemSlot.isMouseOverSlot(mouseX, mouseY) || itemSlot.getStack().func_190926_b()) continue;
            if (wheelUp) {
                itemSlot.getStack().func_190917_f(change);
            } else {
                itemSlot.getStack().func_190918_g(change);
            }
            if (itemSlot.getStack().func_190916_E() >= 64) {
                itemSlot.getStack().func_190920_e(64);
            }
            FilterItemStackHandler stackHandler = this.getFilterHandler();
            PacketRegistry.INSTANCE.sendToServer((IMessage)new CableFilterMessage(i, itemSlot.getStack(), stackHandler.ores, stackHandler.meta, stackHandler.nbt));
            return;
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (!this.func_146983_a(keyCode) && !this.stackUnderMouse.func_190926_b()) {
            try {
                JeiHooks.testJeiKeybind(keyCode, this.stackUnderMouse);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        super.func_73869_a(typedChar, keyCode);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        super.func_191948_b(mouseX, mouseY);
        this.drawTooltips(mouseX, mouseY);
        this.updateHovered(mouseX, mouseY);
    }

    protected void drawTooltips(int mouseX, int mouseY) {
        for (ItemSlotNetwork s : this.itemSlotsGhost) {
            if (s == null || s.getStack() == null || s.getStack().func_190926_b() || !s.isMouseOverSlot(mouseX, mouseY)) continue;
            this.func_146285_a(s.getStack(), mouseX, mouseY);
        }
        if (this.btnImport != null && this.btnImport.func_146115_a()) {
            this.func_146283_a(Lists.newArrayList((Object[])new String[]{I18n.func_135052_a((String)"gui.storagenetwork.gui.import", (Object[])new Object[0])}), mouseX, mouseY);
        }
    }

    protected void updateHovered(int mouseX, int mouseY) {
        this.stackUnderMouse = ItemStack.field_190927_a;
        for (ItemSlotNetwork slot : this.itemSlotsGhost) {
            slot.drawSlot(mouseX, mouseY);
            if (!slot.isMouseOverSlot(mouseX, mouseY)) continue;
            this.stackUnderMouse = slot.getStack();
            break;
        }
        if (this.itemSlotsGhost.isEmpty()) {
            this.stackUnderMouse = ItemStack.field_190927_a;
        }
    }

    public void func_146281_b() {
        super.func_146281_b();
    }

    public void setFilterItems(List<ItemStack> stacks) {
        FilterItemStackHandler filter = this.getFilterHandler();
        for (int i = 0; i < stacks.size(); ++i) {
            ItemStack s = stacks.get(i);
            filter.setStackInSlot(i, s);
        }
    }
}

