/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.storagenetwork.block.cable.processing;

import net.minecraft.nbt.NBTTagCompound;

public class ProcessRequestModel {
    private static final String PREFIX = "sn_process_";
    private int count;
    private boolean alwaysActive = true;
    private ProcessStatus status = ProcessStatus.EXPORTING;
    private int stackIndex;

    public int getCount() {
        return this.count;
    }

    public void reduceCount() {
        if (this.count > 0) {
            --this.count;
        }
    }

    public void setCount(int countRequested) {
        if (this.count <= 0 && countRequested > 0) {
            this.setStatus(ProcessStatus.EXPORTING);
        }
        this.count = countRequested;
    }

    public void readFromNBT(NBTTagCompound compound) {
        this.count = compound.func_74762_e("sn_process_count");
        this.status = ProcessStatus.values()[compound.func_74762_e("sn_process_status")];
        this.alwaysActive = compound.func_74767_n("sn_process_always");
        this.stackIndex = compound.func_74762_e("sn_process_stack");
    }

    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        compound.func_74768_a("sn_process_count", this.count);
        compound.func_74768_a("sn_process_status", this.status.ordinal());
        compound.func_74757_a("sn_process_always", this.alwaysActive);
        compound.func_74768_a("sn_process_stack", this.stackIndex);
        return compound;
    }

    public ProcessStatus getStatus() {
        return this.status;
    }

    public void setStatus(ProcessStatus status) {
        if (status == this.status) {
            return;
        }
        this.status = status;
        this.stackIndex = 0;
    }

    public boolean isAlwaysActive() {
        return this.alwaysActive;
    }

    public void setAlwaysActive(boolean alwaysActive) {
        this.alwaysActive = alwaysActive;
    }

    public int getStackIndex() {
        return this.stackIndex;
    }

    public void increaseStackIndex() {
        ++this.stackIndex;
    }

    public static enum ProcessStatus {
        HALTED,
        IMPORTING,
        EXPORTING;

    }
}

