/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.storagenetwork.block.cable.processing;

import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mrriegel.storagenetwork.StorageNetwork;
import mrriegel.storagenetwork.block.cable.TileCableWithFacing;
import mrriegel.storagenetwork.block.cable.processing.ProcessRequestModel;
import mrriegel.storagenetwork.block.master.TileMaster;
import mrriegel.storagenetwork.data.ItemStackMatcher;
import mrriegel.storagenetwork.util.UtilInventory;
import mrriegel.storagenetwork.util.inventory.FilterItemStackHandler;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class TileCableProcess
extends TileCableWithFacing {
    private ProcessRequestModel processModel = new ProcessRequestModel();
    public EnumFacing processingInput = EnumFacing.UP;
    public EnumFacing processingOut = EnumFacing.DOWN;
    public FilterItemStackHandler filters = new FilterItemStackHandler();

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.processingInput = EnumFacing.values()[compound.func_74762_e("processingTop")];
        this.processingOut = EnumFacing.values()[compound.func_74762_e("processingBottom")];
        ProcessRequestModel pm = new ProcessRequestModel();
        pm.readFromNBT(compound);
        this.setProcessModel(pm);
        NBTTagCompound filters = compound.func_74775_l("filters");
        this.filters.deserializeNBT(filters);
        super.func_145839_a(compound);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        this.processModel.writeToNBT(compound);
        compound.func_74768_a("processingBottom", this.processingOut.ordinal());
        compound.func_74768_a("processingTop", this.processingInput.ordinal());
        NBTTagCompound filters = this.filters.serializeNBT();
        compound.func_74782_a("filters", (NBTBase)filters);
        return compound;
    }

    public void run() {
        ProcessRequestModel processRequest = this.getRequest();
        if (processRequest == null) {
            return;
        }
        if (!processRequest.isAlwaysActive() && processRequest.getCount() <= 0) {
            return;
        }
        if (this.getMaster() == null || this.getMaster().getTileEntity(TileMaster.class) == null) {
            return;
        }
        if (!this.hasDirection()) {
            return;
        }
        List<ItemStack> ingredients = this.getProcessIngredients();
        List<ItemStack> outputs = this.getProcessOutputs();
        if (ingredients.size() == 0 || outputs.size() == 0) {
            return;
        }
        TileMaster master = this.getMaster().getTileEntity(TileMaster.class);
        if (processRequest.getStatus() == ProcessRequestModel.ProcessStatus.EXPORTING) {
            boolean exportedAll = true;
            for (ItemStack ingred : ingredients.subList(processRequest.getStackIndex(), ingredients.size())) {
                ItemStackMatcher matcher = new ItemStackMatcher(ingred.func_77946_l(), this.filters.meta, this.filters.ores, this.filters.nbt);
                ItemStack requestedFromNetwork = master.request(matcher, ingred.func_190916_E(), true);
                int found = requestedFromNetwork.func_190916_E();
                IItemHandler inventoryLinked = this.getInventoryLinkedInput();
                ItemStack remain = ItemHandlerHelper.insertItemStacked((IItemHandler)inventoryLinked, (ItemStack)requestedFromNetwork, (boolean)true);
                if (remain.func_190926_b() && found >= ingred.func_190916_E()) {
                    requestedFromNetwork = master.request(matcher, ingred.func_190916_E(), false);
                    remain = ItemHandlerHelper.insertItemStacked((IItemHandler)inventoryLinked, (ItemStack)requestedFromNetwork, (boolean)false);
                    if (!remain.func_190926_b()) {
                        StorageNetwork.log("ingr" + ingred.func_82833_r() + " had " + remain.func_190916_E() + " left after insertion");
                    }
                    processRequest.increaseStackIndex();
                    continue;
                }
                exportedAll = false;
                break;
            }
            if (exportedAll) {
                processRequest.setStatus(ProcessRequestModel.ProcessStatus.IMPORTING);
            }
        } else if (processRequest.getStatus() == ProcessRequestModel.ProcessStatus.IMPORTING) {
            boolean importedAll = true;
            for (ItemStack out : outputs.subList(processRequest.getStackIndex(), outputs.size())) {
                IItemHandler inventoryLinked = this.getInventoryLinkedOutput();
                int targetStillNeeds = UtilInventory.containsAtLeastHowManyNeeded(inventoryLinked, out, out.func_190916_E());
                if (targetStillNeeds > 0) {
                    importedAll = false;
                    break;
                }
                int countNotInserted = master.insertStack(out, true);
                if (countNotInserted > 0) {
                    importedAll = false;
                    break;
                }
                StorageNetwork.log(this.field_174879_c + "IMPORTING: " + out.toString());
                ItemStack extracted = UtilInventory.extractItem(inventoryLinked, new ItemStackMatcher(out), out.func_190916_E(), false);
                master.insertStack(extracted, false);
                processRequest.increaseStackIndex();
            }
            if (importedAll) {
                StorageNetwork.log(this.field_174879_c + "IMPORTING: TO STATUS EXPORTING ");
                processRequest.setStatus(ProcessRequestModel.ProcessStatus.EXPORTING);
                if (!processRequest.isAlwaysActive()) {
                    processRequest.reduceCount();
                }
            }
        }
        this.func_70296_d();
    }

    private IItemHandler getInventoryLinked(EnumFacing inOrOut) {
        if (this.getFacingPosition() == null) {
            return null;
        }
        IItemHandler inventoryLinked = UtilInventory.getItemHandler(this.field_145850_b.func_175625_s(this.getFacingPosition()), inOrOut);
        return inventoryLinked;
    }

    private IItemHandler getInventoryLinkedInput() {
        return this.getInventoryLinked(this.getFacingInput());
    }

    private IItemHandler getInventoryLinkedOutput() {
        return this.getInventoryLinked(this.getFacingOut());
    }

    public List<ItemStack> getProcessIngredients() {
        return this.filters.getInputs().stream().map(stack -> stack.func_77946_l()).collect(Collectors.toList());
    }

    public List<ItemStack> getProcessOutputs() {
        return this.filters.getOutputs().stream().map(stack -> stack.func_77946_l()).collect(Collectors.toList());
    }

    @Nonnull
    public ItemStack getFirstRecipeOut() {
        if (this.filters.isOutputEmpty()) {
            return ItemStack.field_190927_a;
        }
        return this.filters.getOutputs().get(0);
    }

    public EnumFacing getFacingOut() {
        return this.processingOut;
    }

    public EnumFacing getFacingInput() {
        return this.processingInput;
    }

    public ProcessRequestModel getProcessModel() {
        return this.processModel;
    }

    public void setProcessModel(ProcessRequestModel processModel) {
        this.processModel = processModel;
    }

    public ProcessRequestModel getRequest() {
        return this.getProcessModel();
    }

    public void setRequest(ProcessRequestModel request) {
        this.setProcessModel(request);
    }

    public void importFilters() {
        ItemStack test;
        int i;
        IItemHandler input = this.getInventoryLinkedInput();
        IItemHandler output = this.getInventoryLinkedOutput();
        if (input == null || output == null) {
            return;
        }
        this.clearFilters();
        for (i = 0; i < input.getSlots(); ++i) {
            test = input.getStackInSlot(i).func_77946_l();
            if (test.func_190926_b()) continue;
            test.func_190920_e(1);
            this.filters.setStackInSlot(i, test);
        }
        for (i = 0; i < output.getSlots(); ++i) {
            test = output.extractItem(i, 1, true);
            if (test.func_190926_b()) continue;
            test.func_190920_e(1);
            this.filters.setStackInSlot(9 + i, test);
        }
    }

    private void clearFilters() {
        for (int i = 0; i < this.filters.getSlots(); ++i) {
            this.filters.extractItem(i, 64, false);
            this.filters.setStackInSlot(i, ItemStack.field_190927_a);
            StorageNetwork.log("Erase filter " + i);
        }
    }
}

