/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.storagenetwork.block.control;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import mrriegel.storagenetwork.StorageNetwork;
import mrriegel.storagenetwork.block.control.ContainerControl;
import mrriegel.storagenetwork.block.control.GuiControlButton;
import mrriegel.storagenetwork.block.control.GuiSliderInteger;
import mrriegel.storagenetwork.block.control.GuiTextFieldProcCable;
import mrriegel.storagenetwork.block.control.ProcessWrapper;
import mrriegel.storagenetwork.network.CableControlMessage;
import mrriegel.storagenetwork.network.CableDataMessage;
import mrriegel.storagenetwork.network.RequestCableMessage;
import mrriegel.storagenetwork.registry.PacketRegistry;
import mrriegel.storagenetwork.util.UtilInventory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class GuiControl
extends GuiContainer {
    private static final int HEIGHT = 256;
    private static final int WIDTH = 176;
    private static final ResourceLocation texture = new ResourceLocation("storagenetwork", "textures/gui/control.png");
    protected GuiTextField searchBar;
    private List<ProcessWrapper> processors = null;
    Map<Integer, CableRow> allRows = new HashMap<Integer, CableRow>();
    private boolean rowsCreated;
    private int page = 0;
    private int maxPage = 0;
    private GuiSliderInteger slider;
    int hiddenOffset = 0;
    final int rowHeight = 25;
    int FONT = 0xE0E0E0;

    public GuiControl(ContainerControl inventorySlotsIn) {
        super((Container)inventorySlotsIn);
        this.processors = new ArrayList<ProcessWrapper>();
        this.field_146999_f = 176;
        this.field_147000_g = 256;
        this.rowsCreated = false;
        this.refreshData();
    }

    private void refreshData() {
        PacketRegistry.INSTANCE.sendToServer((IMessage)new RequestCableMessage());
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        Keyboard.enableRepeatEvents((boolean)true);
        this.searchBar = new GuiTextField(0, this.field_146289_q, this.field_147003_i + 10, this.field_147009_r + 160, 158, this.field_146289_q.field_78288_b);
        this.searchBar.func_146203_f(30);
        this.searchBar.func_146185_a(false);
        this.searchBar.func_146189_e(true);
        this.searchBar.func_146195_b(true);
        this.searchBar.func_146193_g(0xFFFFFF);
        this.slider = new GuiSliderInteger(this, 777, this.field_147003_i + 169, this.field_147009_r + 16, 6, 130, 0, 0);
        this.func_189646_b((GuiButton)this.slider);
    }

    public void func_146281_b() {
        super.func_146281_b();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    private void createAllRows() {
        if (this.rowsCreated) {
            return;
        }
        int row = 0;
        int btnid = 1;
        HashMap<Integer, CableRow> rows = new HashMap<Integer, CableRow>();
        for (ProcessWrapper p : this.processors) {
            if (p.output.func_190926_b()) continue;
            CableRow rowModel = new CableRow(this, p);
            rowModel.index = row;
            rowModel.x = this.field_147003_i + 8;
            rowModel.y = this.field_147009_r + 10;
            rowModel.width = 150;
            rowModel.height = 20;
            GuiControlButton btnOnOff = new GuiControlButton(btnid++, CableDataMessage.CableMessageType.P_ONOFF, rowModel.x, rowModel.y, 16, 16, "");
            btnOnOff.cable = p;
            btnOnOff.field_146125_m = false;
            rowModel.btnOnOff = btnOnOff;
            this.func_189646_b((GuiButton)rowModel.btnOnOff);
            int offset = 66;
            GuiControlButton btnMinus = new GuiControlButton(btnid++, CableDataMessage.CableMessageType.P_CTRL_LESS, rowModel.x + offset + 74, rowModel.y, 10, 16, "");
            btnMinus.cable = p;
            btnMinus.clearAndSetTooltip(StorageNetwork.lang("processing.buttons.minus"));
            btnMinus.field_146125_m = false;
            this.func_189646_b((GuiButton)btnMinus);
            rowModel.btnMinus = btnMinus;
            GuiControlButton btnPlus = new GuiControlButton(btnid++, CableDataMessage.CableMessageType.P_CTRL_MORE, rowModel.x + offset + 84, rowModel.y, 10, 16, "");
            btnPlus.cable = p;
            btnPlus.field_146125_m = false;
            btnPlus.clearAndSetTooltip(StorageNetwork.lang("processing.buttons.plus"));
            this.func_189646_b((GuiButton)btnPlus);
            rowModel.btnPlus = btnPlus;
            rows.put(row, rowModel);
            ++row;
        }
        this.setMaxPage(rows.size() - 1);
        this.allRows = rows;
        this.rowsCreated = true;
    }

    public void saveMessage(ProcessWrapper cable, CableDataMessage.CableMessageType messageType, int changePerClick) {
        int value = 0;
        if (messageType == CableDataMessage.CableMessageType.P_ONOFF) {
            cable.alwaysOn = !cable.alwaysOn;
            value = cable.alwaysOn ? 1 : 0;
        } else if (messageType == CableDataMessage.CableMessageType.P_CTRL_LESS) {
            cable.count -= changePerClick;
            if (cable.count < 0) {
                cable.count = 0;
            }
            value = cable.count;
        } else if (messageType == CableDataMessage.CableMessageType.P_CTRL_MORE) {
            cable.count += changePerClick;
            value = cable.count;
        }
        PacketRegistry.INSTANCE.sendToServer((IMessage)new CableControlMessage(messageType.ordinal(), value, cable.pos));
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button instanceof GuiControlButton) {
            int change;
            GuiControlButton btn = (GuiControlButton)button;
            int n = change = GuiScreen.func_146272_n() ? 64 : 1;
            if (GuiScreen.func_175283_s()) {
                change *= 16;
            }
            this.saveMessage(btn.cable, btn.messageType, change);
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.tryRefresh(50);
        if (this.processors != null && this.processors.size() > 0) {
            this.createAllRows();
        }
        if (this.searchBar != null) {
            this.searchBar.func_146178_a();
        }
        for (GuiButton btn : this.field_146292_n) {
            if (!(btn instanceof GuiControlButton)) continue;
            GuiControlButton button = (GuiControlButton)btn;
            switch (button.messageType) {
                case P_CTRL_LESS: {
                    button.textureY = 464;
                    if (GuiScreen.func_146272_n()) {
                        button.textureX = 211;
                        break;
                    }
                    button.textureX = 243;
                    break;
                }
                case P_CTRL_MORE: {
                    button.textureX = GuiScreen.func_146272_n() ? 211 : 243;
                    button.textureY = 448;
                    break;
                }
                case P_ONOFF: {
                    button.clearAndSetTooltip(StorageNetwork.lang("processing.buttons.toggle." + button.cable.alwaysOn));
                    if (button.cable.alwaysOn) {
                        button.textureX = 0;
                        button.textureY = 449;
                        break;
                    }
                    button.textureX = 95;
                    button.textureY = 449;
                    break;
                }
            }
        }
    }

    private void tryRefresh(int ticks) {
        if (Minecraft.func_71410_x().field_71439_g.field_70170_p.func_82737_E() % (long)ticks == 0L) {
            this.refreshData();
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        super.func_191948_b(mouseX, mouseY);
        if (this.searchBar != null) {
            this.searchBar.func_146194_f();
        }
        this.hiddenOffset = 0;
        for (CableRow row : this.allRows.values()) {
            if (!row.compareSearch()) {
                row.x = -199;
                ++this.hiddenOffset;
            } else {
                row.x = this.field_147003_i + 8;
            }
            row.updatePagePosition(this.getPage(), this.hiddenOffset);
            if (row.isOffscreen()) {
                row.hideComponents();
            } else {
                row.drawScreen();
            }
            if (row.isInside(mouseX, mouseY)) {
                this.func_146283_a(row.tooltips, mouseX, mouseY);
                continue;
            }
            if (!row.isInsideItemstack(mouseX, mouseY)) continue;
            this.func_146283_a(row.p.output.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (ITooltipFlag)ITooltipFlag.TooltipFlags.ADVANCED), mouseX, mouseY);
        }
        for (GuiButton btn : this.field_146292_n) {
            if (!btn.func_146115_a() || !(btn instanceof GuiControlButton)) continue;
            GuiControlButton button = (GuiControlButton)btn;
            this.func_146283_a(button.getTooltips(), mouseX, mouseY);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        for (CableRow row : this.allRows.values()) {
            if (row.isOffscreen()) continue;
            GlStateManager.func_179094_E();
            RenderHelper.func_74520_c();
            int x = row.x - this.field_147003_i;
            int y = row.y - this.field_147009_r;
            this.field_146297_k.func_175599_af().func_180450_b(row.p.output, x + 20, y);
            this.func_73731_b(this.field_146289_q, row.p.name, x + 40, y + 3, this.FONT);
            if (!row.p.alwaysOn) {
                this.func_73731_b(this.field_146289_q, row.p.count + "", x + 112, y + 3, 14735632);
            }
            GlStateManager.func_179121_F();
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.renderTextures();
    }

    private void renderTextures() {
        this.func_146276_q_();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(texture);
        int xCenter = (this.field_146294_l - this.field_146999_f) / 2;
        int yCenter = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(xCenter, yCenter, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int mouseX = Mouse.getX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int mouseY = this.field_146295_m - Mouse.getY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        if (this.inField(mouseX, mouseY)) {
            int mouse = Mouse.getEventDWheel();
            if (mouse > 0 && this.getPage() > 0) {
                this.setPage(this.getPage() - 1);
            }
            if (mouse < 0 && this.getPage() < this.getMaxPage() - this.hiddenOffset) {
                this.setPage(this.getPage() + 1);
            }
        }
    }

    protected boolean inField(int mouseX, int mouseY) {
        return mouseX > this.field_147003_i && mouseX < this.field_147003_i + this.field_146999_f && mouseY > this.field_147009_r && mouseY < this.field_147009_r + this.field_147000_g;
    }

    protected boolean inSearchbar(int mouseX, int mouseY) {
        return this.func_146978_c(10, 160, this.searchBar.field_146218_h, this.searchBar.field_146219_i, mouseX, mouseY);
    }

    protected void func_73864_a(int mouseX, int mouseY, int btn) throws IOException {
        super.func_73864_a(mouseX, mouseY, btn);
        if (this.searchBar != null) {
            this.searchBar.func_146192_a(mouseX, mouseY, btn);
            if (this.inSearchbar(mouseX, mouseY)) {
                this.searchBar.func_146195_b(true);
                if (btn == 1) {
                    this.searchBar.func_146180_a("");
                }
            }
        }
        for (CableRow row : this.allRows.values()) {
            if (!row.isInside(mouseX, mouseY)) continue;
            row.mouseClicked(mouseX, mouseY, btn);
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.searchBar != null && this.searchBar.func_146206_l() && this.searchBar.func_146201_a(typedChar, keyCode)) {
            return;
        }
        super.func_73869_a(typedChar, keyCode);
    }

    public void setTiles(List<ProcessWrapper> cables) {
        cables = cables.stream().sorted((a, b) -> a.name.compareTo(b.name)).collect(Collectors.toList());
        if (this.processors == null || this.processors.size() == 0) {
            this.processors = cables;
        } else {
            for (ProcessWrapper p : this.processors) {
                for (ProcessWrapper pIncoming : cables) {
                    if (!p.pos.equals(pIncoming.pos)) continue;
                    p.count = pIncoming.count;
                }
            }
        }
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
        this.slider.setSliderValue(page, false);
    }

    public int getMaxPage() {
        return this.maxPage;
    }

    public void setMaxPage(int m) {
        this.maxPage = m;
        this.slider.setSliderValue(0.0f, false);
        this.slider.setMax(m);
    }

    public class CableRow {
        public List<String> tooltips;
        private GuiControl gui;
        ProcessWrapper p;
        GuiControlButton btnOnOff;
        GuiControlButton btnMinus;
        GuiControlButton btnPlus;
        public GuiTextFieldProcCable txtBox;
        public int x;
        public int y;
        public int width;
        public int height;
        public int index;

        public CableRow(GuiControl gui, ProcessWrapper p) {
            this.gui = gui;
            this.p = p;
            this.tooltips = new ArrayList<String>();
            if (p.ingredients == null || p.ingredients.size() == 0) {
                this.tooltips.add(StorageNetwork.lang("processing.empty.ingredients"));
            } else {
                for (ItemStack s : p.ingredients) {
                    this.tooltips.add(s.func_190916_E() + " : " + s.func_82833_r());
                }
            }
            this.tooltips.add(TextFormatting.DARK_GRAY + p.blockId + "");
            this.tooltips.add(TextFormatting.DARK_GRAY + "(" + p.pos.getBlockPos().func_177958_n() + ", " + p.pos.getBlockPos().func_177956_o() + ", " + p.pos.getBlockPos().func_177952_p() + ")");
        }

        public boolean isInsideItemstack(int mouseX, int mouseY) {
            int loffset = 18;
            int roffset = 50;
            return loffset + this.x < mouseX && mouseX < this.x + this.width - roffset && this.y < mouseY && mouseY < this.y + this.height;
        }

        public boolean isInside(int mouseX, int mouseY) {
            int loffset = 36;
            int roffset = 36;
            return loffset + this.x < mouseX && mouseX < this.x + this.width - roffset && this.y < mouseY && mouseY < this.y + this.height;
        }

        public void mouseClicked(int mouseX, int mouseY, int btn) {
        }

        public boolean compareSearch() {
            if (this.gui.searchBar.func_146179_b().isEmpty()) {
                return true;
            }
            return UtilInventory.doOverlap(this.gui.searchBar.func_146179_b(), this.p.name) || UtilInventory.doOverlap(this.gui.searchBar.func_146179_b(), this.p.output.func_82833_r());
        }

        public boolean isOffscreen() {
            return this.x < 0 || this.y < this.gui.field_147009_r || this.y > this.gui.field_147009_r + 150;
        }

        public void drawScreen() {
            this.btnOnOff.field_146125_m = true;
            this.btnMinus.field_146125_m = !this.p.alwaysOn;
            this.btnPlus.field_146125_m = !this.p.alwaysOn;
        }

        public void hideComponents() {
            this.btnOnOff.field_146125_m = false;
            this.btnMinus.field_146125_m = false;
            this.btnPlus.field_146125_m = false;
        }

        public void updatePagePosition(int page, int hiddenOffset) {
            int mockIndex = this.index - page - hiddenOffset;
            int rowHeight = 25;
            this.btnMinus.field_146129_i = this.y = GuiControl.this.field_147009_r + 10 + mockIndex * 25;
            this.btnPlus.field_146129_i = this.y;
            this.btnOnOff.field_146129_i = this.y;
        }
    }
}

