/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.storagenetwork.item.remote;

import java.util.List;
import javax.annotation.Nullable;
import mrriegel.storagenetwork.CreativeTab;
import mrriegel.storagenetwork.StorageNetwork;
import mrriegel.storagenetwork.block.master.TileMaster;
import mrriegel.storagenetwork.config.ConfigHandler;
import mrriegel.storagenetwork.data.EnumSortType;
import mrriegel.storagenetwork.gui.GuiHandler;
import mrriegel.storagenetwork.item.remote.RemoteType;
import mrriegel.storagenetwork.util.NBTHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemRemote
extends Item {
    public ItemRemote() {
        this.func_77637_a(CreativeTab.tab);
        this.setRegistryName("remote");
        this.func_77655_b(this.getRegistryName().toString());
        this.func_77627_a(true);
        this.func_77625_d(1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            for (int i = 0; i < RemoteType.values().length; ++i) {
                list.add((Object)new ItemStack((Item)this, 1, i));
            }
        }
    }

    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a() + "_" + stack.func_77952_i();
    }

    public void func_77624_a(ItemStack stack, @Nullable World playerIn, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(I18n.func_135052_a((String)("tooltip.storagenetwork.remote_" + stack.func_77952_i()), (Object[])new Object[0]));
        if (stack.func_77942_o() && NBTHelper.getBoolean(stack, "bound")) {
            tooltip.add(NBTHelper.getInteger(stack, "dim") + ", x: " + NBTHelper.getInteger(stack, "x") + ", y: " + NBTHelper.getInteger(stack, "y") + ", z: " + NBTHelper.getInteger(stack, "z"));
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        int slot;
        ItemStack itemStackIn = player.func_184586_b(hand);
        int itemDamage = itemStackIn.func_77952_i();
        if (world.field_72995_K || itemDamage < 0 || itemDamage >= RemoteType.values().length || !NBTHelper.getBoolean(itemStackIn, "bound")) {
            return super.func_77659_a(world, player, hand);
        }
        int n = slot = hand == EnumHand.OFF_HAND ? player.field_71071_by.func_70302_i_() - 1 : player.field_71071_by.field_70461_c;
        if (ItemRemote.tryOpenGui(world, player, itemStackIn, slot)) {
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStackIn);
        }
        return super.func_77659_a(world, player, hand);
    }

    public EnumActionResult func_180614_a(EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = playerIn.func_184586_b(hand);
        if (worldIn.func_175625_s(pos) instanceof TileMaster) {
            NBTHelper.setInteger(stack, "x", pos.func_177958_n());
            NBTHelper.setInteger(stack, "y", pos.func_177956_o());
            NBTHelper.setInteger(stack, "z", pos.func_177952_p());
            NBTHelper.setBoolean(stack, "bound", true);
            NBTHelper.setInteger(stack, "dim", worldIn.field_73011_w.getDimension());
            NBTHelper.setString(stack, "sort", EnumSortType.NAME.toString());
            return EnumActionResult.SUCCESS;
        }
        return super.func_180614_a(playerIn, worldIn, pos, hand, side, hitX, hitY, hitZ);
    }

    public static boolean tryOpenGui(World world, EntityPlayer player, ItemStack remote, int inventorySlot) {
        WorldServer serverTargetWorld;
        BlockPos targetPos;
        int itemStackDim;
        int z;
        int y;
        int x;
        int itemDamage = remote.func_77952_i();
        try {
            x = NBTHelper.getInteger(remote, "x");
            y = NBTHelper.getInteger(remote, "y");
            z = NBTHelper.getInteger(remote, "z");
            itemStackDim = NBTHelper.getInteger(remote, "dim");
            if (NBTHelper.getString(remote, "sort") == null) {
                NBTHelper.setString(remote, "sort", EnumSortType.NAME.toString());
            }
            targetPos = new BlockPos(x, y, z);
            serverTargetWorld = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(itemStackDim);
        }
        catch (Throwable e) {
            StorageNetwork.instance.logger.error("Invalid remote data " + remote.func_77978_p(), e);
            return false;
        }
        if (!serverTargetWorld.func_175726_f(targetPos).func_177410_o()) {
            StorageNetwork.chatMessage(player, "item.remote.notloaded");
            return false;
        }
        RemoteType remoteType = RemoteType.values()[itemDamage];
        if (serverTargetWorld.func_175625_s(targetPos) instanceof TileMaster) {
            boolean isSameDimension = itemStackDim == world.field_73011_w.getDimension();
            boolean isWithinRange = player.func_70011_f((double)x, (double)y, (double)z) <= (double)ConfigHandler.rangeWirelessAccessor;
            boolean canOpenGUI = false;
            switch (remoteType) {
                case DIMENSIONAL: {
                    canOpenGUI = true;
                    break;
                }
                case LIMITED: {
                    canOpenGUI = isSameDimension && isWithinRange;
                    break;
                }
                case UNLIMITED: 
                case SIMPLE: {
                    canOpenGUI = isSameDimension;
                }
            }
            if (canOpenGUI) {
                player.openGui((Object)StorageNetwork.instance, ItemRemote.getGui(), world, inventorySlot, y, z);
                return true;
            }
            StorageNetwork.statusMessage(player, "item.remote.outofrange");
        }
        return false;
    }

    protected static int getGui() {
        return GuiHandler.GuiIDs.REMOTE.ordinal();
    }

    public static TileMaster getTile(ItemStack stack) {
        if (stack == null || stack.func_190926_b() || FMLCommonHandler.instance() == null || FMLCommonHandler.instance().getMinecraftServerInstance() == null) {
            return null;
        }
        BlockPos posTag = new BlockPos(NBTHelper.getInteger(stack, "x"), NBTHelper.getInteger(stack, "y"), NBTHelper.getInteger(stack, "z"));
        WorldServer world = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(NBTHelper.getInteger(stack, "dim"));
        TileEntity t = world.func_175625_s(posTag);
        return t instanceof TileMaster ? (TileMaster)t : null;
    }

    public static void copyTag(ItemStack from, ItemStack to) {
        NBTHelper.setInteger(to, "x", NBTHelper.getInteger(from, "x"));
        NBTHelper.setInteger(to, "y", NBTHelper.getInteger(from, "y"));
        NBTHelper.setInteger(to, "z", NBTHelper.getInteger(from, "z"));
        NBTHelper.setBoolean(to, "bound", NBTHelper.getBoolean(from, "bound"));
        NBTHelper.setInteger(to, "dim", NBTHelper.getInteger(from, "dim"));
        NBTHelper.setString(to, "sort", NBTHelper.getString(from, "sort"));
    }
}

