/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.storagenetwork.network;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import mrriegel.storagenetwork.StorageNetwork;
import mrriegel.storagenetwork.block.cable.ContainerCable;
import mrriegel.storagenetwork.block.cable.TileCable;
import mrriegel.storagenetwork.block.cable.processing.TileCableProcess;
import mrriegel.storagenetwork.network.RefreshFilterClientMessage;
import mrriegel.storagenetwork.registry.PacketRegistry;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class ProcessRecipeMessage
implements IMessage,
IMessageHandler<ProcessRecipeMessage, IMessage> {
    private ArrayList<ItemStack> inputs;
    private ArrayList<ItemStack> outputs;

    private static void ensureListSize(ArrayList<ItemStack> list) {
        while (list.size() > 9) {
            list.remove(list.size() - 1);
        }
        while (list.size() < 9) {
            list.add(ItemStack.field_190927_a);
        }
    }

    public ProcessRecipeMessage() {
    }

    public ProcessRecipeMessage(ArrayList<ItemStack> inputs, ArrayList<ItemStack> outputs) {
        ProcessRecipeMessage.ensureListSize(inputs);
        ProcessRecipeMessage.ensureListSize(outputs);
        this.inputs = inputs;
        this.outputs = outputs;
    }

    public IMessage onMessage(ProcessRecipeMessage message, MessageContext ctx) {
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        WorldServer mainThread = (WorldServer)player.field_70170_p;
        mainThread.func_152344_a(() -> {
            TileCable tileCable;
            if (player.field_71070_bA instanceof ContainerCable && (tileCable = ((ContainerCable)player.field_71070_bA).tile) instanceof TileCableProcess) {
                TileCableProcess processCable = (TileCableProcess)tileCable;
                StorageNetwork.log("ProcessRecipe mess or output for filter?? " + message);
                for (int i = 0; i < 9; ++i) {
                    processCable.filters.setStackInSlot(i, message.inputs.get(i));
                }
                PacketRegistry.INSTANCE.sendTo((IMessage)new RefreshFilterClientMessage(processCable.filters.getStacks()), player);
                processCable.func_70296_d();
            }
        });
        return null;
    }

    public void fromBytes(ByteBuf buf) {
        this.inputs = new ArrayList();
        this.outputs = new ArrayList();
        for (int i = 0; i < 9; ++i) {
            this.inputs.add(new ItemStack(ByteBufUtils.readTag((ByteBuf)buf)));
            this.outputs.add(new ItemStack(ByteBufUtils.readTag((ByteBuf)buf)));
        }
    }

    public void toBytes(ByteBuf buf) {
        NBTTagCompound nbt = null;
        for (int i = 0; i < 9; ++i) {
            nbt = this.inputs.get(i).serializeNBT();
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)nbt);
            nbt = this.outputs.get(i).serializeNBT();
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)nbt);
        }
    }
}

