/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.storagenetwork.util;

import mrriegel.storagenetwork.data.ItemStackMatcher;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class UtilInventory {
    public static boolean hasItemHandler(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        return UtilInventory.getItemHandler(world.func_175625_s(pos), facing) != null;
    }

    public static boolean doOverlap(String text, String name) {
        return text.toLowerCase().contains(name.toLowerCase()) || name.toLowerCase().contains(text.toLowerCase());
    }

    public static IItemHandler getItemHandler(TileEntity tile, EnumFacing side) {
        if (tile == null) {
            return null;
        }
        if (tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side)) {
            return (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side);
        }
        if (tile instanceof ISidedInventory) {
            return new SidedInvWrapper((ISidedInventory)tile, side);
        }
        if (tile instanceof IInventory) {
            return new InvWrapper((IInventory)tile);
        }
        return null;
    }

    public static String formatLargeNumber(int size) {
        if ((double)size < Math.pow(10.0, 3.0)) {
            return size + "";
        }
        if ((double)size < Math.pow(10.0, 6.0)) {
            int rounded = Math.round((float)size / 1000.0f);
            return rounded + "K";
        }
        if ((double)size < Math.pow(10.0, 9.0)) {
            int rounded = Math.round((float)size / (float)Math.pow(10.0, 6.0));
            return rounded + "M";
        }
        if ((double)size < Math.pow(10.0, 12.0)) {
            int rounded = Math.round((float)size / (float)Math.pow(10.0, 9.0));
            return rounded + "B";
        }
        return size + "";
    }

    public static boolean contains(IItemHandler inv, ItemStack stack) {
        for (int i = 0; i < inv.getSlots(); ++i) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)inv.getStackInSlot(i), (ItemStack)stack)) continue;
            return true;
        }
        return false;
    }

    public static int containsAtLeastHowManyNeeded(IItemHandler inv, ItemStack stack, int minimumCount) {
        if (inv == null) {
            return 0;
        }
        int found = 0;
        for (int i = 0; i < inv.getSlots(); ++i) {
            if (ItemHandlerHelper.canItemStacksStack((ItemStack)inv.getStackInSlot(i), (ItemStack)stack)) {
                found += inv.getStackInSlot(i).func_190916_E();
            }
            if (found < minimumCount) continue;
            return 0;
        }
        return minimumCount - found;
    }

    public static int getAmount(IItemHandler inv, ItemStackMatcher fil) {
        if (inv == null || fil == null) {
            return 0;
        }
        int amount = 0;
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack slot = inv.getStackInSlot(i);
            if (!fil.match(slot)) continue;
            amount += slot.func_190916_E();
        }
        return amount;
    }

    public static ItemStack extractItem(IItemHandler inv, ItemStackMatcher fil, int num, boolean simulate) {
        if (inv == null || fil == null) {
            return ItemStack.field_190927_a;
        }
        int extracted = 0;
        for (int i = 0; i < inv.getSlots(); ++i) {
            int exFromSlot;
            ItemStack ex;
            ItemStack slot = inv.getStackInSlot(i);
            if (!fil.match(slot) || (ex = inv.extractItem(i, num - extracted, simulate)).func_190926_b() || (extracted += (exFromSlot = ex.func_190916_E())) != num) continue;
            ex.func_190920_e(num);
            return ex;
        }
        return ItemStack.field_190927_a;
    }
}

