/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.storagenetwork.util.inventory;

import javax.annotation.Nonnull;
import mrriegel.storagenetwork.api.data.EnumUpgradeType;
import mrriegel.storagenetwork.util.inventory.ItemStackHandlerEx;
import net.minecraft.item.ItemStack;

public class UpgradesItemStackHandler
extends ItemStackHandlerEx {
    public static final int IO_DEFAULT_SPEED = 30;

    public UpgradesItemStackHandler() {
        super(4);
    }

    protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
        return 1;
    }

    public int getSpeedRatio() {
        int speedUpgrades = this.getUpgradesOfType(EnumUpgradeType.SPEED);
        int slowUpgrades = this.getUpgradesOfType(EnumUpgradeType.SLOW);
        int speedRatio = 30;
        if (speedUpgrades > 0) {
            speedRatio = 30 / (speedUpgrades + 1);
        } else if (slowUpgrades > 0) {
            speedRatio = 30 * (slowUpgrades + 1);
        }
        if (speedRatio < 1) {
            speedRatio = 1;
        }
        return speedRatio;
    }

    public int getUpgradesOfType(EnumUpgradeType upgradeType) {
        int res = 0;
        for (ItemStack stack : this.getStacks()) {
            if (stack.func_77952_i() != upgradeType.ordinal()) continue;
            res += Math.max(stack.func_190916_E(), 0);
        }
        return res;
    }
}

