/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.client.model;

import com.github.mechalopa.hmag.client.model.AbstractGirlModel;
import com.github.mechalopa.hmag.client.model.ZombieGirlModel;
import com.github.mechalopa.hmag.client.util.ModClientUtils;
import com.github.mechalopa.hmag.util.ModUtils;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DrownedGirlModel<T extends Zombie>
extends ZombieGirlModel<T> {
    private ModelPart rightArmPart;
    private ModelPart leftArmPart;

    public DrownedGirlModel(ModelPart modelPart) {
        super(modelPart);
        this.rightArmPart = this.f_102811_.m_171324_("right_arm_part");
        this.leftArmPart = this.f_102812_.m_171324_("left_arm_part");
    }

    public static MeshDefinition createMesh(CubeDeformation cd) {
        MeshDefinition md = ZombieGirlModel.createMesh(cd);
        PartDefinition pd = md.m_171576_();
        PartDefinition rightarmpd = ModClientUtils.addC(pd, cd, "right_arm", 50, 32, -1.0f, -2.0f, -1.5f, 3.0f, 12.0f, 3.0f, -5.0f, 2.0f, 0.0f);
        ModClientUtils.addC(pd, cd, "right_leg", 50, 48, -1.5f, 0.0f, -1.5f, 3.0f, 12.0f, 3.0f, -1.9f, 12.0f, 0.0f);
        PartDefinition leftarmpd = pd.m_171597_("left_arm");
        ModClientUtils.addC(rightarmpd, cd, "right_arm_part", 24, 56, -1.0f, -2.0f, 0.0f, 1.0f, 4.0f, 3.0f, -1.0f, 2.0f, 1.5f);
        ModClientUtils.addC(leftarmpd, cd, "left_arm_part", 40, 54, 0.0f, -2.0f, 0.0f, 1.0f, 8.0f, 2.0f, 1.0f, 2.0f, 1.5f);
        return md;
    }

    public static LayerDefinition createBodyLayer() {
        return LayerDefinition.m_171565_((MeshDefinition)DrownedGirlModel.createMesh(CubeDeformation.f_171458_), (int)64, (int)64);
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float partialTick) {
        DrownedGirlModel.prepareDrownedModel(entity, this);
        super.m_6839_(entity, limbSwing, limbSwingAmount, partialTick);
    }

    @Override
    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        DrownedGirlModel.doAnim(entity, ageInTicks, this.f_102608_, this);
        this.rightArmPart.f_104204_ = -0.17453294f;
        this.rightArmPart.f_104204_ += Mth.m_14031_((float)(ageInTicks * 0.045f + (float)Math.PI)) * 0.06f;
        this.leftArmPart.f_104204_ = 0.17453294f;
        this.leftArmPart.f_104204_ -= Mth.m_14031_((float)(ageInTicks * 0.045f + (float)Math.PI)) * 0.06f;
    }

    public static void prepareDrownedModel(Zombie entity, HumanoidModel<?> model) {
        model.f_102816_ = HumanoidModel.ArmPose.EMPTY;
        model.f_102815_ = HumanoidModel.ArmPose.EMPTY;
        ItemStack stack = entity.m_21120_(InteractionHand.MAIN_HAND);
        if (ModUtils.isTrident(stack) && entity.m_5912_()) {
            if (entity.m_5737_() == HumanoidArm.RIGHT) {
                model.f_102816_ = HumanoidModel.ArmPose.THROW_SPEAR;
            } else {
                model.f_102815_ = HumanoidModel.ArmPose.THROW_SPEAR;
            }
        }
    }

    public static void doAnim(Zombie entity, float ageInTicks, float attackTime, AbstractGirlModel<?> model) {
        if (model.f_102815_ == HumanoidModel.ArmPose.THROW_SPEAR) {
            model.f_102812_.f_104203_ = model.f_102812_.f_104203_ * 0.5f - (float)Math.PI;
            model.f_102812_.f_104204_ = 0.0f;
        }
        if (model.f_102816_ == HumanoidModel.ArmPose.THROW_SPEAR) {
            model.f_102811_.f_104203_ = model.f_102811_.f_104203_ * 0.5f - (float)Math.PI;
            model.f_102811_.f_104204_ = 0.0f;
        }
        if (model.f_102818_ > 0.0f) {
            model.f_102811_.f_104203_ = ModUtils.rotlerpRad(model.f_102818_, model.f_102811_.f_104203_, -2.5132742f) + model.f_102818_ * 0.35f * Mth.m_14031_((float)(0.1f * ageInTicks));
            model.f_102812_.f_104203_ = ModUtils.rotlerpRad(model.f_102818_, model.f_102812_.f_104203_, -2.5132742f) - model.f_102818_ * 0.35f * Mth.m_14031_((float)(0.1f * ageInTicks));
            model.f_102811_.f_104205_ = ModUtils.rotlerpRad(model.f_102818_, model.f_102811_.f_104205_, -0.15f);
            model.f_102812_.f_104205_ = ModUtils.rotlerpRad(model.f_102818_, model.f_102812_.f_104205_, 0.15f);
            model.f_102814_.f_104203_ -= model.f_102818_ * 0.55f * Mth.m_14031_((float)(0.1f * ageInTicks));
            model.f_102813_.f_104203_ += model.f_102818_ * 0.55f * Mth.m_14031_((float)(0.1f * ageInTicks));
            model.f_102808_.f_104203_ = 0.0f;
        }
        model.f_102809_.m_104315_(model.f_102808_);
    }
}

