/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.client.model;

import com.github.mechalopa.hmag.client.model.AbstractGirlModel;
import com.github.mechalopa.hmag.client.util.ModClientUtils;
import com.github.mechalopa.hmag.util.ModUtils;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SkeletonGirlModel<T extends AbstractSkeleton>
extends AbstractGirlModel<T> {
    private ModelPart skirt1;
    private ModelPart skirt2;
    private ModelPart rightHair1;
    private ModelPart leftHair1;
    private ModelPart rightHair2;
    private ModelPart leftHair2;

    public SkeletonGirlModel(ModelPart modelPart) {
        super(modelPart);
        this.skirt1 = this.f_102810_.m_171324_("skirt_1");
        this.skirt2 = this.f_102810_.m_171324_("skirt_2");
        this.rightHair1 = this.f_102808_.m_171324_("right_hair_1");
        this.leftHair1 = this.f_102808_.m_171324_("left_hair_1");
        this.rightHair2 = this.rightHair1.m_171324_("right_hair_2");
        this.leftHair2 = this.leftHair1.m_171324_("left_hair_2");
    }

    public static MeshDefinition createMesh(CubeDeformation cd) {
        MeshDefinition md = AbstractGirlModel.m_170681_(cd, 0.0f);
        PartDefinition pd = md.m_171576_();
        ModClientUtils.addC(pd, cd, "right_arm", 40, 16, 0.0f, -2.0f, -1.0f, 2.0f, 12.0f, 2.0f, -5.0f, 2.0f, 0.0f);
        ModClientUtils.addC(pd, cd, "left_arm", 40, 16, -2.0f, -2.0f, -1.0f, 2.0f, 12.0f, 2.0f, 5.0f, 2.0f, 0.0f, true);
        ModClientUtils.addC(pd, cd, "right_leg", 0, 16, -1.0f, 0.0f, -1.0f, 2.0f, 12.0f, 2.0f, -1.75f, 12.0f, 0.0f);
        ModClientUtils.addC(pd, cd, "left_leg", 0, 16, -1.0f, 0.0f, -1.0f, 2.0f, 12.0f, 2.0f, 1.75f, 12.0f, 0.0f, true);
        PartDefinition bodypd = pd.m_171597_("body");
        ModClientUtils.addC(bodypd, cd, "skirt_1", 0, 38, -3.5f, 0.0f, -2.0f, 7.0f, 1.0f, 4.0f, 0.0f, 11.0f, 0.0f);
        ModClientUtils.addC(bodypd, cd, "skirt_2", 0, 44, -4.0f, 0.0f, -2.5f, 8.0f, 6.0f, 5.0f, 0.0f, 12.0f, 0.0f);
        PartDefinition headpd = pd.m_171597_("head");
        PartDefinition rhpd = ModClientUtils.addC(headpd, cd, "right_hair_1", 32, 32, -0.5f, -1.0f, 0.0f, 1.0f, 12.0f, 1.0f, -4.0f, -8.0f, 2.75f, 0.25f);
        PartDefinition lhpd = ModClientUtils.addC(headpd, cd, "left_hair_1", 32, 32, -0.5f, -1.0f, 0.0f, 1.0f, 12.0f, 1.0f, 4.0f, -8.0f, 2.75f, true, 0.25f);
        ModClientUtils.addC(rhpd, cd, "right_hair_2", 36, 32, -0.5f, -0.5f, 0.0f, 1.0f, 10.0f, 1.0f, 0.0f, 11.0f, 0.0f);
        ModClientUtils.addC(lhpd, cd, "left_hair_2", 36, 32, -0.5f, -0.5f, 0.0f, 1.0f, 10.0f, 1.0f, 0.0f, 11.0f, 0.0f, true);
        return md;
    }

    public static LayerDefinition createBodyLayer() {
        return LayerDefinition.m_171565_((MeshDefinition)SkeletonGirlModel.createMesh(CubeDeformation.f_171458_), (int)64, (int)64);
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float partialTick) {
        SkeletonGirlModel.prepareSkeletonModel(entity, this);
        super.m_6839_(entity, limbSwing, limbSwingAmount, partialTick);
    }

    public static void prepareSkeletonModel(AbstractSkeleton entity, HumanoidModel<?> model) {
        model.f_102816_ = HumanoidModel.ArmPose.EMPTY;
        model.f_102815_ = HumanoidModel.ArmPose.EMPTY;
        ItemStack stack = entity.m_21120_(InteractionHand.MAIN_HAND);
        if (ModUtils.isBow(stack) && entity.m_5912_()) {
            if (entity.m_5737_() == HumanoidArm.RIGHT) {
                model.f_102816_ = HumanoidModel.ArmPose.BOW_AND_ARROW;
            } else {
                model.f_102815_ = HumanoidModel.ArmPose.BOW_AND_ARROW;
            }
        }
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.m_6973_(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        SkeletonGirlModel.doAnim(entity, ageInTicks, this.f_102608_, this);
        this.skirt2.f_104203_ = this.f_102609_ ? -1.2566371f : this.f_102810_.f_104203_;
        this.skirt1.f_104203_ = 0.0f;
        this.rightHair1.f_104203_ = 0.17453294f;
        this.leftHair1.f_104203_ = 0.17453294f;
        this.rightHair1.f_104203_ += Mth.m_14031_((float)(ageInTicks * 0.06f)) * 0.036f;
        this.leftHair1.f_104203_ += Mth.m_14031_((float)(ageInTicks * 0.06f)) * 0.036f;
        this.rightHair1.f_104205_ = 0.34906587f;
        this.leftHair1.f_104205_ = -0.34906587f;
        this.rightHair1.f_104205_ -= Mth.m_14031_((float)(ageInTicks * 0.09f)) * 0.03f;
        this.leftHair1.f_104205_ += Mth.m_14031_((float)(ageInTicks * 0.09f)) * 0.03f;
        this.rightHair2.f_104205_ = -0.20943952f;
        this.leftHair2.f_104205_ = 0.20943952f;
        this.rightHair2.f_104205_ -= Mth.m_14031_((float)(ageInTicks * 0.06f + 1.0471976f)) * 0.03f;
        this.leftHair2.f_104205_ += Mth.m_14031_((float)(ageInTicks * 0.06f + 1.0471976f)) * 0.03f;
    }

    public static void doAnim(AbstractSkeleton entity, float ageInTicks, float attackTime, AbstractGirlModel<?> model) {
        ItemStack stack = entity.m_21205_();
        if (entity.m_5912_() && (stack.m_41619_() || !ModUtils.isBow(stack))) {
            float f = Mth.m_14031_((float)(attackTime * (float)Math.PI));
            float f1 = Mth.m_14031_((float)((1.0f - (1.0f - attackTime) * (1.0f - attackTime)) * (float)Math.PI));
            model.f_102811_.f_104205_ = 0.0f;
            model.f_102812_.f_104205_ = 0.0f;
            model.f_102811_.f_104204_ = -(0.1f - f * 0.6f);
            model.f_102812_.f_104204_ = 0.1f - f * 0.6f;
            model.f_102811_.f_104203_ = -1.5707964f;
            model.f_102812_.f_104203_ = -1.5707964f;
            model.f_102811_.f_104203_ -= f * 1.2f - f1 * 0.4f;
            model.f_102812_.f_104203_ -= f * 1.2f - f1 * 0.4f;
            AnimationUtils.m_102082_((ModelPart)model.f_102811_, (ModelPart)model.f_102812_, (float)ageInTicks);
        }
    }

    @Override
    protected boolean isSkeletonHandTranslate() {
        return true;
    }
}

