/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.client.renderer;

import com.github.mechalopa.hmag.client.ModModelLayers;
import com.github.mechalopa.hmag.client.model.MonolithModel;
import com.github.mechalopa.hmag.client.util.ModClientUtils;
import com.github.mechalopa.hmag.util.ModUtils;
import com.github.mechalopa.hmag.world.entity.MonolithEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Random;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class MonolithRenderer
extends MobRenderer<MonolithEntity, MonolithModel<MonolithEntity>> {
    private static final ResourceLocation TEXTURE_0 = ModClientUtils.getHMaGEntityTexture("monolith/monolith_0");
    private static final ResourceLocation TEXTURE_1 = ModClientUtils.getHMaGEntityTexture("monolith/monolith_1");
    private static final ResourceLocation TEXTURE_2 = ModClientUtils.getHMaGEntityTexture("monolith/monolith_2");
    private static final ResourceLocation TEXTURE_3 = ModClientUtils.getHMaGEntityTexture("monolith/monolith_3");
    private static final ResourceLocation TEXTURE_4 = ModClientUtils.getHMaGEntityTexture("monolith/monolith_4");
    private static final ResourceLocation BEAM_TEXTURE = ModUtils.getRL("textures/entity/guardian_beam.png");
    private static final RenderType BEAM_RENDER_TYPE = RenderType.m_110458_((ResourceLocation)BEAM_TEXTURE);
    private final Random rand = new Random();

    public MonolithRenderer(EntityRendererProvider.Context context) {
        super(context, new MonolithModel(context.m_174023_(ModModelLayers.MONOLITH)), 0.5f);
    }

    public boolean shouldRender(MonolithEntity entity, Frustum camera, double camX, double camY, double camZ) {
        if (super.m_5523_((Mob)entity, camera, camX, camY, camZ)) {
            return true;
        }
        return ModClientUtils.shouldRenderBeamAttackMob((LivingEntity)entity, camera, camX, camY, camZ, entity);
    }

    public void render(MonolithEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        super.m_7392_((Mob)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
        LivingEntity target = entity.getActiveAttackTarget();
        if (target != null) {
            float f = entity.getAttackAnimationScale(partialTicks);
            float f1 = entity.getClientSideAttackTime() + partialTicks;
            float f2 = f1 * 0.5f % 1.0f;
            float f3 = entity.m_20192_();
            poseStack.m_85836_();
            poseStack.m_85837_(0.0, (double)f3, 0.0);
            Vec3 vec3 = ModClientUtils.getPosition(target, (double)target.m_20206_() * 0.5, partialTicks);
            Vec3 vec31 = ModClientUtils.getPosition((LivingEntity)entity, f3, partialTicks);
            Vec3 vec32 = vec3.m_82546_(vec31);
            float f4 = (float)(vec32.m_82553_() + 1.0);
            vec32 = vec32.m_82541_();
            float f5 = (float)Math.acos(vec32.f_82480_);
            float f6 = (float)Math.atan2(vec32.f_82481_, vec32.f_82479_);
            poseStack.m_252781_(Axis.f_252436_.m_252977_((1.5707964f - f6) * 57.295776f));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(f5 * 57.295776f));
            float f7 = f1 * 0.05f * -1.5f;
            float f8 = f * f;
            int i = 192 + (int)(f8 * 55.0f);
            int j = 32 + (int)(f8 * 159.0f);
            int k = 160 + (int)(f8 * 63.0f);
            float f11 = Mth.m_14089_((float)(f7 + 2.3561945f)) * 0.282f;
            float f12 = Mth.m_14031_((float)(f7 + 2.3561945f)) * 0.282f;
            float f13 = Mth.m_14089_((float)(f7 + 0.7853982f)) * 0.282f;
            float f14 = Mth.m_14031_((float)(f7 + 0.7853982f)) * 0.282f;
            float f15 = Mth.m_14089_((float)(f7 + 3.926991f)) * 0.282f;
            float f16 = Mth.m_14031_((float)(f7 + 3.926991f)) * 0.282f;
            float f17 = Mth.m_14089_((float)(f7 + 5.4977875f)) * 0.282f;
            float f18 = Mth.m_14031_((float)(f7 + 5.4977875f)) * 0.282f;
            float f19 = Mth.m_14089_((float)(f7 + (float)Math.PI)) * 0.2f;
            float f20 = Mth.m_14031_((float)(f7 + (float)Math.PI)) * 0.2f;
            float f21 = Mth.m_14089_((float)(f7 + 0.0f)) * 0.2f;
            float f22 = Mth.m_14031_((float)(f7 + 0.0f)) * 0.2f;
            float f23 = Mth.m_14089_((float)(f7 + 1.5707964f)) * 0.2f;
            float f24 = Mth.m_14031_((float)(f7 + 1.5707964f)) * 0.2f;
            float f25 = Mth.m_14089_((float)(f7 + 4.712389f)) * 0.2f;
            float f26 = Mth.m_14031_((float)(f7 + 4.712389f)) * 0.2f;
            float f29 = -1.0f + f2;
            float f30 = f4 * 2.5f + f29;
            VertexConsumer vertexconsumer = buffer.m_6299_(BEAM_RENDER_TYPE);
            PoseStack.Pose posestack$pose = poseStack.m_85850_();
            Matrix4f matrix4f = posestack$pose.m_252922_();
            Matrix3f matrix3f = posestack$pose.m_252943_();
            ModClientUtils.drawVertex(vertexconsumer, matrix4f, matrix3f, f19, f4, f20, i, j, k, 0.5f, f30);
            ModClientUtils.drawVertex(vertexconsumer, matrix4f, matrix3f, f19, 0.0f, f20, i, j, k, 0.5f, f29);
            ModClientUtils.drawVertex(vertexconsumer, matrix4f, matrix3f, f21, 0.0f, f22, i, j, k, 0.0f, f29);
            ModClientUtils.drawVertex(vertexconsumer, matrix4f, matrix3f, f21, f4, f22, i, j, k, 0.0f, f30);
            ModClientUtils.drawVertex(vertexconsumer, matrix4f, matrix3f, f23, f4, f24, i, j, k, 0.5f, f30);
            ModClientUtils.drawVertex(vertexconsumer, matrix4f, matrix3f, f23, 0.0f, f24, i, j, k, 0.5f, f29);
            ModClientUtils.drawVertex(vertexconsumer, matrix4f, matrix3f, f25, 0.0f, f26, i, j, k, 0.0f, f29);
            ModClientUtils.drawVertex(vertexconsumer, matrix4f, matrix3f, f25, f4, f26, i, j, k, 0.0f, f30);
            float f31 = entity.f_19797_ % 2 == 0 ? 0.5f : 0.0f;
            ModClientUtils.drawVertex(vertexconsumer, matrix4f, matrix3f, f11, f4, f12, i, j, k, 0.5f, f31 + 0.5f);
            ModClientUtils.drawVertex(vertexconsumer, matrix4f, matrix3f, f13, f4, f14, i, j, k, 1.0f, f31 + 0.5f);
            ModClientUtils.drawVertex(vertexconsumer, matrix4f, matrix3f, f17, f4, f18, i, j, k, 1.0f, f31);
            ModClientUtils.drawVertex(vertexconsumer, matrix4f, matrix3f, f15, f4, f16, i, j, k, 0.5f, f31);
            poseStack.m_85849_();
        }
    }

    public Vec3 getRenderOffset(MonolithEntity entity, float partialTicks) {
        if (entity.getAttackPhase() == MonolithEntity.AttackPhase.ROAR_ATTACK) {
            return new Vec3(this.rand.nextGaussian() * 0.01, 0.0, this.rand.nextGaussian() * 0.01);
        }
        return super.m_7860_((Entity)entity, partialTicks);
    }

    protected int getBlockLightLevel(MonolithEntity entity, BlockPos pos) {
        return Mth.m_14045_((int)(super.m_6086_((Entity)entity, pos) + 12), (int)0, (int)15);
    }

    public ResourceLocation getTextureLocation(MonolithEntity entity) {
        switch (entity.getAttackPhase()) {
            case BEAM_CHARGE2: 
            case BEAM_END: {
                return TEXTURE_1;
            }
            case BEAM_ATTACK: {
                return TEXTURE_2;
            }
            case ROAR_CHARGE: 
            case ROAR_END: {
                return TEXTURE_3;
            }
            case ROAR_ATTACK: {
                return TEXTURE_4;
            }
        }
        return TEXTURE_0;
    }
}

