/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.util;

import com.github.mechalopa.hmag.util.ModUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraftforge.registries.ForgeRegistries;

public class ModTags {
    private static TagKey<Block> createBlockTag(String name) {
        return TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)ModUtils.getHMaGRL(name));
    }

    private static TagKey<Item> createItemTag(String name) {
        return TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)ModUtils.getHMaGRL(name));
    }

    private static TagKey<EntityType<?>> createEntityTypeTag(String name) {
        return TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)ModUtils.getHMaGRL(name));
    }

    private static TagKey<DamageType> createDamageTypeTag(String name) {
        return TagKey.m_203882_((ResourceKey)Registries.f_268580_, (ResourceLocation)ModUtils.getHMaGRL(name));
    }

    private static TagKey<Enchantment> createEnchantmentTag(String name) {
        return TagKey.m_203882_((ResourceKey)Registries.f_256762_, (ResourceLocation)ModUtils.getHMaGRL(name));
    }

    private static TagKey<MobEffect> createMobEffectTag(String name) {
        return TagKey.m_203882_((ResourceKey)Registries.f_256929_, (ResourceLocation)ModUtils.getHMaGRL(name));
    }

    private static TagKey<Biome> createBiomeTag(String name) {
        return TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)ModUtils.getHMaGRL(name));
    }

    private static TagKey<Structure> createStructureTag(String name) {
        return TagKey.m_203882_((ResourceKey)Registries.f_256944_, (ResourceLocation)ModUtils.getHMaGRL(name));
    }

    public static boolean checkTagContains(Enchantment enchantment, TagKey<Enchantment> tag) {
        return enchantment != null && tag != null && ((Holder)ForgeRegistries.ENCHANTMENTS.getHolder((Object)enchantment).orElseThrow()).m_203656_(tag);
    }

    public static boolean checkTagContains(MobEffect effect, TagKey<MobEffect> tag) {
        return effect != null && tag != null && ((Holder)ForgeRegistries.MOB_EFFECTS.getHolder((Object)effect).orElseThrow()).m_203656_(tag);
    }

    public static final class StructureTags {
        public static final TagKey<Structure> GIANT_MUMMIES_SPAWN_IN = ModTags.createStructureTag("giant_mummies_spawn_in");
        public static final TagKey<Structure> MONOLITHS_SPAWN_IN = ModTags.createStructureTag("monoliths_spawn_in");
    }

    public static final class BiomeTags {
        public static final TagKey<Biome> IS_BADLANDS = ModTags.createBiomeTag("is_badlands");
        public static final TagKey<Biome> IS_COLD = ModTags.createBiomeTag("is_cold");
        public static final TagKey<Biome> IS_PLAINS = ModTags.createBiomeTag("is_plains");
        public static final TagKey<Biome> IS_SANDY = ModTags.createBiomeTag("is_sandy");
        public static final TagKey<Biome> IS_SAVANNA = ModTags.createBiomeTag("is_savanna");
        public static final TagKey<Biome> JACK_FROST_MELTS = ModTags.createBiomeTag("jack_frost_melts");
        public static final TagKey<Biome> NO_MOB_REPLACEMENTS = ModTags.createBiomeTag("no_mob_replacements");
        public static final TagKey<Biome> SWAMPER_SUFFOCATES = ModTags.createBiomeTag("swamper_suffocates");
    }

    public static final class MobEffectTags {
        public static final TagKey<MobEffect> ALRAUNE_IMMUNE_TO = ModTags.createMobEffectTag("alraune_immune_to");
        public static final TagKey<MobEffect> CATOBLEPAS_IMMUNE_TO = ModTags.createMobEffectTag("catoblepas_immune_to");
        public static final TagKey<MobEffect> CRIMSON_SLAUGHTERER_IMMUNE_TO = ModTags.createMobEffectTag("crimson_slaughterer_immune_to");
        public static final TagKey<MobEffect> DYSSOMNIA_IMMUNE_TO = ModTags.createMobEffectTag("dyssomnia_immune_to");
        public static final TagKey<MobEffect> MONOLITH_IMMUNE_TO = ModTags.createMobEffectTag("monolith_immune_to");
        public static final TagKey<MobEffect> RANDOMBERRY_GIVES = ModTags.createMobEffectTag("randomberry_gives");
        public static final TagKey<MobEffect> SPIDER_NEST_IMMUNE_TO = ModTags.createMobEffectTag("spider_nest_immune_to");
        public static final TagKey<MobEffect> SCORPION_IMMUNE_TO = ModTags.createMobEffectTag("scorpion_immune_to");
        public static final TagKey<MobEffect> UNREMOVABLE_EFFECTS = ModTags.createMobEffectTag("unremovable_effects");
        public static final TagKey<MobEffect> WITHER_GHOST_IMMUNE_TO = ModTags.createMobEffectTag("wither_ghost_immune_to");
    }

    public static final class EnchantmentTags {
        public static final TagKey<Enchantment> INCOMPATIBLE_WITH_ANTI_AIR = ModTags.createEnchantmentTag("incompatible_with_anti_air");
        public static final TagKey<Enchantment> INCOMPATIBLE_WITH_HEALTH_BOOST = ModTags.createEnchantmentTag("incompatible_with_health_boost");
        public static final TagKey<Enchantment> INCOMPATIBLE_WITH_WATER_ASPECT = ModTags.createEnchantmentTag("incompatible_with_water_aspect");
        public static final TagKey<Enchantment> UNREMOVABLE_CURSES = ModTags.createEnchantmentTag("unremovable_curses");
    }

    public static final class DamageTypeTags {
        public static final TagKey<DamageType> ALRAUNE_VULNERABLE_TO = ModTags.createDamageTypeTag("alraune_vulnerable_to");
        public static final TagKey<DamageType> BYPASSES_ENDER_EXECUTOR_DAMAGE_REDUCING = ModTags.createDamageTypeTag("bypasses_ender_executor_damage_reducing");
        public static final TagKey<DamageType> CRIMSON_SLAUGHTERER_RESISTANT_TO = ModTags.createDamageTypeTag("crimson_slaughterer_resistant_to");
        public static final TagKey<DamageType> CURSED_DOLL_VULNERABLE_TO = ModTags.createDamageTypeTag("cursed_doll_vulnerable_to");
        public static final TagKey<DamageType> DOGU_IMMUNE_TO = ModTags.createDamageTypeTag("dogu_immune_to");
        public static final TagKey<DamageType> DOGU_RESISTANT_TO = ModTags.createDamageTypeTag("dogu_resistant_to");
        public static final TagKey<DamageType> DULLAHAN_RESISTANT_TO = ModTags.createDamageTypeTag("dullahan_resistant_to");
        public static final TagKey<DamageType> FORTRESS_KEEPER_RESISTANT_TO = ModTags.createDamageTypeTag("fortress_keeper_resistant_to");
        public static final TagKey<DamageType> GIANT_MUMMY_RESISTANT_TO = ModTags.createDamageTypeTag("giant_mummy_resistant_to");
        public static final TagKey<DamageType> GIANT_MUMMY_VULNERABLE_TO = ModTags.createDamageTypeTag("giant_mummy_vulnerable_to");
        public static final TagKey<DamageType> GLARYAD_VULNERABLE_TO = ModTags.createDamageTypeTag("glaryad_vulnerable_to");
        public static final TagKey<DamageType> HORNET_VULNERABLE_TO = ModTags.createDamageTypeTag("hornet_vulnerable_to");
        public static final TagKey<DamageType> IMP_RESISTANT_TO = ModTags.createDamageTypeTag("imp_resistant_to");
        public static final TagKey<DamageType> JACK_FROST_VULNERABLE_TO = ModTags.createDamageTypeTag("jack_frost_vulnerable_to");
        public static final TagKey<DamageType> JIANGSHI_RESISTANT_TO = ModTags.createDamageTypeTag("jiangshi_resistant_to");
        public static final TagKey<DamageType> LICH_RESISTANT_TO = ModTags.createDamageTypeTag("lich_resistant_to");
        public static final TagKey<DamageType> MAGICAL_SLIME_RESISTANT_TO = ModTags.createDamageTypeTag("magical_slime_resistant_to");
        public static final TagKey<DamageType> MONOLITH_RESISTANT_TO = ModTags.createDamageTypeTag("monolith_resistant_to");
        public static final TagKey<DamageType> NIGHTWALKER_RESISTANT_TO = ModTags.createDamageTypeTag("nightwalker_resistant_to");
        public static final TagKey<DamageType> OGRE_HIGHLY_RESISTANT_TO = ModTags.createDamageTypeTag("ogre_highly_resistant_to");
        public static final TagKey<DamageType> OGRE_RESISTANT_TO = ModTags.createDamageTypeTag("ogre_resistant_to");
        public static final TagKey<DamageType> SLIME_GIRL_RESISTANT_TO = ModTags.createDamageTypeTag("slime_girl_resistant_to");
        public static final TagKey<DamageType> SNOW_CANINE_RESISTANT_TO = ModTags.createDamageTypeTag("snow_canine_resistant_to");
        public static final TagKey<DamageType> SPIDER_NEST_RESISTANT_TO = ModTags.createDamageTypeTag("spider_nest_resistant_to");
        public static final TagKey<DamageType> SPIDER_NEST_VULNERABLE_TO = ModTags.createDamageTypeTag("spider_nest_vulnerable_to");
        public static final TagKey<DamageType> SWAMPER_RESISTANT_TO = ModTags.createDamageTypeTag("swamper_resistant_to");
        public static final TagKey<DamageType> SWAMPER_VULNERABLE_TO = ModTags.createDamageTypeTag("swamper_vulnerable_to");
        public static final TagKey<DamageType> TRIGGERS_OGRE_DESTROYING = ModTags.createDamageTypeTag("triggers_ogre_destroying");
    }

    public static final class EntityTypeTags {
        public static final TagKey<EntityType<?>> CREEPER_GIRL_REPLACEABLES = ModTags.createEntityTypeTag("creeper_girl_replaceables");
        public static final TagKey<EntityType<?>> CRIMSON_SLAUGHTERER_TARGET_ANIMAL_BLACKLIST = ModTags.createEntityTypeTag("crimson_slaughterer_target_animal_blacklist");
        public static final TagKey<EntityType<?>> DROWNED_GIRL_REPLACEABLES = ModTags.createEntityTypeTag("drowned_girl_replaceables");
        public static final TagKey<EntityType<?>> ENDER_EXECUTOR_REPLACEABLES = ModTags.createEntityTypeTag("ender_executor_replaceables");
        public static final TagKey<EntityType<?>> ENDER_RAGE_IMMUNE_BLACKLIST = ModTags.createEntityTypeTag("ender_rage_immune_blacklist");
        public static final TagKey<EntityType<?>> ENDER_RAGE_IMMUNE_WHITELIST = ModTags.createEntityTypeTag("ender_rage_immune_whitelist");
        public static final TagKey<EntityType<?>> HARD_SNOWBALL_HURTS_EXTRA_TYPES = ModTags.createEntityTypeTag("hard_snowball_hurts_extra_types");
        public static final TagKey<EntityType<?>> HUSK_GIRL_REPLACEABLES = ModTags.createEntityTypeTag("husk_girl_replaceables");
        public static final TagKey<EntityType<?>> INK_SPIT_IMMUNE = ModTags.createEntityTypeTag("ink_spit_immune");
        public static final TagKey<EntityType<?>> KASHA_TARGETS = ModTags.createEntityTypeTag("kasha_targets");
        public static final TagKey<EntityType<?>> KASHA_TARGETS_BABY_ONLY = ModTags.createEntityTypeTag("kasha_targets_baby_only");
        public static final TagKey<EntityType<?>> MELTY_MONSTER_AVOIDS = ModTags.createEntityTypeTag("melty_monster_avoids");
        public static final TagKey<EntityType<?>> MONOLITH_ROAR_IMMUNE = ModTags.createEntityTypeTag("monolith_roar_immune");
        public static final TagKey<EntityType<?>> MONOLITH_TARGET_BLACKLIST = ModTags.createEntityTypeTag("monolith_target_blacklist");
        public static final TagKey<EntityType<?>> SAVAGEFANG_TARGET_BLACKLIST = ModTags.createEntityTypeTag("savagefang_target_blacklist");
        public static final TagKey<EntityType<?>> SKELETON_GIRL_REPLACEABLES = ModTags.createEntityTypeTag("skeleton_girl_replaceables");
        public static final TagKey<EntityType<?>> SNOW_CANINE_TARGETS = ModTags.createEntityTypeTag("snow_canine_targets");
        public static final TagKey<EntityType<?>> SNOWBALL_HURTS_TYPES = ModTags.createEntityTypeTag("snowball_hurts_types");
        public static final TagKey<EntityType<?>> STRAY_GIRL_REPLACEABLES = ModTags.createEntityTypeTag("stray_girl_replaceables");
        public static final TagKey<EntityType<?>> WITHER_SKELETON_GIRL_REPLACEABLES = ModTags.createEntityTypeTag("wither_skeleton_girl_replaceables");
        public static final TagKey<EntityType<?>> ZOMBIE_GIRL_REPLACEABLES = ModTags.createEntityTypeTag("zombie_girl_replaceables");
    }

    public static final class ItemTags {
        public static final TagKey<Item> ANCIENT_ARMOR_REPAIR_ITEMS = ModTags.createItemTag("ancient_armor_repair_items");
        public static final TagKey<Item> ANCIENT_SHIELD_REPAIR_ITEMS = ModTags.createItemTag("ancient_shield_repair_items");
        public static final TagKey<Item> CRIMSON_BOW_REPAIR_ITEMS = ModTags.createItemTag("crimson_bow_repair_items");
        public static final TagKey<Item> CURSE_REMOVE_ITEMS = ModTags.createItemTag("curse_remove_items");
        public static final TagKey<Item> CURSE_REMOVE_TEMPLATES = ModTags.createItemTag("curse_remove_templates");
        public static final TagKey<Item> CURSE_UNREMOVABLES = ModTags.createItemTag("curse_unremovables");
        public static final TagKey<Item> ENCHANTMENT_NOT_UPGRADABLES = ModTags.createItemTag("enchantment_not_upgradables");
        public static final TagKey<Item> FORTRESS_SHIELD_REPAIR_ITEMS = ModTags.createItemTag("fortress_shield_repair_items");
        public static final TagKey<Item> GLARYAD_TEMPT_ITEMS = ModTags.createItemTag("glaryad_tempt_items");
        public static final TagKey<Item> INSOMNIA_ITEMS = ModTags.createItemTag("insomnia_items");
        public static final TagKey<Item> INSOMNIA_SWORD_REPAIR_ITEMS = ModTags.createItemTag("insomnia_sword_repair_items");
        public static final TagKey<Item> NECROTIC_CHAINMAIL_ARMOR_REPAIR_ITEMS = ModTags.createItemTag("necrotic_chainmail_armor_repair_items");
        public static final TagKey<Item> NEMESIS_BLADE_REPAIR_ITEMS = ModTags.createItemTag("nemesis_blade_repair_items");
        public static final TagKey<Item> SUSPICIOUS_STEW_UPGRADE_ITEMS = ModTags.createItemTag("suspicious_stew_upgrade_items");
    }

    public static final class BlockTags {
        public static final TagKey<Block> GIANT_MUMMY_DESTROYABLES = ModTags.createBlockTag("giant_mummy_destroyables");
        public static final TagKey<Block> GLARYADS_SPAWNABLE_ON = ModTags.createBlockTag("glaryads_spawnable_on");
        public static final TagKey<Block> OGRE_IMMUNE = ModTags.createBlockTag("ogre_immune");
        public static final TagKey<Block> SOUL_KASHA_SPAWNABLE_ON = ModTags.createBlockTag("soul_kasha_spawnable_on");
    }
}

