/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.util;

import com.mojang.serialization.Codec;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ModUtils {
    public static final Item[] POTION_ITEMS = new Item[]{Items.f_42589_, Items.f_42736_, Items.f_42739_, Items.f_42738_};
    public static final EquipmentSlot[] ARMOR_SLOTS = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
    public static final String LIVING_UPDATE_CHECKING_KEY = "hmag.checking";
    public static final String LIVING_UPDATE_CHECKED_KEY = "hmag.checked";
    public static final String LIVING_NOT_REPLACED_KEY = "hmag.notReplaced";
    public static final String WITH_SPAWN_PARTICLE_KEY = "hmag.withSpawnParticle";
    public static final Codec<HolderSet<Structure>> STRUCTURE_LIST_CODEC = RegistryCodecs.m_206279_((ResourceKey)Registries.f_256944_, (Codec)Structure.f_226553_);

    public static void burnInDay(@Nonnull LivingEntity livingEntity, RandomSource random, Boolean isSunBurnTick) {
        ModUtils.burnInDay(livingEntity, random, isSunBurnTick, 8);
    }

    public static void burnInDay(@Nonnull LivingEntity livingEntity, RandomSource random, Boolean isSunBurnTick, Boolean shouldBurn) {
        ModUtils.burnInDay(livingEntity, random, isSunBurnTick, shouldBurn, 8);
    }

    public static void burnInDay(@Nonnull LivingEntity livingEntity, RandomSource random, Boolean isSunBurnTick, int seconds) {
        ModUtils.burnInDay(livingEntity, random, isSunBurnTick, true, seconds);
    }

    public static void burnInDay(@Nonnull LivingEntity livingEntity, RandomSource random, Boolean isSunBurnTick, Boolean shouldBurn, int seconds) {
        if (livingEntity != null && livingEntity.m_9236_() != null && !livingEntity.m_9236_().m_5776_() && livingEntity.m_6084_()) {
            boolean flag;
            boolean bl = flag = isSunBurnTick != false && shouldBurn != false;
            if (flag) {
                ItemStack stack = livingEntity.m_6844_(EquipmentSlot.HEAD);
                if (!stack.m_41619_()) {
                    if (stack.m_41763_()) {
                        stack.m_41721_(stack.m_41773_() + random.m_188503_(2));
                        if (stack.m_41773_() >= stack.m_41776_()) {
                            livingEntity.m_21166_(EquipmentSlot.HEAD);
                            livingEntity.m_8061_(EquipmentSlot.HEAD, ItemStack.f_41583_);
                        }
                    }
                    flag = false;
                }
                if (flag) {
                    livingEntity.m_20254_(seconds);
                }
            }
        }
    }

    public static void catchFire(@Nonnull LivingEntity livingEntity, @Nonnull Entity target, RandomSource random) {
        float f = livingEntity.m_9236_().m_6436_(livingEntity.m_20183_()).m_19056_();
        if (livingEntity.m_21205_().m_41619_() && livingEntity.m_6060_() && random.m_188501_() < f * 0.3f) {
            target.m_20254_(2 * (int)f);
        }
    }

    public static boolean canReach(@Nonnull LivingEntity livingEntity, Vec3 vec3, int count) {
        AABB axisalignedbb = livingEntity.m_20191_();
        for (int i = 1; i < count; ++i) {
            axisalignedbb = axisalignedbb.m_82383_(vec3);
            if (livingEntity.m_9236_().m_45756_((Entity)livingEntity, axisalignedbb)) continue;
            return false;
        }
        return true;
    }

    public static boolean closerThan(@Nonnull Entity entity, BlockPos pos, int distance) {
        return pos.m_123314_((Vec3i)entity.m_20183_(), (double)distance);
    }

    public static boolean isDarkEnoughToSpawn(ServerLevelAccessor levelAccessor, BlockPos pos, RandomSource random) {
        if (levelAccessor.m_45517_(LightLayer.SKY, pos) > random.m_188503_(32)) {
            return false;
        }
        DimensionType dimensiontype = levelAccessor.m_6042_();
        int i = dimensiontype.m_223570_();
        if (i < 15 && levelAccessor.m_45517_(LightLayer.BLOCK, pos) > i) {
            return false;
        }
        int j = levelAccessor.m_6018_().m_46470_() ? levelAccessor.m_46849_(pos, 10) : levelAccessor.m_46803_(pos);
        return j <= dimensiontype.m_223569_().m_214085_(random);
    }

    public static float rotlerp(float f, float f1, float f2, boolean flag) {
        float f3 = Mth.m_14177_((float)(f1 - f));
        if (f3 > f2) {
            f3 = f2;
        }
        if (f3 < -f2) {
            f3 = -f2;
        }
        float f4 = f + f3;
        if (!flag) {
            return f4;
        }
        if (f4 < 0.0f) {
            f4 += 360.0f;
        } else if (f4 > 360.0f) {
            f4 -= 360.0f;
        }
        return f4;
    }

    public static float rotlerpRad(float f, float f1, float f2) {
        float f3 = (f2 - f1) % ((float)Math.PI * 2);
        if (f3 < (float)(-Math.PI)) {
            f3 += (float)Math.PI * 2;
        }
        if (f3 >= (float)Math.PI) {
            f3 -= (float)Math.PI * 2;
        }
        return f1 + f * f3;
    }

    public static float rotlerp2(float f, float f1, float f2) {
        while (f1 - f < -180.0f) {
            f -= 360.0f;
        }
        while (f1 - f >= 180.0f) {
            f += 360.0f;
        }
        return Mth.m_14179_((float)f2, (float)f, (float)f1);
    }

    public static ItemStack getPlayerInventoryItem(@Nonnull Player player, Predicate<ItemStack> predicate) {
        ItemStack stack = ModUtils.getHeldItem((LivingEntity)player, predicate);
        if (!stack.m_41619_()) {
            return stack;
        }
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack stack1 = player.m_150109_().m_8020_(i);
            if (!predicate.test(stack1)) continue;
            return stack1;
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack getHeldItem(@Nonnull LivingEntity livingEntity, @Nonnull Item item) {
        return ModUtils.getHeldItem(livingEntity, (Predicate<ItemStack>)Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
    }

    public static ItemStack getHeldItem(@Nonnull LivingEntity livingEntity, Predicate<ItemStack> predicate) {
        if (predicate.test(livingEntity.m_21120_(InteractionHand.OFF_HAND))) {
            return livingEntity.m_21120_(InteractionHand.OFF_HAND);
        }
        return predicate.test(livingEntity.m_21120_(InteractionHand.MAIN_HAND)) ? livingEntity.m_21120_(InteractionHand.MAIN_HAND) : ItemStack.f_41583_;
    }

    public static boolean isBow(ItemStack stack) {
        if (!stack.m_41619_()) {
            return ModUtils.isBow(stack.m_41720_());
        }
        return false;
    }

    public static boolean isBow(Item item) {
        return item != null && (item == Items.f_42411_ || item instanceof BowItem);
    }

    public static boolean isCrossbow(ItemStack stack) {
        if (!stack.m_41619_()) {
            return ModUtils.isCrossbow(stack.m_41720_());
        }
        return false;
    }

    public static boolean isCrossbow(Item item) {
        return item != null && (item == Items.f_42717_ || item instanceof CrossbowItem);
    }

    public static boolean isTrident(ItemStack stack) {
        if (!stack.m_41619_()) {
            return ModUtils.isTrident(stack.m_41720_());
        }
        return false;
    }

    public static boolean isTrident(Item item) {
        return item != null && (item == Items.f_42713_ || item instanceof TridentItem);
    }

    public static ItemStack getPotionStack(Potion potion) {
        return ModUtils.getPotionStack(potion, Items.f_42589_);
    }

    public static ItemStack getPotionStack(Potion potion, Item containerItem) {
        return PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)containerItem), (Potion)potion);
    }

    public static ResourceLocation getRL(String name) {
        return new ResourceLocation(name);
    }

    public static ResourceLocation getHMaGRL(String name) {
        return new ResourceLocation("hmag", name);
    }
}

