/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.world.entity;

import com.github.mechalopa.hmag.ModConfigs;
import com.github.mechalopa.hmag.util.ModTags;
import com.github.mechalopa.hmag.world.entity.ai.goal.RangedAttackGoal2;
import com.github.mechalopa.hmag.world.entity.projectile.MagicBulletEntity;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkHooks;

public class LichEntity
extends Monster
implements RangedAttackMob {
    private static final TargetingConditions VEX_COUNT_TARGETING = TargetingConditions.m_148353_().m_26883_(16.0).m_148355_().m_26893_();

    public LichEntity(EntityType<? extends LichEntity> type, Level level) {
        super(type, level);
        this.f_21364_ = 25;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(4, (Goal)new RangedAttackGoal2(this, 1.1, 20, 40, 15.0f, true));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        if (ModConfigs.cachedServer.LICH_ATTACK_BABY_TURTLES) {
            this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Turtle.class, 10, true, false, Turtle.f_30122_));
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 80.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22284_, 4.0);
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_269533_(ModTags.DamageTypeTags.LICH_RESISTANT_TO)) {
            amount *= 0.5f;
        }
        return super.m_6469_(source, amount);
    }

    public void m_6504_(LivingEntity target, float distance) {
        if (ModConfigs.cachedServer.LICH_SUMMON_VEX && distance < 0.5f && this.m_217043_().m_188503_(4) > this.m_9236_().m_45971_(Vex.class, VEX_COUNT_TARGETING, (LivingEntity)this, this.m_20191_().m_82400_(16.0)).size()) {
            ServerLevel serverlevel = (ServerLevel)this.m_9236_();
            for (int i = 0; i < 3; ++i) {
                BlockPos blockpos = this.m_20183_().m_7918_(-2 + this.m_217043_().m_188503_(5), 1, -2 + this.m_217043_().m_188503_(5));
                Vex vex = (Vex)EntityType.f_20491_.m_20615_(this.m_9236_());
                vex.m_20035_(blockpos, 0.0f, 0.0f);
                vex.m_6518_((ServerLevelAccessor)serverlevel, this.m_9236_().m_6436_(blockpos), MobSpawnType.MOB_SUMMONED, (SpawnGroupData)null, (CompoundTag)null);
                vex.m_33994_((Mob)this);
                vex.m_34033_(blockpos);
                vex.m_33987_(20 * (30 + this.f_19796_.m_188503_(90)));
                serverlevel.m_47205_((Entity)vex);
            }
            this.m_5496_(SoundEvents.f_11862_, 1.0f, 1.0f);
            this.m_6674_(InteractionHand.MAIN_HAND);
        } else {
            double d1 = target.m_20185_() - this.m_20185_();
            double d2 = target.m_20186_() + (double)target.m_20192_() * 0.5 - this.m_20227_(0.5);
            double d3 = target.m_20189_() - this.m_20189_();
            double d4 = Math.sqrt(d1 * d1 + d3 * d3) * 0.05;
            MagicBulletEntity bullet = new MagicBulletEntity(this.m_9236_(), (LivingEntity)this, d1 + this.m_217043_().m_188583_() * d4, d2, d3 + this.m_217043_().m_188583_() * d4);
            bullet.m_6034_(bullet.m_20185_(), this.m_20227_(0.5) + 0.25, bullet.m_20189_());
            bullet.setDamage(6.0f);
            bullet.setEffectLevel((byte)1);
            bullet.setVariant(MagicBulletEntity.Variant.LICH);
            this.m_9236_().m_7967_((Entity)bullet);
            this.m_5496_(SoundEvents.f_11705_, 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
            this.m_6674_(InteractionHand.MAIN_HAND);
        }
    }

    public boolean m_7307_(Entity entity) {
        if (entity == null) {
            return false;
        }
        if (entity == this) {
            return true;
        }
        if (super.m_7307_(entity)) {
            return true;
        }
        if (entity instanceof Vex) {
            return this.m_7307_((Entity)((Vex)entity).m_19749_());
        }
        return false;
    }

    public static boolean checkLichSpawnRules(EntityType<? extends LichEntity> type, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return Monster.m_219013_(type, (ServerLevelAccessor)levelAccessor, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random) && (spawnType == MobSpawnType.SPAWNER || pos.m_123342_() <= ModConfigs.cachedServer.LICH_SPAWN_MAX_HEIGHT);
    }

    public int m_5792_() {
        return 1;
    }

    public double m_6049_() {
        return -0.6;
    }

    protected float m_6431_(Pose pose, EntityDimensions size) {
        return 2.0f;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12423_;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return SoundEvents.f_12381_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12424_;
    }

    protected void m_7355_(BlockPos pos, BlockState block) {
        this.m_5496_(SoundEvents.f_12614_, 0.15f, 1.0f);
    }

    @Nonnull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

