/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.world.entity;

import com.github.mechalopa.hmag.ModConfigs;
import com.github.mechalopa.hmag.util.ModTags;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;

public class MeltyMonsterEntity
extends Monster
implements RangedAttackMob {
    public MeltyMonsterEntity(EntityType<? extends MeltyMonsterEntity> type, Level level) {
        super(type, level);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.LAVA, 0.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 0.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, 0.0f);
        this.f_21364_ = 15;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, LivingEntity.class, p -> p.m_6095_().m_204039_(ModTags.EntityTypeTags.MELTY_MONSTER_AVOIDS), 10.0f, 1.0, 1.5, EntitySelector.f_20408_::test));
        this.f_21345_.m_25352_(3, (Goal)new GoToLavaGoal(this, 1.5));
        this.f_21345_.m_25352_(5, (Goal)new RangedAttackGoal((RangedAttackMob)this, 1.0, 30, 40, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, p -> p.m_20202_() == null || !p.m_20202_().m_6095_().m_204039_(ModTags.EntityTypeTags.MELTY_MONSTER_AVOIDS)));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 25.0).m_22268_(Attributes.f_22279_, 0.18);
    }

    public void m_8107_() {
        if (this.m_9236_().m_5776_() && !this.m_20070_()) {
            if (this.f_19797_ % 5 == 0) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.m_20208_(0.5), this.m_20187_() - 0.5, this.m_20262_(0.5), 0.0, 0.0, 0.0);
            }
            if (this.f_19797_ % 10 == 1) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123756_, this.m_20208_(0.5), this.m_20187_() - 0.5, this.m_20262_(0.5), 0.0, 0.0, 0.0);
            }
        }
        super.m_8107_();
        if (!this.m_9236_().m_5776_() && ModConfigs.cachedServer.MELTY_MONSTER_SET_FIRE_CHANCE > 0.0 && !this.m_20077_() && !this.m_20071_() && !this.m_203117_() && ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)this)) {
            int i = Mth.m_14107_((double)this.m_20185_());
            int j = Mth.m_14107_((double)(this.m_20186_() + 0.125));
            int k = Mth.m_14107_((double)this.m_20189_());
            for (int l = 0; l < 4; ++l) {
                i = Mth.m_14107_((double)(this.m_20185_() + (double)((float)(l % 2 * 2 - 1) * 0.25f)));
                j = Mth.m_14107_((double)(this.m_20186_() + 0.125));
                k = Mth.m_14107_((double)(this.m_20189_() + (double)((float)(l / 2 % 2 * 2 - 1) * 0.25f)));
                BlockPos blockpos = new BlockPos(i, j, k);
                if (!(this.m_217043_().m_188500_() < ModConfigs.cachedServer.MELTY_MONSTER_SET_FIRE_CHANCE) || !this.m_9236_().m_46859_(blockpos)) continue;
                this.m_9236_().m_46597_(blockpos, BaseFireBlock.m_49245_((BlockGetter)this.m_9236_(), (BlockPos)blockpos));
            }
        }
    }

    public boolean m_6126_() {
        return true;
    }

    public boolean m_6060_() {
        return false;
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        double d1 = target.m_20185_() - this.m_20185_();
        double d2 = target.m_20186_() + (double)target.m_20192_() * 0.5 - this.m_20227_(0.5);
        double d3 = target.m_20189_() - this.m_20189_();
        double d4 = Math.sqrt(d1 * d1 + d3 * d3) * 0.02;
        SmallFireball fireballentity = new SmallFireball(this.m_9236_(), (LivingEntity)this, d1 + this.m_217043_().m_188583_() * d4, d2, d3 + this.m_217043_().m_188583_() * d4);
        fireballentity.m_6034_(fireballentity.m_20185_(), this.m_20227_(0.5) + 0.5, fireballentity.m_20189_());
        this.m_9236_().m_7967_((Entity)fireballentity);
        this.m_5496_(SoundEvents.f_11705_, 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
    }

    public static boolean checkMeltyMonsterSpawnRules(EntityType<MeltyMonsterEntity> type, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        BlockPos.MutableBlockPos blockpos$mutable = pos.m_122032_();
        do {
            blockpos$mutable.m_122173_(Direction.UP);
        } while (levelAccessor.m_6425_((BlockPos)blockpos$mutable).m_205070_(FluidTags.f_13132_));
        return levelAccessor.m_8055_((BlockPos)blockpos$mutable).m_60795_() && (spawnType == MobSpawnType.SPAWNER || pos.m_123342_() < (levelAccessor.m_141937_() < 0 ? 0 : 32) || random.m_188499_());
    }

    public boolean m_6914_(LevelReader levelReader) {
        return levelReader.m_45784_((Entity)this);
    }

    public boolean m_203441_(FluidState state) {
        return state.m_205070_(FluidTags.f_13132_);
    }

    protected void m_7840_(double d0, boolean onGround, BlockState blockstate, BlockPos pos) {
        this.m_20101_();
        if (this.m_20077_()) {
            this.f_19789_ = 0.0f;
        } else {
            super.m_7840_(d0, onGround, blockstate, pos);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        this.floatMob();
        this.m_20101_();
    }

    private void floatMob() {
        if (this.m_20077_()) {
            CollisionContext collisioncontext = CollisionContext.m_82750_((Entity)this);
            if (collisioncontext.m_6513_(LiquidBlock.f_54690_, this.m_20183_(), true) && !this.m_9236_().m_6425_(this.m_20183_().m_7494_()).m_205070_(FluidTags.f_13132_)) {
                this.m_6853_(true);
            } else {
                this.m_20256_(this.m_20184_().m_82490_(0.5).m_82520_(0.0, 0.05, 0.0));
            }
        }
    }

    protected PathNavigation m_6037_(Level level) {
        return new StriderPathNavigation(this, level);
    }

    public float m_5610_(BlockPos pos, LevelReader levelReader) {
        if (levelReader.m_8055_(pos).m_60819_().m_205070_(FluidTags.f_13132_)) {
            return 10.0f;
        }
        return this.m_20077_() ? Float.NEGATIVE_INFINITY : 0.0f;
    }

    public boolean m_6063_() {
        return false;
    }

    public int m_5792_() {
        return 3;
    }

    public double m_6049_() {
        return -0.45;
    }

    protected float m_6431_(Pose pose, EntityDimensions size) {
        return 1.74f;
    }

    public float m_213856_() {
        return 1.0f;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12111_;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return SoundEvents.f_12109_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12108_;
    }

    protected void m_7355_(BlockPos pos, BlockState block) {
        this.m_5496_(SoundEvents.f_12112_, 0.15f, 1.0f);
    }

    @Nonnull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    private static class GoToLavaGoal
    extends MoveToBlockGoal {
        private final MeltyMonsterEntity parent;

        private GoToLavaGoal(MeltyMonsterEntity mob, double d0) {
            super((PathfinderMob)mob, d0, 8, 2);
            this.parent = mob;
        }

        public BlockPos m_6669_() {
            return this.f_25602_;
        }

        public boolean m_8045_() {
            return !this.parent.m_20077_() && this.m_6465_((LevelReader)this.parent.m_9236_(), this.f_25602_);
        }

        public boolean m_8036_() {
            return !this.parent.m_20077_() && super.m_8036_();
        }

        protected boolean m_6465_(LevelReader levelReader, BlockPos pos) {
            return levelReader.m_8055_(pos).m_60713_(Blocks.f_49991_) && levelReader.m_8055_(pos.m_7494_()).m_60647_((BlockGetter)levelReader, pos, PathComputationType.LAND);
        }
    }

    private static class StriderPathNavigation
    extends GroundPathNavigation {
        public StriderPathNavigation(MeltyMonsterEntity mob, Level level) {
            super((Mob)mob, level);
        }

        protected PathFinder m_5532_(int maxVisitedNodes) {
            this.f_26508_ = new WalkNodeEvaluator();
            return new PathFinder(this.f_26508_, maxVisitedNodes);
        }

        protected boolean m_7367_(BlockPathTypes blockPathTypes) {
            return blockPathTypes != BlockPathTypes.LAVA && blockPathTypes != BlockPathTypes.DAMAGE_FIRE && blockPathTypes != BlockPathTypes.DANGER_FIRE ? super.m_7367_(blockPathTypes) : true;
        }

        public boolean m_6342_(BlockPos pos) {
            return this.f_26495_.m_8055_(pos).m_60713_(Blocks.f_49991_) || super.m_6342_(pos);
        }
    }
}

