/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.world.entity;

import com.github.mechalopa.hmag.registry.ModParticleTypes;
import com.github.mechalopa.hmag.registry.ModSoundEvents;
import com.github.mechalopa.hmag.util.ModTags;
import com.github.mechalopa.hmag.world.entity.projectile.MagicBulletEntity;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.network.NetworkHooks;

public class NightwalkerEntity
extends Monster
implements RangedAttackMob {
    public NightwalkerEntity(EntityType<? extends NightwalkerEntity> type, Level level) {
        super(type, level);
        this.f_21364_ = 12;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(4, (Goal)new RangedAttackGoal((RangedAttackMob)this, 1.0, 40, 60, 6.0f));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 4.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22279_, 0.22).m_22268_(Attributes.f_22284_, 2.0).m_22268_(Attributes.f_22278_, 0.5).m_22268_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), 1.0);
    }

    public void m_8107_() {
        if (this.m_9236_().m_5776_() && this.f_19797_ % 2 == 0) {
            this.m_9236_().m_7106_((ParticleOptions)ModParticleTypes.NIGHTWALKER.get(), this.m_20208_(0.75), this.m_20187_() - 0.25, this.m_20262_(0.75), (this.m_217043_().m_188500_() - 0.5) * 3.0, -this.m_217043_().m_188500_(), (this.m_217043_().m_188500_() - 0.5) * 3.0);
        }
        super.m_8107_();
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_269533_(ModTags.DamageTypeTags.NIGHTWALKER_RESISTANT_TO)) {
            amount *= 0.5f;
        }
        return super.m_6469_(source, amount);
    }

    public void m_6504_(LivingEntity target, float distance) {
        double d1 = target.m_20185_() - this.m_20185_();
        double d2 = target.m_20186_() + (double)target.m_20192_() * 0.5 - this.m_20227_(0.4);
        double d3 = target.m_20189_() - this.m_20189_();
        double d4 = Math.sqrt(d1 * d1 + d3 * d3) * 0.04;
        MagicBulletEntity bullet = new MagicBulletEntity(this.m_9236_(), (LivingEntity)this, d1 + this.m_217043_().m_188583_() * d4, d2, d3 + this.m_217043_().m_188583_() * d4);
        bullet.m_6034_(bullet.m_20185_(), this.m_20227_(0.4) + 0.25, bullet.m_20189_());
        bullet.setDamage(4.0f);
        bullet.setEffectLevel((byte)1);
        bullet.setVariant(MagicBulletEntity.Variant.NIGHTWALKER);
        this.m_9236_().m_7967_((Entity)bullet);
        this.m_5496_(SoundEvents.f_12417_, 2.0f, (this.m_217043_().m_188501_() - this.m_217043_().m_188501_()) * 0.2f + 1.0f);
    }

    public boolean m_7307_(Entity entity) {
        if (super.m_7307_(entity)) {
            return true;
        }
        if (entity instanceof NightwalkerEntity) {
            return this.m_5647_() == null && entity.m_5647_() == null;
        }
        return false;
    }

    public int m_5792_() {
        return 3;
    }

    public int m_8132_() {
        return 9;
    }

    public int m_8085_() {
        return 30;
    }

    protected float m_6431_(Pose pose, EntityDimensions size) {
        return 2.0f;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSoundEvents.DOLL_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)ModSoundEvents.DOLL_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSoundEvents.DOLL_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState block) {
        this.m_5496_(SoundEvents.f_12450_, 0.5f, 0.25f);
    }

    @Nonnull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

