/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.world.entity;

import com.github.mechalopa.hmag.ModConfigs;
import com.github.mechalopa.hmag.registry.ModSoundEvents;
import com.github.mechalopa.hmag.util.ModTags;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;

public class OgreEntity
extends Monster {
    private static final EntityDataAccessor<Boolean> IS_ARM_SWING = SynchedEntityData.m_135353_(OgreEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int armSwingTimer;
    private float attackAnimation;
    private float attackAnimationO;

    public OgreEntity(EntityType<? extends OgreEntity> type, Level level) {
        super(type, level);
        this.f_21364_ = 25;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackAndDestroyGoal(this, 1.0, true));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        if (ModConfigs.cachedServer.OGRE_ATTACK_VILLAGERS) {
            this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
        }
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        if (ModConfigs.cachedServer.OGRE_ATTACK_BABY_TURTLES) {
            this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Turtle.class, 10, true, false, Turtle.f_30122_));
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_ARM_SWING, (Object)false);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 80.0).m_22268_(Attributes.f_22279_, 0.285).m_22268_(Attributes.f_22281_, 12.0).m_22268_(Attributes.f_22282_, 2.0).m_22268_(Attributes.f_22284_, 8.0).m_22268_(Attributes.f_22278_, 0.5);
    }

    public void m_8119_() {
        if (this.m_9236_().m_5776_()) {
            this.attackAnimationO = this.attackAnimation;
        }
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            this.attackAnimation = this.isArmSwinging() ? Math.min(1.0f, this.attackAnimation + 0.45f) : Math.max(0.0f, this.attackAnimation - 0.08f);
        }
    }

    public void m_8107_() {
        if (!this.m_9236_().m_5776_()) {
            boolean flag = false;
            if (this.armSwingTimer > 0) {
                flag = true;
            }
            if (this.isArmSwinging() != flag) {
                this.setArmSwinging(flag);
            }
        }
        super.m_8107_();
        if (!this.m_9236_().m_5776_() && this.armSwingTimer > 0) {
            --this.armSwingTimer;
        }
    }

    public boolean m_7327_(Entity entity) {
        this.armSwingTimer = 3;
        if (super.m_7327_(entity)) {
            this.playArmSwingSound();
            if (entity instanceof LivingEntity) {
                int i = 0;
                if (this.m_9236_().m_46791_() == Difficulty.NORMAL) {
                    i = 5;
                } else if (this.m_9236_().m_46791_() == Difficulty.HARD) {
                    i = 10;
                }
                if (i > 0) {
                    ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19597_, i * 20, 3));
                }
            }
            return true;
        }
        return false;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_269533_(ModTags.DamageTypeTags.OGRE_HIGHLY_RESISTANT_TO)) {
            amount *= 0.25f;
        } else if (source.m_269533_(ModTags.DamageTypeTags.OGRE_RESISTANT_TO)) {
            amount *= 0.5f;
        }
        if (!this.m_21525_() && !source.m_276093_(DamageTypes.f_268511_) && source.m_269533_(ModTags.DamageTypeTags.TRIGGERS_OGRE_DESTROYING) && this.m_217043_().m_188503_(8) == 0) {
            this.destroyBlock();
        }
        return super.m_6469_(source, amount);
    }

    public static boolean checkOgreSpawnRules(EntityType<? extends OgreEntity> type, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return Monster.m_219013_(type, (ServerLevelAccessor)levelAccessor, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random) && (spawnType == MobSpawnType.SPAWNER || pos.m_123342_() <= ModConfigs.cachedServer.OGRE_SPAWN_MAX_HEIGHT);
    }

    public int m_5792_() {
        return 1;
    }

    public double m_6049_() {
        return -0.6;
    }

    protected float m_6431_(Pose pose, EntityDimensions size) {
        return 2.5f;
    }

    public boolean isArmSwinging() {
        return (Boolean)this.f_19804_.m_135370_(IS_ARM_SWING);
    }

    public void setArmSwinging(boolean flag) {
        this.f_19804_.m_135381_(IS_ARM_SWING, (Object)flag);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getAnimationScale(float f) {
        return Mth.m_14179_((float)f, (float)this.attackAnimationO, (float)this.attackAnimation);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSoundEvents.OGRE_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)ModSoundEvents.OGRE_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSoundEvents.OGRE_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState block) {
        this.m_5496_(SoundEvents.f_11834_, 0.25f, 1.0f);
    }

    protected void playArmSwingSound() {
        this.m_5496_(SoundEvents.f_12601_, 0.5f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
    }

    protected boolean destroyBlock() {
        if (ModConfigs.cachedServer.OGRE_DESTROY_BLOCKS && this.m_9236_().m_46791_().m_19028_() > 1 && ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)this)) {
            int i1 = Mth.m_14107_((double)this.m_20186_());
            int l1 = Mth.m_14107_((double)this.m_20185_());
            int i2 = Mth.m_14107_((double)this.m_20189_());
            boolean flag = false;
            for (int k2 = -1; k2 <= 1; ++k2) {
                for (int l2 = -1; l2 <= 1; ++l2) {
                    for (int j = 0; j <= 3; ++j) {
                        int i3 = l1 + k2;
                        int k = i1 + j;
                        int l = i2 + l2;
                        BlockPos blockpos = new BlockPos(i3, k, l);
                        BlockState blockstate = this.m_9236_().m_8055_(blockpos);
                        if (!this.canDestroyBlock(blockstate, this.m_9236_(), blockpos, (LivingEntity)this, 5.0f)) continue;
                        flag = this.m_9236_().m_46953_(blockpos, true, (Entity)this) || flag;
                    }
                }
            }
            if (flag) {
                this.armSwingTimer = 5;
                this.playArmSwingSound();
            }
            return flag;
        }
        return false;
    }

    private boolean canDestroyBlock(BlockState state, Level level, BlockPos pos, LivingEntity livingEntity, float maxHardness) {
        if (state.m_204336_(ModTags.BlockTags.OGRE_IMMUNE) || state.m_60795_() || state.m_278721_() || !state.canEntityDestroy((BlockGetter)this.m_9236_(), pos, (Entity)this) || !ForgeEventFactory.onEntityDestroyBlock((LivingEntity)this, (BlockPos)pos, (BlockState)state)) {
            return false;
        }
        float f = state.m_60800_((BlockGetter)level, pos);
        return f >= 0.0f && f <= maxHardness && f / maxHardness <= this.m_217043_().m_188501_() + 0.05f && this.m_217043_().m_188499_();
    }

    @Nonnull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    private class MeleeAttackAndDestroyGoal
    extends MeleeAttackGoal {
        public MeleeAttackAndDestroyGoal(OgreEntity mob, double speed, boolean useLongMemory) {
            super((PathfinderMob)mob, speed, useLongMemory);
        }

        protected void m_6739_(LivingEntity attackTarget, double distToEnemySqr) {
            double d0 = this.m_6639_(attackTarget);
            if (this.m_25565_() <= 0) {
                if (distToEnemySqr <= d0) {
                    this.m_25563_();
                    this.f_25540_.m_6674_(InteractionHand.MAIN_HAND);
                    this.f_25540_.m_7327_((Entity)attackTarget);
                } else if ((distToEnemySqr < 100.0 && !this.f_25540_.m_21574_().m_148306_((Entity)attackTarget) || distToEnemySqr < 9.0) && this.f_25540_.m_217043_().m_188503_(12) == 0) {
                    OgreEntity.this.destroyBlock();
                }
            }
        }
    }
}

