/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.world.entity;

import com.github.mechalopa.hmag.ModConfigs;
import com.github.mechalopa.hmag.registry.ModSoundEvents;
import com.github.mechalopa.hmag.util.ModTags;
import com.github.mechalopa.hmag.world.entity.ai.goal.MeleeAttackGoal2;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.CaveSpider;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkHooks;

public class SpiderNestEntity
extends Monster {
    private static final EntityDataAccessor<Integer> SUMMON_DELAY = SynchedEntityData.m_135353_(SpiderNestEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public SpiderNestEntity(EntityType<? extends SpiderNestEntity> type, Level level) {
        super(type, level);
        this.f_21364_ = 15;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackAndSummonGoal(this, 1.0, false, 120, 10.0f, 2));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SUMMON_DELAY, (Object)60);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 60.0).m_22268_(Attributes.f_22279_, 0.175).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22284_, 8.0).m_22268_(Attributes.f_22278_, 0.75);
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public void m_8107_() {
        if (this.m_9236_().m_5776_()) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123783_, this.m_20208_(0.75), this.m_20187_() - 0.25, this.m_20262_(0.75), (this.m_217043_().m_188500_() - 0.5) * 3.0, -this.m_217043_().m_188500_(), (this.m_217043_().m_188500_() - 0.5) * 3.0);
        }
        super.m_8107_();
    }

    public boolean m_7327_(Entity entity) {
        if (super.m_7327_(entity)) {
            if (entity instanceof LivingEntity) {
                int i = 0;
                if (this.m_9236_().m_46791_() == Difficulty.NORMAL) {
                    i = 7;
                } else if (this.m_9236_().m_46791_() == Difficulty.HARD) {
                    i = 15;
                }
                if (i > 0) {
                    ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19614_, i * 20, 0));
                    ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19597_, i * 20, 1));
                }
            }
            return true;
        }
        return false;
    }

    public void m_142687_(Entity.RemovalReason reason) {
        if (!this.m_9236_().m_5776_() && ModConfigs.cachedServer.SPIDER_NEST_SUMMON_CAVE_SPIDER && !this.m_21525_() && this.m_21224_()) {
            this.summonSpider((ServerLevel)this.m_9236_(), (LivingEntity)this, this.m_5448_(), this.m_217043_(), 2 + this.m_217043_().m_188503_(3));
        }
        super.m_142687_(reason);
    }

    public void m_7601_(BlockState state, Vec3 stuckSpeedMultiplier) {
        if (!state.m_60713_(Blocks.f_50033_)) {
            super.m_7601_(state, stuckSpeedMultiplier);
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_269533_(ModTags.DamageTypeTags.SPIDER_NEST_VULNERABLE_TO)) {
            amount *= 1.5f;
        }
        if (source.m_269533_(ModTags.DamageTypeTags.SPIDER_NEST_RESISTANT_TO)) {
            amount *= 0.5f;
        }
        return super.m_6469_(source, amount);
    }

    public boolean m_7301_(MobEffectInstance potioneffect) {
        if (ModTags.checkTagContains(potioneffect.m_19544_(), ModTags.MobEffectTags.SPIDER_NEST_IMMUNE_TO)) {
            MobEffectEvent.Applicable event = new MobEffectEvent.Applicable((LivingEntity)this, potioneffect);
            MinecraftForge.EVENT_BUS.post((Event)event);
            return event.getResult() == Event.Result.ALLOW;
        }
        return super.m_7301_(potioneffect);
    }

    private void summonSpider(ServerLevel serverlevel, LivingEntity attacker, LivingEntity target, RandomSource random, int count) {
        for (int i = 0; i < count; ++i) {
            double d1 = attacker.m_20185_() + (random.m_188500_() - random.m_188500_()) * 1.5;
            double d2 = attacker.m_20186_() + 0.5;
            double d3 = attacker.m_20189_() + (random.m_188500_() - random.m_188500_()) * 1.5;
            CaveSpider cavespider = (CaveSpider)EntityType.f_20554_.m_20615_(attacker.m_9236_());
            cavespider.m_7678_(d1, d2, d3, random.m_188501_() * 360.0f, 0.0f);
            cavespider.m_6518_((ServerLevelAccessor)serverlevel, attacker.m_9236_().m_6436_(attacker.m_20183_()), MobSpawnType.MOB_SUMMONED, (SpawnGroupData)null, (CompoundTag)null);
            serverlevel.m_47205_((Entity)cavespider);
            if (target != null && target.m_6084_()) {
                cavespider.m_6710_(target);
            }
            cavespider.getPersistentData().m_128379_("hmag.withSpawnParticle", true);
            attacker.m_9236_().m_142346_((Entity)cavespider, GameEvent.f_157810_, cavespider.m_20183_());
        }
        attacker.m_9236_().m_46796_(2004, attacker.m_20183_(), 0);
        attacker.m_5496_((SoundEvent)ModSoundEvents.SPIDER_NEST_SUMMON.get(), 1.0f, 1.0f);
    }

    public static boolean checkSpiderNestSpawnRules(EntityType<? extends SpiderNestEntity> type, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return Monster.m_219013_(type, (ServerLevelAccessor)levelAccessor, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random) && (spawnType == MobSpawnType.SPAWNER || pos.m_123342_() <= ModConfigs.cachedServer.SPIDER_NEST_SPAWN_MAX_HEIGHT);
    }

    public int m_5792_() {
        return 2;
    }

    protected float m_6431_(Pose pose, EntityDimensions size) {
        return 1.1f;
    }

    public int m_8132_() {
        return 30;
    }

    public int m_8085_() {
        return 30;
    }

    public boolean isCharging() {
        return this.getSummonDelay() <= 20;
    }

    public int getSummonDelay() {
        return (Integer)this.f_19804_.m_135370_(SUMMON_DELAY);
    }

    private void setSummonDelay(int value) {
        this.f_19804_.m_135381_(SUMMON_DELAY, (Object)value);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Delay", this.getSummonDelay());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setSummonDelay(compound.m_128448_("Delay"));
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSoundEvents.SPIDER_NEST_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)ModSoundEvents.SPIDER_NEST_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSoundEvents.SPIDER_NEST_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState block) {
        this.m_5496_(SoundEvents.f_12345_, 0.15f, 1.0f);
    }

    @Nonnull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    private class MeleeAttackAndSummonGoal
    extends MeleeAttackGoal2 {
        private final int summonInterval;
        private final float summonRadius;
        private final int maxSpawn;
        private final TargetingConditions caveSpiderCountTargeting;

        public MeleeAttackAndSummonGoal(SpiderNestEntity mob, double speedIn, boolean useLongMemory, int intervalIn, float radiusIn, int maxSpawnIn) {
            super((PathfinderMob)mob, speedIn, useLongMemory, 0.625f);
            this.caveSpiderCountTargeting = TargetingConditions.m_148353_().m_26883_(12.0).m_148355_().m_26893_();
            this.summonInterval = intervalIn;
            this.summonRadius = radiusIn;
            this.maxSpawn = maxSpawnIn;
        }

        @Override
        public void m_8041_() {
            super.m_8041_();
            this.resetTimer(SpiderNestEntity.this);
        }

        @Override
        public void m_8037_() {
            LivingEntity target;
            SpiderNestEntity attacker;
            double d0;
            if (ModConfigs.cachedServer.SPIDER_NEST_SUMMON_CAVE_SPIDER && (d0 = (attacker = SpiderNestEntity.this).m_20275_((target = attacker.m_5448_()).m_20185_(), target.m_20186_(), target.m_20189_())) <= (double)(this.summonRadius * this.summonRadius) && attacker.m_142582_((Entity)target)) {
                if (attacker.getSummonDelay() == -1) {
                    this.resetTimer(attacker);
                }
                if (attacker.getSummonDelay() > 0) {
                    attacker.setSummonDelay(attacker.getSummonDelay() - 1);
                } else if (attacker.m_9236_().m_45971_(CaveSpider.class, this.caveSpiderCountTargeting, (LivingEntity)attacker, attacker.m_20191_().m_82400_(12.0)).size() >= 6) {
                    attacker.setSummonDelay(20);
                } else {
                    attacker.summonSpider((ServerLevel)attacker.m_9236_(), (LivingEntity)attacker, target, attacker.m_217043_(), 1 + attacker.m_217043_().m_188503_(this.maxSpawn));
                    this.resetTimer(attacker);
                }
            }
            super.m_8037_();
        }

        private void resetTimer(SpiderNestEntity attackerIn) {
            attackerIn.setSummonDelay(this.summonInterval + attackerIn.m_217043_().m_188503_(this.summonInterval / 2));
        }
    }
}

