/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.world.entity.projectile;

import com.github.mechalopa.hmag.registry.ModEntityTypes;
import com.github.mechalopa.hmag.registry.ModParticleTypes;
import com.github.mechalopa.hmag.world.entity.LichEntity;
import com.github.mechalopa.hmag.world.entity.projectile.ModDamagingProjectileEntity;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.function.IntFunction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PlayMessages;

public class MagicBulletEntity
extends ModDamagingProjectileEntity
implements VariantHolder<Variant> {
    private static final EntityDataAccessor<Integer> DATA_VARIANT_ID = SynchedEntityData.m_135353_(MagicBulletEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Byte> EFFECT_LEVEL = SynchedEntityData.m_135353_(MagicBulletEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Byte> PIERCE_LEVEL = SynchedEntityData.m_135353_(MagicBulletEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private IntOpenHashSet piercingIgnoreEntityIds;

    public MagicBulletEntity(EntityType<? extends MagicBulletEntity> type, Level level) {
        super(type, level);
    }

    public MagicBulletEntity(Level level, LivingEntity shooter, double accelX, double accelY, double accelZ) {
        super((EntityType<? extends ModDamagingProjectileEntity>)((EntityType)ModEntityTypes.MAGIC_BULLET.get()), shooter, accelX, accelY, accelZ, level);
    }

    @OnlyIn(value=Dist.CLIENT)
    public MagicBulletEntity(Level level, double x, double y, double z, double accelX, double accelY, double accelZ) {
        super((EntityType<? extends ModDamagingProjectileEntity>)((EntityType)ModEntityTypes.MAGIC_BULLET.get()), x, y, z, accelX, accelY, accelZ, level);
    }

    public MagicBulletEntity(PlayMessages.SpawnEntity spawnEntity, Level level) {
        this((EntityType<? extends MagicBulletEntity>)((EntityType)ModEntityTypes.MAGIC_BULLET.get()), level);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_VARIANT_ID, (Object)Variant.LICH.getId());
        this.f_19804_.m_135372_(EFFECT_LEVEL, (Object)1);
        this.f_19804_.m_135372_(PIERCE_LEVEL, (Object)0);
    }

    protected float m_6884_() {
        switch (this.getVariant()) {
            case DYSSOMNIA: {
                return 0.87f;
            }
            case NEMESIS: {
                return 0.98f;
            }
        }
        return 0.9f;
    }

    @Override
    protected void tick2() {
        if (this.getVariant() == Variant.NEMESIS) {
            if (!(this.m_9236_().m_5776_() || this.f_19797_ < 60 && this.m_19749_() != null)) {
                this.m_146870_();
            }
            if (this.m_9236_().m_5776_()) {
                this.m_9236_().m_7106_((ParticleOptions)ModParticleTypes.NEMESIS_FLAME.get(), this.m_20208_(0.5), this.m_20227_(this.f_19796_.m_188500_() * 0.5), this.m_20262_(0.5), 0.0, 0.0, 0.0);
            }
        } else {
            super.tick2();
        }
    }

    protected void m_5790_(EntityHitResult result) {
        super.m_5790_(result);
        Entity entity = result.m_82443_();
        Vec3 vec3 = this.m_20184_().m_82542_(1.0, 0.0, 1.0).m_82541_();
        if (this.getPierceLevel() > 0) {
            if (this.piercingIgnoreEntityIds == null) {
                this.piercingIgnoreEntityIds = new IntOpenHashSet(5);
            }
            if (this.piercingIgnoreEntityIds.size() < this.getPierceLevel() + 1) {
                this.piercingIgnoreEntityIds.add(entity.m_19879_());
            }
        }
        if (!this.m_9236_().m_5776_()) {
            boolean flag;
            Entity entity1 = this.m_19749_();
            float damage = this.getDamage();
            if (entity1 != null && entity1 instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)entity1;
                if (this.getVariant() == Variant.LICH && livingentity instanceof LichEntity && entity instanceof Vex && livingentity.m_7307_(entity)) {
                    damage *= 5.0f;
                }
                if ((flag = entity.m_6469_(this.m_269291_().m_269104_((Entity)this, (Entity)livingentity), damage)) && entity.m_6084_()) {
                    this.m_19970_(livingentity, entity);
                }
            } else {
                flag = entity.m_6469_(this.m_269291_().m_269425_(), damage);
            }
            if (flag && entity instanceof LivingEntity && this.getEffectLevel() > 0) {
                int i = 0;
                switch (this.getVariant()) {
                    case LICH: {
                        if (this.m_9236_().m_46791_() == Difficulty.NORMAL) {
                            i = 7;
                        } else if (this.m_9236_().m_46791_() == Difficulty.HARD) {
                            i = 15;
                        }
                        if (i <= 0) break;
                        ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19613_, 20 * i, 0));
                        break;
                    }
                    case DYSSOMNIA: {
                        if (this.m_9236_().m_46791_() == Difficulty.NORMAL) {
                            i = 5;
                        } else if (this.m_9236_().m_46791_() == Difficulty.HARD) {
                            i = 10;
                        }
                        if (i <= 0) break;
                        ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19610_, 20 * i, 0));
                        break;
                    }
                    case NEMESIS: {
                        i = (this.getEffectLevel() * 2 + 4) * 20;
                        ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19613_, i, 1));
                        ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19597_, i, 1));
                        ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19599_, i, 1));
                        ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19615_, i, 1));
                        if (!(vec3.m_82556_() > 0.0)) break;
                        ((LivingEntity)entity).m_147240_((double)(1.0f * ((float)this.getEffectLevel() / 12.0f) + 0.1f), -vec3.f_82479_, -vec3.f_82481_);
                        break;
                    }
                    case NIGHTWALKER: {
                        if (this.m_9236_().m_46791_() == Difficulty.NORMAL) {
                            i = 7;
                        } else if (this.m_9236_().m_46791_() == Difficulty.HARD) {
                            i = 15;
                        }
                        if (i <= 0) break;
                        ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19599_, 20 * i, 0));
                    }
                }
            }
            this.m_9236_().m_7605_((Entity)this, (byte)3);
        }
    }

    protected boolean m_5603_(Entity entity) {
        return super.m_5603_(entity) && this.m_19749_() != null && !this.m_19749_().equals((Object)entity) && (this.piercingIgnoreEntityIds == null || !this.piercingIgnoreEntityIds.contains(entity.m_19879_()));
    }

    @Override
    protected void onHitServer(HitResult result) {
        if (result.m_6662_() != HitResult.Type.ENTITY || this.getPierceLevel() <= 0 || this.piercingIgnoreEntityIds.size() >= this.getPierceLevel() + 1) {
            this.m_146870_();
        }
    }

    public void m_7350_(EntityDataAccessor<?> data) {
        if (DATA_VARIANT_ID.equals(data)) {
            this.m_6210_();
        }
        super.m_7350_(data);
    }

    public EntityDimensions m_6972_(Pose pose) {
        if (this.getVariant() == Variant.NEMESIS) {
            return super.m_6972_(pose).m_20388_(1.6f);
        }
        return super.m_6972_(pose);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        if (id == 3 && this.getVariant() == Variant.NEMESIS) {
            for (int i = 0; i < 12; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ModParticleTypes.NEMESIS_FLAME.get(), this.m_20208_(1.75), this.m_20227_(this.f_19796_.m_188500_() * 1.75), this.m_20262_(1.75), 0.0, 0.0, 0.0);
            }
        }
    }

    public boolean m_20069_() {
        return false;
    }

    public Variant getVariant() {
        return Variant.byId((Integer)this.f_19804_.m_135370_(DATA_VARIANT_ID));
    }

    public void setVariant(Variant variant) {
        this.f_19804_.m_135381_(DATA_VARIANT_ID, (Object)variant.getId());
    }

    public void setPierceLevel(byte amount) {
        this.f_19804_.m_135381_(PIERCE_LEVEL, (Object)amount);
    }

    public byte getPierceLevel() {
        return (Byte)this.f_19804_.m_135370_(PIERCE_LEVEL);
    }

    public void setEffectLevel(byte amount) {
        this.f_19804_.m_135381_(EFFECT_LEVEL, (Object)amount);
    }

    public byte getEffectLevel() {
        return (Byte)this.f_19804_.m_135370_(EFFECT_LEVEL);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setVariant(Variant.byId(compound.m_128451_("Variant")));
        this.setPierceLevel(compound.m_128445_("PierceLevel"));
        this.setEffectLevel(compound.m_128445_("EffectLevel"));
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Variant", this.getVariant().getId());
        compound.m_128344_("PierceLevel", this.getPierceLevel());
        compound.m_128344_("EffectLevel", this.getEffectLevel());
    }

    protected ParticleOptions m_5967_() {
        switch (this.getVariant()) {
            case DYSSOMNIA: {
                return ParticleTypes.f_123755_;
            }
            case NEMESIS: {
                return ParticleTypes.f_123762_;
            }
            case NIGHTWALKER: {
                return (ParticleOptions)ModParticleTypes.NIGHTWALKER_BULLET.get();
            }
        }
        return ParticleTypes.f_123799_;
    }

    public static enum Variant implements StringRepresentable
    {
        LICH(0, "lich"),
        DYSSOMNIA(1, "dyssomnia"),
        NEMESIS(2, "nemesis"),
        NIGHTWALKER(3, "nightwalker");

        private static final IntFunction<Variant> BY_ID;
        public static final Codec<Variant> CODEC;
        private final int id;
        private final String name;

        private Variant(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }

        public int getId() {
            return this.id;
        }

        public static Variant byId(int id) {
            return BY_ID.apply(id);
        }

        static {
            BY_ID = ByIdMap.m_262839_(Variant::getId, (Object[])Variant.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
            CODEC = StringRepresentable.m_216439_(Variant::values);
        }
    }
}

