/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.world.item;

import com.github.mechalopa.hmag.util.ModTags;
import com.github.mechalopa.hmag.world.entity.projectile.MagicBulletEntity;
import com.github.mechalopa.hmag.world.item.ILevelItem;
import com.github.mechalopa.hmag.world.item.ModSwordItem;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class NemesisBladeItem
extends ModSwordItem
implements ILevelItem {
    public static final UUID NEMESIS_BLADE_ATTACK_DAMAGE_UUID = UUID.fromString("FD835C41-1211-AC72-0CD4-66F3061FB156");
    public static final UUID NEMESIS_BLADE_ATTACK_SPEED_UUID = UUID.fromString("1911699B-779B-820E-064A-112D1EB232F7");
    public static final UUID NEMESIS_BLADE_MOVEMENT_SPEED_UUID = UUID.fromString("C80A68DD-F985-4245-4EC4-64884C8EBA4C");
    public static final AttributeModifier NEMESIS_BLADE_MOVEMENT_SPEED_MODIFIER = new AttributeModifier(NEMESIS_BLADE_MOVEMENT_SPEED_UUID, "Nemesis blade move speed penalty", -0.5, AttributeModifier.Operation.MULTIPLY_TOTAL);

    public NemesisBladeItem(Tier tier, Item.Properties builder) {
        super(tier, 4.0f, -3.5f, 2537, 17, builder);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean isSelected) {
        if (!level.f_46443_ && entity instanceof Player) {
            CompoundTag compoundnbt = stack.m_41784_();
            int itemLevel = !compoundnbt.m_128441_("hmag.level") ? 0 : compoundnbt.m_128445_("hmag.level");
            int i = Math.max(((Player)entity).f_36078_, 0);
            int j = 0;
            if (i < 30) {
                j = 6 - i / 5;
            }
            if (itemLevel != j) {
                compoundnbt.m_128344_("hmag.level", (byte)j);
            }
        }
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attaker) {
        if (super.m_7579_(stack, target, attaker)) {
            int i = ILevelItem.getItemLevel(stack);
            if (i > 0) {
                int j = attaker.m_217043_().m_188503_(3);
                target.m_7292_(new MobEffectInstance(j == 2 ? MobEffects.f_19613_ : (j == 1 ? MobEffects.f_19597_ : MobEffects.f_19599_), (i + 4) * 20, 0));
            }
            return true;
        }
        return false;
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity livingEntity, int count) {
        if (livingEntity instanceof Player) {
            int i = ILevelItem.getItemLevel(stack);
            Player player = (Player)livingEntity;
            if (this.m_8105_(stack) - count < 8 || (player.f_36078_ <= 0 || i <= 0) && !player.m_7500_()) {
                return;
            }
            if (!level.f_46443_) {
                MagicBulletEntity bullet = new MagicBulletEntity(level, (LivingEntity)player, 0.0, 0.0, 0.0);
                bullet.m_6034_(bullet.m_20185_(), player.m_20227_(0.5), bullet.m_20189_());
                bullet.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 1.2f, 0.1f);
                bullet.setDamage((float)i * 3.0f + 6.0f);
                bullet.setPierceLevel((byte)Mth.m_14045_((int)(i - 1), (int)0, (int)255));
                bullet.setEffectLevel((byte)Mth.m_14045_((int)i, (int)0, (int)255));
                bullet.setVariant(MagicBulletEntity.Variant.NEMESIS);
                stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(player.m_7655_()));
                level.m_7967_((Entity)bullet);
                if (!player.m_7500_()) {
                    player.m_6749_(-1);
                }
            }
            player.m_6674_(player.m_7655_());
            level.m_6263_((Player)null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12558_, SoundSource.PLAYERS, 0.75f, level.m_213780_().m_188501_() * 0.2f + 0.9f);
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        }
    }

    public void m_5929_(Level level, LivingEntity livingEntity, ItemStack stack, int count) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (this.m_8105_(stack) - count != 8 || (player.f_36078_ <= 0 || ILevelItem.getItemLevel(stack) <= 0) && !player.m_7500_()) {
                return;
            }
            level.m_6263_((Player)null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11841_, SoundSource.PLAYERS, 1.0f, 1.0f / (level.m_213780_().m_188501_() * 0.5f + 1.0f) + 0.2f);
        }
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        boolean flag;
        ItemStack stack = player.m_21120_(hand);
        boolean bl = flag = player.f_36078_ > 0 && ILevelItem.getItemLevel(stack) > 0 || player.m_7500_();
        if (flag && player.m_6047_()) {
            player.m_6672_(hand);
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag tooltipFlag) {
        int i = ILevelItem.getItemLevel(stack);
        list.add((Component)Component.m_237110_((String)"text.hmag.level", (Object[])new Object[]{i + 1}).m_130940_(i >= 6 ? ChatFormatting.LIGHT_PURPLE : (i >= 5 ? ChatFormatting.AQUA : (i >= 3 ? ChatFormatting.YELLOW : (i <= 0 ? ChatFormatting.RED : ChatFormatting.GRAY)))));
    }

    public boolean m_41386_(DamageSource damageSource) {
        return !damageSource.m_269533_(DamageTypeTags.f_268738_) ? false : super.m_41386_(damageSource);
    }

    public boolean m_6832_(ItemStack stack, ItemStack stack1) {
        return stack1.m_204117_(ModTags.ItemTags.NEMESIS_BLADE_REPAIR_ITEMS);
    }

    @Override
    public int getMaxLevel() {
        return 6;
    }
}

