/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.world.item.crafting;

import com.github.mechalopa.hmag.HMaG;
import com.github.mechalopa.hmag.util.ModUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.registries.ForgeRegistries;

public class EnchantmentUpgradeManager
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final String DIRECTORY = "hmag/enchantment_upgrade";
    public static final EnchantmentUpgradeManager INSTANCE = new EnchantmentUpgradeManager();
    private static HashMap<EnchantmentUpgradeProp, Integer> PROP_MAP = new HashMap();

    public EnchantmentUpgradeManager() {
        super(GSON, DIRECTORY);
    }

    protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager manager, ProfilerFiller filler) {
        PROP_MAP.clear();
        map.forEach((r, jsonElement) -> {
            try {
                DataResult dataResult = ValuesCodec.CODEC.parse((DynamicOps)JsonOps.INSTANCE, jsonElement);
                dataResult.resultOrPartial(result -> {}).ifPresent(this::addToPropMap);
            }
            catch (Exception e) {
                HMaG.LOGGER.error("Failed to parse enchantment upgrade file {}", r, (Object)e);
            }
        });
    }

    private void addToPropMap(ValuesCodec codec) {
        codec.values().forEach(p -> PROP_MAP.put(new EnchantmentUpgradeProp(p.addition, p.template, p.enchantment, Math.max(p.min, 0), Math.max(p.max, p.min)), 0));
    }

    public void updateFromServer(HashMap<EnchantmentUpgradeProp, Integer> map) {
        PROP_MAP = map;
    }

    public static void encodeMap(HashMap<EnchantmentUpgradeProp, Integer> map, FriendlyByteBuf buf) {
        buf.m_130130_(map.size());
        for (EnchantmentUpgradeProp prop : map.keySet()) {
            buf.m_130070_(ForgeRegistries.ITEMS.getKey((Object)prop.getAddition()).toString());
            buf.m_130070_(ForgeRegistries.ITEMS.getKey((Object)prop.getTemplate()).toString());
            buf.m_130070_(prop.getEnchantmentKey());
            buf.m_130130_(prop.getMinLevel());
            buf.m_130130_(prop.getMaxLevel());
        }
    }

    public static HashMap<EnchantmentUpgradeProp, Integer> decodeMap(FriendlyByteBuf buf) {
        HashMap<EnchantmentUpgradeProp, Integer> map = new HashMap<EnchantmentUpgradeProp, Integer>();
        int size = buf.m_130242_();
        for (int i = 0; i < size; ++i) {
            Item addition = EnchantmentUpgradeManager.getItemSupplier(buf.m_130277_()).get();
            Item template = EnchantmentUpgradeManager.getItemSupplier(buf.m_130277_()).get();
            String enchantmentKey = buf.m_130277_();
            int minLevel = buf.m_130242_();
            int maxLevel = buf.m_130242_();
            map.put(new EnchantmentUpgradeProp(addition, template, enchantmentKey, minLevel, maxLevel), i);
        }
        return map;
    }

    private static Supplier<Item> getItemSupplier(String name) {
        return (Supplier)ForgeRegistries.ITEMS.getHolder(ModUtils.getRL(name)).orElseThrow();
    }

    @Nullable
    private static Enchantment getEnchantment(String name) {
        Optional optional = ForgeRegistries.ENCHANTMENTS.getHolder(ModUtils.getRL(name));
        return optional.isPresent() ? (Enchantment)((Holder)optional.orElseThrow()).get() : null;
    }

    public static HashMap<EnchantmentUpgradeProp, Integer> getPropMap() {
        return PROP_MAP;
    }

    public record ValuesCodec(List<PropCodec> values) {
        public static final Codec<ValuesCodec> CODEC = RecordCodecBuilder.create(p -> p.group((App)PropCodec.CODEC.listOf().fieldOf("values").forGetter(ValuesCodec::values)).apply((Applicative)p, ValuesCodec::new));
    }

    public static class EnchantmentUpgradeProp {
        private final Item addition;
        private final Item template;
        private final String enchantmentKey;
        private final Enchantment enchantment;
        private final int minLevel;
        private final int maxLevel;

        public EnchantmentUpgradeProp(Item addition, Item template, String enchantmentKey, int min, int max) {
            this.addition = addition;
            this.template = template;
            this.enchantmentKey = enchantmentKey;
            this.enchantment = EnchantmentUpgradeManager.getEnchantment(enchantmentKey);
            this.minLevel = min;
            this.maxLevel = max;
        }

        public Item getAddition() {
            return this.addition;
        }

        public Item getTemplate() {
            return this.template;
        }

        public String getEnchantmentKey() {
            return this.enchantmentKey;
        }

        @Nullable
        public Enchantment getEnchantment() {
            return this.enchantment;
        }

        public int getMinLevel() {
            return this.minLevel;
        }

        public int getMaxLevel() {
            return this.maxLevel;
        }

        public boolean isValid() {
            return this.getEnchantment() != null && this.getAddition() != Items.f_42127_ && this.getTemplate() != Items.f_42127_;
        }
    }

    public record PropCodec(Item addition, Item template, String enchantment, int min, int max) {
        public static final Codec<PropCodec> CODEC = RecordCodecBuilder.create(p -> p.group((App)ForgeRegistries.ITEMS.getCodec().optionalFieldOf("addition", (Object)Items.f_42127_).forGetter(PropCodec::addition), (App)ForgeRegistries.ITEMS.getCodec().optionalFieldOf("template", (Object)Items.f_42127_).forGetter(PropCodec::template), (App)Codec.STRING.fieldOf("enchantment").forGetter(PropCodec::enchantment), (App)Codec.INT.optionalFieldOf("minLevel", (Object)0).forGetter(PropCodec::min), (App)Codec.INT.optionalFieldOf("maxLevel", (Object)0).forGetter(PropCodec::max)).apply((Applicative)p, PropCodec::new));
    }
}

